/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.preferences;

import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.FocusCellOwnerDrawHighlighter;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TableViewerFocusCellManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.ServerManager;
import org.eclipse.jubula.client.ui.validator.cell.PortCellEditorValidator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AutAgentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final int LAYOUT_NUM_COLUMNS = 2;
    private static final int DEFAULT_PORT = 60000;
    private static final String DEFAULT_HOSTNAME = "localhost";
    private TableViewer m_addressViewer;
    private List<ServerManager.Server> m_viewModel;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.prefPageServerContextId");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        this.m_addressViewer = this.createTableViewer(composite);
        TableViewerFocusCellManager focusCellManager = new TableViewerFocusCellManager(this.m_addressViewer, (FocusCellHighlighter)new FocusCellOwnerDrawHighlighter((ColumnViewer)this.m_addressViewer));
        ColumnViewerEditorActivationStrategy actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)this.m_addressViewer){

            protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                return event.eventType == 5 || event.eventType == 3 || event.eventType == 1 && event.keyCode == 13 || event.eventType == 4;
            }
        };
        TableViewerEditor.create((TableViewer)this.m_addressViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
        this.m_viewModel = new LinkedList<ServerManager.Server>();
        if (ServerManager.getInstance().getServers() != null) {
            this.m_viewModel.addAll(ServerManager.getInstance().getServers());
        }
        this.m_addressViewer.setInput(this.m_viewModel);
        this.createButtons(composite);
        return composite;
    }

    private void createButtons(Composite parent) {
        Button addButton = new Button(parent, 0);
        addButton.setText(Messages.AutAgentPreferencePageButtonAdd);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                ServerManager.Server newServer = new ServerManager.Server(AutAgentPreferencePage.DEFAULT_HOSTNAME, 60000);
                AutAgentPreferencePage.this.m_viewModel.add(newServer);
                AutAgentPreferencePage.this.m_addressViewer.refresh();
                AutAgentPreferencePage.this.m_addressViewer.editElement((Object)newServer, 0);
            }
        });
        Button deleteButton = new Button(parent, 0);
        deleteButton.setText(Messages.AutAgentPreferencePageButtonDelete);
        deleteButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection sel = (IStructuredSelection)AutAgentPreferencePage.this.m_addressViewer.getSelection();
                AutAgentPreferencePage.this.m_viewModel.remove(sel.getFirstElement());
                AutAgentPreferencePage.this.m_addressViewer.refresh();
            }
        });
    }

    public boolean performOk() {
        ServerManager.getInstance().setServers(new TreeSet<ServerManager.Server>(this.m_viewModel));
        ServerManager.getInstance().storeServerList();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.AutAgentPreferencePageDescription);
    }

    private TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 65540);
        Table addressTable = viewer.getTable();
        addressTable.setLinesVisible(true);
        addressTable.setHeaderVisible(true);
        GridData layoutData = new GridData(4, 4, true, true);
        layoutData.horizontalSpan = 2;
        addressTable.setLayoutData((Object)layoutData);
        viewer.setContentProvider((IContentProvider)new AddressContentProvider());
        TableLayout tableLayout = new TableLayout();
        addressTable.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 100));
        TableViewerColumn column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.AutAgentPreferencePageColumnHeaderHostName);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((ServerManager.Server)element).getName();
            }
        });
        column.setEditingSupport((EditingSupport)new ServerHostNameEditingSupport((ColumnViewer)viewer));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 100));
        column = new TableViewerColumn(viewer, 0);
        column.getColumn().setText(Messages.AutAgentPreferencePageColumnHeaderPort);
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return String.valueOf(((ServerManager.Server)element).getPort());
            }
        });
        column.setEditingSupport((EditingSupport)new ServerPortEditingSupport((ColumnViewer)viewer));
        addressTable.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 4) {
                    event.doit = false;
                }
            }
        });
        return viewer;
    }

    private static class AddressContentProvider
    implements IStructuredContentProvider {
        private AddressContentProvider() {
        }

        public Object[] getElements(Object input) {
            return ((List)input).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class ServerHostNameEditingSupport
    extends EditingSupport {
        public ServerHostNameEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            return new TextCellEditor((Composite)this.getViewer().getControl());
        }

        protected Object getValue(Object element) {
            return ((ServerManager.Server)element).getName();
        }

        protected void setValue(Object element, Object value) {
            String hostNameValue = String.valueOf(value);
            ((ServerManager.Server)element).setName(hostNameValue);
            this.getViewer().update(element, null);
        }
    }

    private class ServerPortEditingSupport
    extends EditingSupport {
        public ServerPortEditingSupport(ColumnViewer viewer) {
            super(viewer);
        }

        protected boolean canEdit(Object element) {
            return true;
        }

        protected CellEditor getCellEditor(Object element) {
            final TextCellEditor editor = new TextCellEditor((Composite)this.getViewer().getControl());
            editor.setValidator((ICellEditorValidator)new PortCellEditorValidator(Messages.AutAgentPreferencePageColumnHeaderPort));
            editor.addListener(new ICellEditorListener(){

                public void applyEditorValue() {
                    AutAgentPreferencePage.this.setErrorMessage(null);
                }

                public void cancelEditor() {
                    AutAgentPreferencePage.this.setErrorMessage(null);
                }

                public void editorValueChanged(boolean oldValidState, boolean newValidState) {
                    if (newValidState) {
                        editor.getControl().setBackground(null);
                    } else {
                        editor.getControl().setBackground(editor.getControl().getDisplay().getSystemColor(3));
                    }
                    AutAgentPreferencePage.this.setErrorMessage(editor.getErrorMessage());
                }
            });
            return editor;
        }

        protected Object getValue(Object element) {
            return String.valueOf(((ServerManager.Server)element).getPort());
        }

        protected void setValue(Object element, Object value) {
            try {
                ((ServerManager.Server)element).setPort(this.getPortValue(value));
                this.getViewer().update(element, null);
            }
            catch (NumberFormatException numberFormatException) {}
        }

        private int getPortValue(Object value) throws NumberFormatException {
            return Integer.parseInt(String.valueOf(value));
        }
    }
}

