/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.provider.labelprovider;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.utils.GuiParamValueConverter;
import org.eclipse.jubula.client.core.utils.IParamValueValidator;
import org.eclipse.jubula.client.core.utils.NullValidator;
import org.eclipse.jubula.client.ui.businessprocess.WorkingLanguageBP;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.controllers.propertysources.AbstractGuiNodePropertySource;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class ParameterValueLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image m_missingDataImage;

    public ParameterValueLabelProvider(Image missingDataImage) {
        Validate.notNull((Object)missingDataImage);
        this.m_missingDataImage = missingDataImage;
    }

    public String getText(Object element) {
        if (element instanceof AbstractGuiNodePropertySource.AbstractParamValueController) {
            AbstractGuiNodePropertySource.AbstractParamValueController controller = (AbstractGuiNodePropertySource.AbstractParamValueController)element;
            return String.valueOf(controller.getProperty());
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof AbstractGuiNodePropertySource.AbstractParamValueController) {
            AbstractGuiNodePropertySource.AbstractParamValueController controller = (AbstractGuiNodePropertySource.AbstractParamValueController)element;
            IParamNodePO paramNode = controller.getParamNode();
            if (controller.getPropertySource().isReadOnly()) {
                return IconConstants.READ_ONLY_IMAGE;
            }
            if (StringUtils.isNotEmpty((String)paramNode.getDataFile())) {
                return IconConstants.EXCEL_DATA_IMAGE;
            }
            String property = controller.getProperty();
            if ("".equals(property)) {
                return this.m_missingDataImage;
            }
            if (paramNode.getReferencedDataCube() != null) {
                return IconConstants.TDC_IMAGE;
            }
            GuiParamValueConverter conv = new GuiParamValueConverter(property, (IParameterInterfacePO)paramNode, WorkingLanguageBP.getInstance().getWorkingLanguage(), controller.getParamDesc(), (IParamValueValidator)new NullValidator());
            if (conv.containsReferences()) {
                if (paramNode.getParentNode() instanceof ITestSuitePO) {
                    return this.m_missingDataImage;
                }
                return IconConstants.REF_VALUE_IMAGE;
            }
            if (paramNode instanceof IExecTestCasePO) {
                IExecTestCasePO exTc = (IExecTestCasePO)paramNode;
                if (exTc.getHasReferencedTD()) {
                    return IconConstants.ORIGINAL_DATA_IMAGE;
                }
                return IconConstants.OVERWRITTEN_DATA_IMAGE;
            }
            return null;
        }
        return super.getImage(element);
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Color getForeground(Object element) {
        AbstractGuiNodePropertySource.AbstractParamValueController controller;
        IParamNodePO paramNode;
        if (element instanceof AbstractGuiNodePropertySource.AbstractParamValueController && (paramNode = (controller = (AbstractGuiNodePropertySource.AbstractParamValueController)element).getParamNode()).getReferencedDataCube() != null) {
            return Layout.GRAY_COLOR;
        }
        return null;
    }
}

