/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.search.page;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.ui.Plugin;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.search.data.AbstractSearchData;
import org.eclipse.search.ui.ISearchPage;
import org.eclipse.search.ui.ISearchPageContainer;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractSearchPage
extends DialogPage
implements ISearchPage {
    protected static final int NUM_COLUMNS = 4;
    protected static final int VERTICAL_SPACING = 10;
    private Button m_useRegExCheck;
    private Button m_caseSensitivCheck;
    private Combo m_searchStringCombo;

    public void createControl(Composite parent) {
        Composite pageContent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        pageContent.setLayout((Layout)layout);
        Label findLabel = new Label(pageContent, 0);
        findLabel.setText(Messages.SimpleSearchPageSearch);
        this.setSearchStringCombo(new Combo(pageContent, 2048));
        this.getSearchStringCombo().setLayoutData((Object)this.getGridData(3, true));
        this.getSearchStringCombo().setItems(this.getSearchData().getRecent().toArray(new String[this.getSearchData().getRecent().size()]));
        if (this.getSearchStringCombo().getItemCount() == 0) {
            this.getSearchStringCombo().setText(Messages.SimpleSearchPagePhrase);
        } else {
            this.getSearchStringCombo().select(0);
        }
        this.createSearchOptionsGroup(pageContent);
        this.createAdditionalGUI(pageContent);
        this.setControl((Control)pageContent);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.findDialogContextId");
    }

    protected GridData getGridData(int horizontalSpan, boolean grabHorizontal) {
        GridData gd = GridDataFactory.fillDefaults().create();
        gd.grabExcessHorizontalSpace = grabHorizontal;
        gd.horizontalSpan = horizontalSpan;
        return gd;
    }

    private void doCallBack() {
        if (this.getSearchData().getRecent().contains(this.getSearchStringCombo().getText())) {
            this.getSearchData().getRecent().remove(this.getSearchStringCombo().getText());
        }
        if (this.getSearchData().getRecent().size() > 4) {
            this.getSearchData().getRecent().remove(this.getSearchData().getRecent().size() - 1);
        }
        this.getSearchData().getRecent().add(0, this.m_searchStringCombo.getText());
        this.getSearchStringCombo().setItems(this.getSearchData().getRecent().toArray(new String[this.getSearchData().getRecent().size()]));
        this.getSearchStringCombo().select(0);
        this.getSearchStringCombo().setFocus();
        this.getSearchData().setCaseSensitive(this.getCaseSensitivCheck().getSelection());
        this.getSearchData().setUseRegex(this.getUseRegExCheck().getSelection());
        NewSearchUI.runQueryInBackground((ISearchQuery)this.newQuery());
    }

    private void createSearchOptionsGroup(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 10;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)this.getGridData(4, true));
        optionsGroup.setText(Messages.SimpleSearchPageOptionGroupHeader);
        this.setCaseSensitivCheck(new Button((Composite)optionsGroup, 32));
        this.getCaseSensitivCheck().setText(Messages.SimpleSearchPageCaseSen);
        this.getCaseSensitivCheck().setSelection(this.getSearchData().isCaseSensitive());
        this.getCaseSensitivCheck().setLayoutData((Object)this.getGridData(1, true));
        this.setUseRegExCheck(new Button((Composite)optionsGroup, 32));
        this.getUseRegExCheck().setText(Messages.SimpleSearchPageRegEx);
        this.getUseRegExCheck().setSelection(this.getSearchData().isUseRegex());
        this.getUseRegExCheck().setLayoutData((Object)this.getGridData(1, true));
    }

    public boolean performAction() {
        if (GeneralStorage.getInstance().getProject() != null) {
            this.doCallBack();
        }
        return true;
    }

    public void setContainer(ISearchPageContainer container) {
    }

    protected abstract ISearchQuery newQuery();

    private Button getUseRegExCheck() {
        return this.m_useRegExCheck;
    }

    private void setUseRegExCheck(Button useRegExCheck) {
        this.m_useRegExCheck = useRegExCheck;
    }

    private Button getCaseSensitivCheck() {
        return this.m_caseSensitivCheck;
    }

    private void setCaseSensitivCheck(Button caseSensitivCheck) {
        this.m_caseSensitivCheck = caseSensitivCheck;
    }

    protected Combo getSearchStringCombo() {
        return this.m_searchStringCombo;
    }

    private void setSearchStringCombo(Combo searchStringCombo) {
        this.m_searchStringCombo = searchStringCombo;
    }

    protected void createAdditionalGUI(Composite parent) {
        Group optionsGroup = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        optionsGroup.setLayout((Layout)layout);
        optionsGroup.setLayoutData((Object)this.getGridData(3, true));
        optionsGroup.setText(Messages.SimpleSearchPageStructureToSearchGroupHeader);
        DataBindingContext dbc = new DataBindingContext();
        for (AbstractSearchData.SearchableType searchableType : this.getSearchData().getTypesToSearchFor()) {
            this.createTypeChoice(dbc, optionsGroup, searchableType);
        }
    }

    protected abstract AbstractSearchData getSearchData();

    private void createTypeChoice(DataBindingContext dbc, Group parent, AbstractSearchData.SearchableType searchableType) {
        Button choiceButton = new Button((Composite)parent, 32);
        ISWTObservableValue guiElement = SWTObservables.observeSelection((Control)choiceButton);
        IObservableValue modelElement = PojoObservables.observeValue((Object)searchableType, (String)"enabled");
        dbc.bindValue((IObservableValue)guiElement, modelElement);
        dbc.updateTargets();
        GridData gd = new GridData(768);
        choiceButton.setLayoutData((Object)gd);
        choiceButton.setText(searchableType.getName());
    }
}

