/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views;

import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class ColumnSortListener
extends ViewerComparator
implements SelectionListener {
    private TableViewer m_tableViewer;

    public ColumnSortListener(TableViewer viewer, TableColumn initialSortColumn) {
        this.m_tableViewer = viewer;
        initialSortColumn.getParent().setSortColumn(initialSortColumn);
        initialSortColumn.getParent().setSortDirection(1024);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget instanceof TableColumn) {
            TableColumn column = (TableColumn)e.widget;
            Table parent = column.getParent();
            if (parent.getSortColumn() == column) {
                if (parent.getSortDirection() == 1024) {
                    parent.setSortDirection(128);
                } else {
                    parent.setSortDirection(1024);
                }
            } else {
                parent.setSortColumn(column);
                parent.setSortDirection(1024);
            }
            this.m_tableViewer.refresh();
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        TableViewer tableViewer;
        CellLabelProvider cellLabelProvider;
        if (viewer instanceof TableViewer && (cellLabelProvider = (tableViewer = (TableViewer)viewer).getLabelProvider(tableViewer.getTable().indexOf(tableViewer.getTable().getSortColumn()))) instanceof ColumnLabelProvider) {
            String text2;
            ColumnLabelProvider colLabelProvider = (ColumnLabelProvider)cellLabelProvider;
            String text1 = colLabelProvider.getText(e1);
            if (text1 == null) {
                text1 = "";
            }
            if ((text2 = colLabelProvider.getText(e2)) == null) {
                text2 = "";
            }
            int result = text1.compareToIgnoreCase(text2);
            return tableViewer.getTable().getSortDirection() == 1024 ? result : -result;
        }
        return super.compare(viewer, e1, e2);
    }
}

