/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public abstract class ColumnViewerSorter
extends ViewerComparator {
    public static final int ASC = 1;
    public static final int DESC = -1;
    private int m_direction = 0;
    private TableViewerColumn m_column;
    private ColumnViewer m_viewer;

    public ColumnViewerSorter(ColumnViewer viewer, TableViewerColumn column) {
        this.m_column = column;
        this.m_viewer = viewer;
        this.m_column.getColumn().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnViewerSorter.this.m_viewer.getComparator() == ColumnViewerSorter.this && ColumnViewerSorter.this.m_direction == 1) {
                    ColumnViewerSorter.this.setSorter(-1);
                } else {
                    ColumnViewerSorter.this.setSorter(1);
                }
            }
        });
    }

    public void setSorter(int direction) {
        this.m_column.getColumn().getParent().setSortColumn(this.m_column.getColumn());
        this.m_direction = direction;
        if (direction == 1) {
            this.m_column.getColumn().getParent().setSortDirection(1024);
        } else {
            this.m_column.getColumn().getParent().setSortDirection(128);
        }
        if (this.m_viewer.getComparator() == this) {
            this.m_viewer.refresh();
        } else {
            this.m_viewer.setComparator((ViewerComparator)this);
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        return this.m_direction * this.doCompare(viewer, e1, e2);
    }

    protected abstract int doCompare(Viewer var1, Object var2, Object var3);
}

