/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.views.imageview;

import java.awt.geom.AffineTransform;
import org.eclipse.jubula.client.ui.views.imageview.SWT2DUtil;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ScrollBar;

public class ImageViewer
extends Canvas {
    private Image m_sourceImage;
    private Image m_screenImage;
    private AffineTransform m_transform = new AffineTransform();

    public ImageViewer(Composite parent, int style) {
        super(parent, style | 0x200 | 0x100);
        this.initialize();
    }

    private void initialize() {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageViewer.this.m_sourceImage == null) {
                    return;
                }
                ImageViewer.this.drawImage(e.gc);
            }
        });
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                ImageViewer.this.syncScrollBars();
            }
        });
        this.initScrollBars();
    }

    private void initScrollBars() {
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setEnabled(false);
        horizontal.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageViewer.this.scrollHorizontally((ScrollBar)event.widget);
            }
        });
        ScrollBar vertical = this.getVerticalBar();
        vertical.setEnabled(false);
        vertical.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ImageViewer.this.scrollVertically((ScrollBar)event.widget);
            }
        });
    }

    private void scrollHorizontally(ScrollBar scrollBar) {
        if (this.m_screenImage == null || this.m_screenImage.isDisposed()) {
            return;
        }
        AffineTransform af = this.m_transform;
        double tx = af.getTranslateX();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(select - tx, 0.0));
        this.m_transform = af;
        this.syncScrollBars();
    }

    private void scrollVertically(ScrollBar scrollBar) {
        if (this.m_screenImage == null || this.m_screenImage.isDisposed()) {
            return;
        }
        AffineTransform af = this.m_transform;
        double ty = af.getTranslateY();
        double select = -scrollBar.getSelection();
        af.preConcatenate(AffineTransform.getTranslateInstance(0.0, select - ty));
        this.m_transform = af;
        this.syncScrollBars();
    }

    public void syncScrollBars() {
        if (this.m_sourceImage == null || this.m_sourceImage.isDisposed()) {
            this.redraw();
            return;
        }
        AffineTransform af = this.m_transform;
        double sx = af.getScaleX();
        double sy = af.getScaleY();
        double tx = af.getTranslateX();
        double ty = af.getTranslateY();
        if (tx > 0.0) {
            tx = 0.0;
        }
        if (ty > 0.0) {
            ty = 0.0;
        }
        ScrollBar horizontal = this.getHorizontalBar();
        horizontal.setIncrement(this.getClientArea().width / 100);
        horizontal.setPageIncrement(this.getClientArea().width);
        Rectangle imageBound = this.m_sourceImage.getBounds();
        int cw = this.getClientArea().width;
        int ch = this.getClientArea().height;
        if ((double)imageBound.width * sx > (double)cw) {
            horizontal.setMaximum((int)((double)imageBound.width * sx));
            horizontal.setEnabled(true);
            if ((int)(-tx) > horizontal.getMaximum() - cw) {
                tx = -horizontal.getMaximum() + cw;
            }
        } else {
            horizontal.setEnabled(false);
            tx = ((double)cw - (double)imageBound.width * sx) / 2.0;
        }
        horizontal.setSelection((int)(-tx));
        horizontal.setThumb(this.getClientArea().width);
        ScrollBar vertical = this.getVerticalBar();
        vertical.setIncrement(this.getClientArea().height / 100);
        vertical.setPageIncrement(this.getClientArea().height);
        if ((double)imageBound.height * sy > (double)ch) {
            vertical.setMaximum((int)((double)imageBound.height * sy));
            vertical.setEnabled(true);
            if ((int)(-ty) > vertical.getMaximum() - ch) {
                ty = -vertical.getMaximum() + ch;
            }
        } else {
            vertical.setEnabled(false);
            ty = ((double)ch - (double)imageBound.height * sy) / 2.0;
        }
        vertical.setSelection((int)(-ty));
        vertical.setThumb(this.getClientArea().height);
        af = AffineTransform.getScaleInstance(sx, sy);
        af.preConcatenate(AffineTransform.getTranslateInstance(tx, ty));
        this.m_transform = af;
        this.redraw();
    }

    private void drawImage(GC gc) {
        if (this.m_sourceImage.isDisposed()) {
            this.getHorizontalBar().setSelection(0);
            this.getHorizontalBar().setEnabled(false);
            this.getVerticalBar().setSelection(0);
            this.getVerticalBar().setEnabled(false);
            return;
        }
        Rectangle clientRect = this.getClientArea();
        if (this.m_sourceImage != null) {
            SWT2DUtil.absRect(clientRect);
            Rectangle imageRect = SWT2DUtil.inverseTransformRect(this.m_transform, clientRect);
            int gap = 2;
            imageRect.x -= gap;
            imageRect.y -= gap;
            imageRect.width += 2 * gap;
            imageRect.height += 2 * gap;
            Rectangle imageBound = this.m_sourceImage.getBounds();
            imageRect = imageRect.intersection(imageBound);
            SWT2DUtil.absRect(imageRect);
            Rectangle destRect = SWT2DUtil.transformRect(this.m_transform, imageRect);
            if (this.m_screenImage != null) {
                this.m_screenImage.dispose();
            }
            this.m_screenImage = new Image((Device)this.getDisplay(), clientRect.width, clientRect.height);
            GC newGC = new GC((Drawable)this.m_screenImage);
            newGC.setClipping(clientRect);
            newGC.drawImage(this.m_sourceImage, imageRect.x, imageRect.y, imageRect.width, imageRect.height, destRect.x, destRect.y, destRect.width, destRect.height);
            newGC.dispose();
            gc.drawImage(this.m_screenImage, 0, 0);
        } else {
            gc.setClipping(clientRect);
            gc.fillRectangle(clientRect);
            this.initScrollBars();
        }
    }

    public void setImage(Image image) {
        this.m_sourceImage = image;
        this.syncScrollBars();
        this.redraw();
    }

    public void dispose() {
        if (this.m_sourceImage != null && !this.m_sourceImage.isDisposed()) {
            this.m_sourceImage.dispose();
        }
        if (this.m_screenImage != null && !this.m_screenImage.isDisposed()) {
            this.m_screenImage.dispose();
        }
    }
}

