/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.Collection;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.dialogs.EnterAutIdDialog;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.provider.ControlDecorator;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutIdListComposite
extends Composite {
    private IAUTMainPO m_aut;

    public AutIdListComposite(Composite parent, IAUTMainPO aut, IValidator autIdValidator) {
        super(parent, 0);
        this.m_aut = aut;
        this.init(autIdValidator);
    }

    private void init(IValidator autIdValidator) {
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 2;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        this.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        Label idLabel = new Label((Composite)this, 0);
        idLabel.setText(Messages.AUTPropertiesDialogAutId);
        ControlDecorator.decorateInfo((Control)idLabel, "AUTPropertiesDialog.AutId.helpText", false);
        GridData data = new GridData(1, 4, false, false);
        data.horizontalSpan = 1;
        idLabel.setLayoutData((Object)data);
        new Label((Composite)this, 0).setVisible(false);
        WritableList idListModel = new WritableList(this.m_aut.getAutIds(), String.class);
        ListViewer idListViewer = new ListViewer((Composite)this, 2818);
        idListViewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        idListViewer.setSorter(new ViewerSorter());
        idListViewer.setInput((Object)idListModel);
        List idList = idListViewer.getList();
        data = new GridData(4, 4, true, false);
        data.verticalSpan = 3;
        data.widthHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)idList), (int)4);
        idList.setLayoutData((Object)data);
        AutIdListComposite.createButtons(this, autIdValidator, idList, (Collection<String>)idListModel);
    }

    private static void createButtons(Composite parent, final IValidator autIdValidator, final List idList, final Collection<String> idListModel) {
        final Button addButton = new Button(parent, 0);
        addButton.setText(Messages.AUTConfigComponentAdd);
        GridData data = new GridData(4, 1, false, false);
        addButton.setLayoutData((Object)data);
        addButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                EnterAutIdDialog dialog = new EnterAutIdDialog(addButton.getShell(), null, autIdValidator);
                if (dialog.open() == 0) {
                    idListModel.add(dialog.getAutId());
                }
            }
        });
        final Button editButton = new Button(parent, 0);
        editButton.setEnabled(false);
        editButton.setText(Messages.AUTConfigComponentEdit);
        data = new GridData(4, 1, false, false);
        editButton.setLayoutData((Object)data);
        editButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                AutIdListComposite.handleEditAutIdDialog(idList, autIdValidator, idListModel);
            }
        });
        final Button removeButton = new Button(parent, 0);
        removeButton.setEnabled(false);
        removeButton.setText(Messages.AUTConfigComponentRemove);
        data = new GridData(4, 1, false, false);
        removeButton.setLayoutData((Object)data);
        removeButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }

            public void widgetSelected(SelectionEvent event) {
                if (idList.getSelectionCount() != 0) {
                    idListModel.remove(idList.getItem(idList.getSelectionIndex()));
                    if (idList.getItemCount() > 0) {
                        idList.setSelection(0);
                    } else {
                        idList.deselectAll();
                        removeButton.setEnabled(false);
                        editButton.setEnabled(false);
                    }
                }
            }
        });
        idList.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
                AutIdListComposite.handleEditAutIdDialog(idList, autIdValidator, idListModel);
            }

            public void widgetSelected(SelectionEvent event) {
                boolean enableSelectionButtons = idList.getSelectionCount() == 1;
                editButton.setEnabled(enableSelectionButtons);
                removeButton.setEnabled(enableSelectionButtons);
            }
        });
    }

    private static void handleEditAutIdDialog(List idList, IValidator autIdValidator, Collection<String> idListModel) {
        if (idList.getSelectionCount() != 0) {
            String originalId = idList.getItem(idList.getSelectionIndex());
            EnterAutIdDialog dialog = new EnterAutIdDialog(idList.getShell(), originalId, autIdValidator);
            dialog.create();
            DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
            if (dialog.open() == 0) {
                idListModel.remove(originalId);
                idListModel.add(dialog.getAutId());
            }
        }
    }
}

