/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.client.ui.widgets.CheckedText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class CheckedIntText
extends CheckedText {
    public CheckedIntText(Composite parent, int style, boolean emptyAllowed, int minValue, int maxValue) {
        super(parent, style, new IntegerValidator(emptyAllowed, minValue, maxValue));
    }

    public CheckedIntText(Composite parent, int style, boolean emptyAllowed) {
        this(parent, style, emptyAllowed, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    public CheckedIntText(Composite parent, int style) {
        this(parent, style, true);
    }

    public void setValue(int val) {
        this.setText(String.valueOf(val));
    }

    public int getValue() {
        String txt = this.getText();
        if (StringUtils.isEmpty((String)txt)) {
            return 0;
        }
        return Integer.parseInt(txt);
    }

    private static class IntegerValidator
    implements CheckedText.IValidator {
        private boolean m_empyAllowed;
        private int m_minVal;
        private int m_maxVal;

        public IntegerValidator(boolean emptyAllowed, int minVal, int maxVal) {
            this.m_empyAllowed = emptyAllowed;
            this.m_minVal = minVal;
            this.m_maxVal = maxVal;
        }

        public CheckedText.ValidationState validateInput(VerifyEvent e) {
            CheckedText.ValidationState val;
            Text txt = (Text)e.widget;
            String oldValue = txt.getText();
            StringBuilder workValue = new StringBuilder(oldValue);
            workValue.replace(e.start, e.end, e.text);
            String newValue = workValue.toString();
            if (StringUtils.isEmpty((String)newValue)) {
                val = this.m_empyAllowed ? CheckedText.ValidationState.EmptyAccept : CheckedText.ValidationState.MightMatchAccept;
            } else if (newValue.equals("-")) {
                val = this.m_minVal < 0 ? CheckedText.ValidationState.MightMatchAccept : this.resetToOldValue(e, oldValue);
            } else {
                try {
                    int n = Integer.parseInt(newValue);
                    val = n >= this.m_minVal && n <= this.m_maxVal ? CheckedText.ValidationState.OK : (n < 0 && this.m_minVal >= 0 ? this.resetToOldValue(e, oldValue) : CheckedText.ValidationState.MightMatchAccept);
                }
                catch (NumberFormatException numberFormatException) {
                    val = this.resetToOldValue(e, oldValue);
                }
            }
            return val;
        }

        private CheckedText.ValidationState resetToOldValue(VerifyEvent e, String oldValue) {
            CheckedText.ValidationState val;
            e.doit = false;
            try {
                int n;
                val = StringUtils.isEmpty((String)oldValue) ? (this.m_empyAllowed ? CheckedText.ValidationState.EmptyAccept : CheckedText.ValidationState.MightMatchAccept) : ((n = Integer.parseInt(oldValue)) >= this.m_minVal && n <= this.m_maxVal ? CheckedText.ValidationState.OK : CheckedText.ValidationState.MightMatchAccept);
            }
            catch (NumberFormatException numberFormatException) {
                val = CheckedText.ValidationState.DontMatchReject;
            }
            return val;
        }
    }
}

