/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import org.apache.commons.lang.Validate;
import org.eclipse.jubula.client.ui.widgets.JBText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;

public abstract class CheckedText
extends JBText {
    private ValidationListener m_validationListener;

    protected CheckedText(Composite parent, int style, IValidator validator) {
        super(parent, style);
        this.m_validationListener = new ValidationListener(validator);
        this.addVerifyListener(this.m_validationListener);
        Event dummyEvent = new Event();
        dummyEvent.start = 0;
        dummyEvent.end = 0;
        dummyEvent.text = "";
        this.notifyListeners(25, dummyEvent);
    }

    public boolean isValid() {
        return this.m_validationListener.isValid();
    }

    public static interface IValidator {
        public ValidationState validateInput(VerifyEvent var1);
    }

    public static final class ValidationListener
    implements VerifyListener {
        private ValidationState m_validationState = ValidationState.OK;
        private IValidator m_validator;

        public ValidationListener(IValidator validator) {
            this.m_validator = validator;
        }

        public void verifyText(VerifyEvent e) {
            this.m_validationState = this.m_validator.validateInput(e);
            Validate.isTrue((boolean)(e.widget instanceof Control));
            Control eventControl = (Control)e.widget;
            boolean doit = false;
            switch (this.m_validationState) {
                case OK: {
                    doit = true;
                    eventControl.setBackground(null);
                    break;
                }
                case EmptyAccept: {
                    doit = true;
                    eventControl.setBackground(null);
                    this.m_validationState = ValidationState.OK;
                    break;
                }
                case EmptyReject: {
                    doit = false;
                    eventControl.setBackground(this.getWarningColor(e.display));
                    break;
                }
                case MightMatchAccept: {
                    doit = true;
                    eventControl.setBackground(this.getWarningColor(e.display));
                    break;
                }
                case MightMatchReject: {
                    doit = false;
                    eventControl.setBackground(this.getWarningColor(e.display));
                    break;
                }
                case DontMatchAccept: {
                    doit = true;
                    eventControl.setBackground(this.getErrorColor(e.display));
                    break;
                }
                case DontMatchReject: {
                    doit = false;
                    eventControl.setBackground(this.getErrorColor(e.display));
                    break;
                }
            }
            e.doit &= doit;
        }

        public boolean isValid() {
            return this.m_validationState == ValidationState.OK;
        }

        private Color getErrorColor(Display display) {
            return display.getSystemColor(3);
        }

        protected Color getWarningColor(Display display) {
            return display.getSystemColor(7);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValidationState {
        OK,
        EmptyAccept,
        EmptyReject,
        MightMatchReject,
        MightMatchAccept,
        DontMatchReject,
        DontMatchAccept;

    }
}

