/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.model.IComponentNameData;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.utils.StringHelper;
import org.eclipse.jubula.client.ui.utils.ComponentNameVisibility;
import org.eclipse.jubula.client.ui.widgets.CompNamesProposal;

public class CompNamesProposalProvider
implements IContentProposalProvider {
    private IComponentNameMapper m_compNameMapper;
    private String m_typeFilter = "";

    public CompNamesProposalProvider(IComponentNameMapper compNameMapper) {
        this.m_compNameMapper = compNameMapper;
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList compNamesList = new ArrayList(this.m_compNameMapper.getCompNameCache().getComponentNameData());
        final Long currentProjectId = GeneralStorage.getInstance().getProject() != null ? GeneralStorage.getInstance().getProject().getId() : null;
        final String subString = position == 0 ? contents : contents.substring(0, position);
        CollectionUtils.filter(compNamesList, (Predicate)new Predicate(){

            public boolean evaluate(Object arg) {
                IComponentNameData elem = (IComponentNameData)arg;
                String item = elem.getName();
                boolean ok = !StringUtils.isEmpty((String)item) && item.startsWith(subString) && (elem.getParentProjectId() == null || elem.getParentProjectId().equals(currentProjectId)) && CompNamesProposalProvider.this.checkFilterInHierarchy(CompNamesProposalProvider.this.m_typeFilter, elem);
                return ok;
            }
        });
        if (!StringUtils.isEmpty((String)contents)) {
            Collections.sort(compNamesList, new JBComparator());
        }
        ArrayList<CompNamesProposal> proposals = new ArrayList<CompNamesProposal>(compNamesList.size());
        for (IComponentNameData data : compNamesList) {
            proposals.add(new CompNamesProposal(data, ComponentNameVisibility.getVisibility(data, this.m_compNameMapper.getCompNameCache())));
        }
        return proposals.toArray(new IContentProposal[proposals.size()]);
    }

    private boolean checkFilterInHierarchy(String filter, IComponentNameData checkable) {
        return ComponentNamesBP.getInstance().isCompatible(filter, checkable.getName(), this.m_compNameMapper, GeneralStorage.getInstance().getProject().getId()) == null;
    }

    public void setTypeFilter(String typeFilter) {
        this.m_typeFilter = typeFilter;
    }

    public void setComponentNameMapper(IComponentNameMapper compNameMapper) {
        this.m_compNameMapper = compNameMapper;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class JBComparator
    implements Comparator<IComponentNameData> {
        private JBComparator() {
        }

        @Override
        public int compare(IComponentNameData element0, IComponentNameData element1) {
            String type1;
            String name0 = element0.getName() == null ? "" : element0.getName();
            String name1 = element1.getName() == null ? "" : element1.getName();
            ComponentNameVisibility vis0 = ComponentNameVisibility.getVisibility(element0, CompNamesProposalProvider.this.m_compNameMapper.getCompNameCache());
            ComponentNameVisibility vis1 = ComponentNameVisibility.getVisibility(element1, CompNamesProposalProvider.this.m_compNameMapper.getCompNameCache());
            String type0 = element0.getComponentType() == null ? "" : element0.getComponentType();
            String string = type1 = element1.getComponentType() == null ? "" : element1.getComponentType();
            if (type0.equals(type1)) {
                return name0.toLowerCase().compareTo(name1.toLowerCase());
            }
            if (vis0.equals((Object)vis1)) {
                StringHelper helper = StringHelper.getInstance();
                return helper.get(type0, true).compareTo(helper.get(type1, true));
            }
            return vis0.compareTo(vis1);
        }
    }
}

