/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jubula.client.ui.constants.Layout;
import org.eclipse.jubula.client.ui.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.Utils;
import org.eclipse.jubula.tools.exception.Assert;
import org.eclipse.jubula.tools.messagehandling.MessageIDs;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeElementChooserComposite
extends Composite {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final String DISPLAY_VALUE_START = " [";
    private static final String DISPLAY_VALUE_END = "]";
    private static final String LABEL = "Label";
    private static final int NUM_COLUMNS_1 = 1;
    private static final int NUM_COLUMNS_2 = 2;
    private static final int NUM_COLUMNS_3 = 3;
    private Tree m_availableTree;
    private org.eclipse.swt.widgets.List m_usedList;
    private Button m_selectionAvailableToUsedButton;
    private Button m_allAvailableToUsedButton;
    private Button m_selectionUsedToAvailableButton;
    private Button m_allUsedToAvailableButton;
    private Button m_swapButton;
    private Object[] m_disabledButtonContents;
    private Object[] m_buttonContents;
    private Set<String> m_usedParents = new HashSet<String>();
    private final WidgetSelectionListener m_selectionListener = new WidgetSelectionListener();
    private Map<String, IChooserCompositeGuiObject> m_listItemsToGuiObjects = new HashMap<String, IChooserCompositeGuiObject>();
    private Map<TreeItem, IChooserCompositeGuiObject> m_treeItemsToGuiObjects = new HashMap<TreeItem, IChooserCompositeGuiObject>();
    private Set<IUsedListModifiedListener> m_listeners = new HashSet<IUsedListModifiedListener>();

    public TreeElementChooserComposite(Composite parent, String availableLabel, Set<IChooserCompositeGuiObject> availableObjects, String usedLabel, Set<IChooserCompositeGuiObject> usedObjects, int lineNumber, String[] buttonTexts, String[] buttonToolTips, int style) {
        super(parent, 0);
        this.m_disabledButtonContents = buttonTexts;
        this.m_buttonContents = buttonTexts;
        this.createControl(availableLabel, availableObjects, usedLabel, usedObjects, lineNumber, buttonToolTips, style);
    }

    public TreeElementChooserComposite(Composite parent, String availableLabel, Set<IChooserCompositeGuiObject> availableObjects, String usedLabel, Set<IChooserCompositeGuiObject> usedObjects, int lineNumber, Image[] buttonImages, Image[] disabledButtonImages, String[] buttonToolTips, int style) {
        super(parent, 0);
        this.m_disabledButtonContents = disabledButtonImages;
        this.m_buttonContents = buttonImages;
        this.createControl(availableLabel, availableObjects, usedLabel, usedObjects, lineNumber, buttonToolTips, style);
    }

    private void createControl(String availableLabel, Set<IChooserCompositeGuiObject> availableObjects, String usedLabel, Set<IChooserCompositeGuiObject> usedObjects, int lineNumber, String[] buttonToolTips, int style) {
        if (style == 0) {
            this.createHorizontalLayout(availableLabel, usedLabel, lineNumber, buttonToolTips, style);
        } else {
            TreeElementChooserComposite composite = this;
            GridLayout compositeLayout = new GridLayout();
            compositeLayout.numColumns = 3;
            compositeLayout.marginHeight = 0;
            compositeLayout.marginWidth = 0;
            composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
            GridData compositeData = new GridData();
            compositeData.horizontalAlignment = 4;
            compositeData.grabExcessHorizontalSpace = true;
            composite.setLayoutData(compositeData);
            this.createVerticalLayout(composite, availableLabel, usedLabel, lineNumber, buttonToolTips, style);
        }
        this.initFields(availableObjects, usedObjects);
        this.addListener();
        this.checkButtons();
    }

    private void createVerticalLayout(Composite parent, String listOneLabel, String listTwoLabel, int lineNumber, String[] buttonToolTips, int style) {
        Composite compositeLeft = this.createComposite(parent, 1, 4, true);
        Composite compositeMiddle = this.createComposite(parent, 1, 4, false);
        Composite compositeRight = this.createComposite(parent, 1, 4, true);
        this.m_availableTree = this.createAvailableTree(compositeLeft, listOneLabel, lineNumber);
        this.m_availableTree.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.createShiftButtons(style, compositeMiddle, buttonToolTips);
        this.m_usedList = this.createListField(compositeRight, listTwoLabel, lineNumber);
        this.m_usedList.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void createHorizontalLayout(String listOneLabel, String listTwoLabel, int lineNumber, String[] buttonToolTips, int style) {
        TreeElementChooserComposite composite = this;
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = 2;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessHorizontalSpace = true;
        compositeData.grabExcessVerticalSpace = false;
        compositeData.verticalAlignment = 1;
        composite.setLayoutData(compositeData);
        this.m_availableTree = this.createAvailableTree(composite, listOneLabel, lineNumber);
        this.m_availableTree.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.createShiftButtons(style, composite, buttonToolTips);
        this.m_usedList = this.createListField(composite, listTwoLabel, lineNumber);
        this.m_usedList.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    protected void initFields(Set<IChooserCompositeGuiObject> availableObjects, Set<IChooserCompositeGuiObject> usedObjects) {
        HashMap<String, TreeItem> parentsThatExist = new HashMap<String, TreeItem>();
        for (IChooserCompositeGuiObject guiObject : availableObjects) {
            boolean isValueInUsedList;
            String parent = guiObject.getParent();
            if (!parentsThatExist.containsKey(parent)) {
                TreeItem parentItem = new TreeItem(this.m_availableTree, 0);
                parentItem.setText(parent);
                parentsThatExist.put(parent, parentItem);
            }
            if (isValueInUsedList = usedObjects.contains(guiObject)) continue;
            TreeItem valueItem = new TreeItem((TreeItem)parentsThatExist.get(parent), 0);
            valueItem.setText(guiObject.getTitle());
            this.m_treeItemsToGuiObjects.put(valueItem, guiObject);
        }
        this.sortTreeItems();
        for (IChooserCompositeGuiObject item : usedObjects) {
            this.m_usedList.add(item.getDisplayString());
            this.m_listItemsToGuiObjects.put(item.getDisplayString(), item);
            this.m_usedParents.add(item.getParent());
        }
        this.sortListItems();
    }

    private void sortListItems() {
        Object[] items = this.m_usedList.getItems();
        Arrays.sort(items);
        this.m_usedList.removeAll();
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object listItem = objectArray[n2];
            this.m_usedList.add((String)listItem);
            ++n2;
        }
    }

    private void createShiftButtons(int style, Composite parent, String[] buttonToolTips) {
        if (style == 0) {
            this.createComposite(parent, 1, 1, false);
            Composite composite = this.createComposite(parent, 2, 4, true);
            Composite leftComposite = this.createComposite(composite, 2, 4, true);
            Composite rightComposite = this.createComposite(composite, 2, 4, true);
            this.m_selectionAvailableToUsedButton = new Button(leftComposite, 8);
            this.m_allAvailableToUsedButton = new Button(leftComposite, 8);
            this.m_selectionUsedToAvailableButton = new Button(rightComposite, 8);
            this.m_allUsedToAvailableButton = new Button(rightComposite, 8);
            this.m_swapButton = new Button(rightComposite, 8);
        } else {
            this.createLabel(parent, "");
            this.m_selectionAvailableToUsedButton = new Button(parent, 8);
            this.m_allAvailableToUsedButton = new Button(parent, 8);
            this.createLabel(parent, "");
            this.m_selectionUsedToAvailableButton = new Button(parent, 8);
            this.m_allUsedToAvailableButton = new Button(parent, 8);
            this.m_swapButton = new Button(parent, 8);
        }
        GridData selectionOneToTwoGridData = new GridData();
        selectionOneToTwoGridData.horizontalAlignment = 4;
        if (style == 0) {
            selectionOneToTwoGridData.horizontalAlignment = 3;
        }
        selectionOneToTwoGridData.grabExcessHorizontalSpace = true;
        this.m_selectionAvailableToUsedButton.setLayoutData((Object)selectionOneToTwoGridData);
        this.m_selectionAvailableToUsedButton.setImage((Image)this.m_disabledButtonContents[0]);
        this.m_selectionAvailableToUsedButton.setEnabled(false);
        GridData allOneToTwoGridData = new GridData();
        allOneToTwoGridData.horizontalAlignment = 4;
        if (style == 0) {
            allOneToTwoGridData.horizontalAlignment = 1;
        }
        allOneToTwoGridData.grabExcessHorizontalSpace = true;
        this.m_allAvailableToUsedButton.setLayoutData((Object)allOneToTwoGridData);
        this.m_allAvailableToUsedButton.setImage((Image)this.m_disabledButtonContents[1]);
        this.m_allAvailableToUsedButton.setEnabled(false);
        GridData selectionTwoToOneGridData = new GridData();
        selectionTwoToOneGridData.horizontalAlignment = 4;
        if (style == 0) {
            selectionTwoToOneGridData.horizontalAlignment = 3;
        }
        selectionTwoToOneGridData.grabExcessHorizontalSpace = true;
        this.m_selectionUsedToAvailableButton.setLayoutData((Object)selectionTwoToOneGridData);
        this.m_selectionUsedToAvailableButton.setImage((Image)this.m_disabledButtonContents[2]);
        this.m_selectionUsedToAvailableButton.setEnabled(false);
        GridData allTwoToOneGridData = new GridData();
        allTwoToOneGridData.horizontalAlignment = 4;
        if (style == 0) {
            allTwoToOneGridData.horizontalAlignment = 1;
        }
        allTwoToOneGridData.grabExcessHorizontalSpace = true;
        this.m_allUsedToAvailableButton.setLayoutData((Object)allTwoToOneGridData);
        this.m_allUsedToAvailableButton.setImage((Image)this.m_disabledButtonContents[3]);
        this.m_allUsedToAvailableButton.setEnabled(false);
        this.setButtonRepresentations();
        this.setTooltips(buttonToolTips);
    }

    private void setButtonRepresentations() {
        if (this.m_buttonContents instanceof Image[]) {
            this.m_selectionAvailableToUsedButton.setImage((Image)this.m_buttonContents[0]);
            this.m_allAvailableToUsedButton.setImage((Image)this.m_buttonContents[1]);
            this.m_selectionUsedToAvailableButton.setImage((Image)this.m_buttonContents[2]);
            this.m_allUsedToAvailableButton.setImage((Image)this.m_buttonContents[3]);
        } else {
            this.m_selectionAvailableToUsedButton.setText((String)this.m_buttonContents[0]);
            this.m_allAvailableToUsedButton.setText((String)this.m_buttonContents[1]);
            this.m_selectionUsedToAvailableButton.setText((String)this.m_buttonContents[2]);
            this.m_allUsedToAvailableButton.setText((String)this.m_buttonContents[3]);
        }
    }

    private void setTooltips(String[] buttonToolTips) {
        this.m_selectionAvailableToUsedButton.setToolTipText(buttonToolTips[0]);
        this.m_allAvailableToUsedButton.setToolTipText(buttonToolTips[1]);
        this.m_selectionUsedToAvailableButton.setToolTipText(buttonToolTips[2]);
        this.m_allUsedToAvailableButton.setToolTipText(buttonToolTips[3]);
        this.m_swapButton.setToolTipText(buttonToolTips[4]);
    }

    private void sortTreeItems() {
        TreeMap sortedTree = new TreeMap();
        HashSet<IChooserCompositeGuiObject> tempSet = new HashSet<IChooserCompositeGuiObject>();
        boolean[] isItemExpanded = new boolean[this.m_availableTree.getItemCount()];
        int i = 0;
        while (i < this.m_availableTree.getItemCount()) {
            TreeItem parentItem = this.m_availableTree.getItem(i);
            isItemExpanded[i] = parentItem.getExpanded();
            ArrayList<String> childNames = new ArrayList<String>();
            TreeItem[] treeItemArray = parentItem.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem childItem = treeItemArray[n2];
                childNames.add(childItem.getText());
                IChooserCompositeGuiObject guiObj = this.m_treeItemsToGuiObjects.get(childItem);
                tempSet.add(guiObj);
                ++n2;
            }
            Collections.sort(childNames);
            sortedTree.put(parentItem.getText(), childNames);
            ++i;
        }
        this.m_availableTree.removeAll();
        this.m_treeItemsToGuiObjects.clear();
        for (String parentName : sortedTree.keySet()) {
            TreeItem parentItem = new TreeItem(this.m_availableTree, 0);
            parentItem.setText(parentName);
            block3: for (String childName : (List)sortedTree.get(parentName)) {
                TreeItem childItem = new TreeItem(parentItem, 0);
                childItem.setText(childName);
                for (IChooserCompositeGuiObject obj : tempSet) {
                    if (!obj.getParent().equals(parentName) || !obj.getTitle().equals(childName)) continue;
                    this.m_treeItemsToGuiObjects.put(childItem, obj);
                    continue block3;
                }
            }
        }
        i = 0;
        while (i < this.m_availableTree.getItemCount()) {
            if (isItemExpanded[i]) {
                TreeItem item = this.m_availableTree.getItem(i);
                Event expandEvent = new Event();
                expandEvent.time = (int)System.currentTimeMillis();
                expandEvent.type = 17;
                expandEvent.widget = this.m_availableTree;
                expandEvent.item = item;
                this.m_availableTree.notifyListeners(17, expandEvent);
                item.setExpanded(true);
                this.m_availableTree.update();
            }
            ++i;
        }
    }

    private void useObject(TreeItem item) {
        IChooserCompositeGuiObject guiObj = this.m_treeItemsToGuiObjects.get(item);
        String displayString = guiObj.getDisplayString();
        this.m_listItemsToGuiObjects.put(displayString, guiObj);
        this.m_usedList.add(displayString);
        item.dispose();
        this.m_usedParents.add(guiObj.getParent());
        this.sortListItems();
    }

    private void makeObjectAvailable(IChooserCompositeGuiObject obj, boolean swapping) {
        this.m_listItemsToGuiObjects.remove(obj.getDisplayString());
        if (!swapping) {
            this.m_usedParents.remove(obj.getParent());
        }
        this.m_usedList.remove(obj.getDisplayString());
        if (obj.getParent() != null) {
            TreeItem parentItem = null;
            String parentText = obj.getParent();
            TreeItem[] treeItemArray = this.m_availableTree.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem parent = treeItemArray[n2];
                if (parent.getText().equals(parentText)) {
                    parentItem = parent;
                    break;
                }
                ++n2;
            }
            if (parentItem != null) {
                TreeItem item = new TreeItem(parentItem, 0);
                item.setText(obj.getTitle());
                this.m_treeItemsToGuiObjects.put(item, obj);
                this.sortTreeItems();
            }
        }
    }

    private void fireListModified() {
        for (IUsedListModifiedListener listener : this.m_listeners) {
            listener.usedListModified(this.m_usedList.getItems());
        }
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData labelGrid = new GridData(1, 2, false, false, 1, 1);
        label.setLayoutData((Object)labelGrid);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns, int alignment, boolean horizontalSpace) {
        Composite composite = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.numColumns = numColumns;
        compositeLayout.marginHeight = 0;
        compositeLayout.marginWidth = 0;
        composite.setLayout((org.eclipse.swt.widgets.Layout)compositeLayout);
        GridData compositeData = new GridData();
        compositeData.horizontalAlignment = alignment;
        compositeData.grabExcessHorizontalSpace = horizontalSpace;
        composite.setLayoutData((Object)compositeData);
        return composite;
    }

    private org.eclipse.swt.widgets.List createListField(Composite composite, String labelText, int lines) {
        Composite leftComposite = this.createComposite(composite, 2, 1, false);
        Composite rightComposite = this.createComposite(composite, 1, 4, true);
        Label label = this.createLabel(leftComposite, labelText);
        org.eclipse.swt.widgets.List listField = new org.eclipse.swt.widgets.List(rightComposite, 2818);
        listField.setData(LABEL, (Object)label);
        GridData listGridData = new GridData();
        listGridData.horizontalAlignment = 4;
        listGridData.horizontalSpan = 1;
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)listField), (int)lines);
        listField.setLayoutData((Object)listGridData);
        return listField;
    }

    private Tree createAvailableTree(Composite composite, String labelText, int lines) {
        Composite leftComposite = this.createComposite(composite, 2, 1, false);
        Composite rightComposite = this.createComposite(composite, 1, 4, true);
        Label label = this.createLabel(leftComposite, labelText);
        Tree tree = new Tree(rightComposite, 2818);
        tree.setData(LABEL, (Object)label);
        GridData listGridData = new GridData();
        listGridData.horizontalAlignment = 4;
        listGridData.horizontalSpan = 1;
        listGridData.grabExcessHorizontalSpace = true;
        listGridData.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)Layout.getFontMetrics((Control)tree), (int)lines);
        tree.setLayoutData((Object)listGridData);
        return tree;
    }

    protected String getDisplayValue(String key, String value) {
        String displayValue = String.valueOf(key) + DISPLAY_VALUE_START + value + DISPLAY_VALUE_END;
        return displayValue;
    }

    protected void handleSelectionAvailableToUsedButtonEvent() {
        if (this.m_selectionAvailableToUsedButton.getEnabled()) {
            TreeItem[] treeItemArray = this.m_availableTree.getSelection();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                this.useObject(item);
                ++n2;
            }
            this.sortListItems();
            this.fireListModified();
            this.checkButtons();
        }
    }

    protected void handleSelectionUsedToAvailableButtonEvent() {
        if (this.m_selectionUsedToAvailableButton.getEnabled()) {
            String[] usedSelection = this.m_usedList.getSelection();
            if (this.checkSelectionUsedToAvailable(usedSelection) == null) {
                String[] stringArray = this.m_usedList.getSelection();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String sel = stringArray[n2];
                    IChooserCompositeGuiObject guiObj = this.m_listItemsToGuiObjects.get(sel);
                    this.makeObjectAvailable(guiObj, false);
                    ++n2;
                }
                this.checkButtons();
                this.fireListModified();
            } else {
                Dialog dialog = Utils.createMessageDialog(MessageIDs.I_COULD_NOT_REMOVE_REUSED_PROJECTS);
                dialog.getReturnCode();
            }
        }
    }

    protected String checkSelectionUsedToAvailable(String[] selection) {
        return null;
    }

    protected void handleAllAvailableToUsedButtonEvent() {
        TreeItem[] treeItemArray = this.m_availableTree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem keyItem = treeItemArray[n2];
            this.useObject(keyItem.getItem(0));
            ++n2;
        }
        Object[] selection = this.m_usedList.getItems();
        Arrays.sort(selection);
        this.m_usedList.removeAll();
        this.m_usedList.setItems((String[])selection);
        this.fireListModified();
        this.checkButtons();
    }

    protected void handleAllUsedToAvailableButtonEvent() {
        String[] usedItems = this.m_usedList.getItems();
        String errorMsg = this.checkSelectionUsedToAvailable(usedItems);
        if (errorMsg == null) {
            String[] stringArray = usedItems;
            int n = usedItems.length;
            int n2 = 0;
            while (n2 < n) {
                String listItem = stringArray[n2];
                this.makeObjectAvailable(this.m_listItemsToGuiObjects.get(listItem), false);
                ++n2;
            }
            this.m_usedList.removeAll();
            this.fireListModified();
            this.checkButtons();
        } else {
            Dialog dialog = Utils.createMessageDialog(MessageIDs.I_COULD_NOT_REMOVE_REUSED_PROJECTS);
            dialog.getReturnCode();
        }
    }

    protected void handleSwapButtonEvent() {
        String usedSelection = this.m_usedList.getSelection()[0];
        TreeItem availableSelection = this.m_availableTree.getSelection()[0];
        this.useObject(availableSelection);
        this.makeObjectAvailable(this.m_listItemsToGuiObjects.get(usedSelection), true);
        this.fireListModified();
        this.checkButtons();
    }

    public void checkButtons() {
        boolean listContainsAnElement;
        boolean parentHasMoreThanOneElement = false;
        boolean parentsHaveNoElements = true;
        boolean enableAllOneToTwo = true;
        boolean enableAllTwoToOne = false;
        boolean selectionContainsParentItem = false;
        boolean partOfSelectionIsInList = false;
        boolean availableSelectionShareParent = false;
        boolean enableSelectionOneToTwo = true;
        boolean someSelectionTwo = false;
        boolean enableSelectionTwoToOne = true;
        boolean oneElementSelectedTwo = false;
        boolean elementsShareCommonParent = false;
        boolean enableSwap = true;
        parentHasMoreThanOneElement = this.hasMultipleChildren();
        enableAllOneToTwo = !parentHasMoreThanOneElement && !parentsHaveNoElements;
        enableAllTwoToOne = listContainsAnElement = this.m_usedList.getItemCount() > 0;
        TreeItem[] treeSelection = this.m_availableTree.getSelection();
        boolean someSelectionOne = treeSelection.length > 0;
        HashSet<String> parentsOfSelection = new HashSet<String>();
        TreeItem[] treeItemArray = treeSelection;
        int n = treeSelection.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem selItem = treeItemArray[n2];
            if (selItem.getParentItem() == null) {
                selectionContainsParentItem = true;
                break;
            }
            String parent = this.m_treeItemsToGuiObjects.get(selItem).getParent();
            if (parentsOfSelection.contains(parent)) {
                availableSelectionShareParent = true;
                break;
            }
            parentsOfSelection.add(parent);
            if (this.isChildItemUsed(selItem.getParentItem().getText())) {
                partOfSelectionIsInList = true;
                break;
            }
            ++n2;
        }
        enableSelectionOneToTwo = someSelectionOne && !selectionContainsParentItem && !partOfSelectionIsInList && !availableSelectionShareParent;
        enableSelectionTwoToOne = someSelectionTwo = this.m_usedList.getSelectionCount() > 0;
        boolean oneElementSelectedOne = this.m_availableTree.getSelectionCount() == 1;
        boolean bl = oneElementSelectedTwo = this.m_usedList.getSelectionCount() == 1;
        if (oneElementSelectedOne && oneElementSelectedTwo) {
            elementsShareCommonParent = this.isCommonParentForElements(selectionContainsParentItem);
        }
        enableSwap = elementsShareCommonParent;
        this.enableSelectionOneToTwoButton(enableSelectionOneToTwo);
        this.enableSelectionTwoToOneButton(enableSelectionTwoToOne);
        this.enableAllOneToTwoButton(enableAllOneToTwo);
        this.enableAllTwoToOneButton(enableAllTwoToOne);
        this.enableSwapButton(enableSwap);
    }

    private boolean isCommonParentForElements(boolean selectionContainsParentItem) {
        IChooserCompositeGuiObject availableObj = this.m_treeItemsToGuiObjects.get(this.m_availableTree.getSelection()[0]);
        IChooserCompositeGuiObject usedObj = this.m_listItemsToGuiObjects.get(this.m_usedList.getSelection()[0]);
        boolean elementsShareCommonParent = !selectionContainsParentItem && availableObj != null && usedObj != null && availableObj.getParent().equals(usedObj.getParent());
        return elementsShareCommonParent;
    }

    private boolean hasMultipleChildren() {
        HashSet<IChooserCompositeGuiObject> guiObjects = new HashSet<IChooserCompositeGuiObject>(this.m_treeItemsToGuiObjects.values());
        guiObjects.addAll(this.m_listItemsToGuiObjects.values());
        HashSet<String> parentSet = new HashSet<String>();
        for (IChooserCompositeGuiObject obj : guiObjects) {
            String parentString = obj.getParent();
            if (!parentSet.contains(parentString)) {
                parentSet.add(parentString);
                continue;
            }
            return true;
        }
        return false;
    }

    private boolean isChildItemUsed(String text) {
        return this.m_usedParents.contains(text);
    }

    private void enableSelectionOneToTwoButton(boolean enable) {
        if (enable) {
            this.m_selectionAvailableToUsedButton.setImage((Image)this.m_buttonContents[0]);
            this.m_selectionAvailableToUsedButton.setEnabled(true);
        } else {
            this.m_selectionAvailableToUsedButton.setImage((Image)this.m_disabledButtonContents[0]);
            this.m_selectionAvailableToUsedButton.setEnabled(false);
        }
    }

    private void enableSelectionTwoToOneButton(boolean enable) {
        if (enable) {
            this.m_selectionUsedToAvailableButton.setImage((Image)this.m_buttonContents[2]);
            this.m_selectionUsedToAvailableButton.setEnabled(true);
        } else {
            this.m_selectionUsedToAvailableButton.setImage((Image)this.m_disabledButtonContents[2]);
            this.m_selectionUsedToAvailableButton.setEnabled(false);
        }
    }

    private void enableAllOneToTwoButton(boolean enable) {
        if (enable) {
            this.m_allAvailableToUsedButton.setImage((Image)this.m_buttonContents[1]);
            this.m_allAvailableToUsedButton.setEnabled(true);
        } else {
            this.m_allAvailableToUsedButton.setImage((Image)this.m_disabledButtonContents[1]);
            this.m_allAvailableToUsedButton.setEnabled(false);
        }
    }

    private void enableAllTwoToOneButton(boolean enable) {
        if (enable) {
            this.m_allUsedToAvailableButton.setImage((Image)this.m_buttonContents[3]);
            this.m_allUsedToAvailableButton.setEnabled(true);
        } else {
            this.m_allUsedToAvailableButton.setImage((Image)this.m_disabledButtonContents[3]);
            this.m_allUsedToAvailableButton.setEnabled(false);
        }
    }

    private void enableSwapButton(boolean enable) {
        if (enable) {
            this.m_swapButton.setImage((Image)this.m_buttonContents[4]);
            this.m_swapButton.setEnabled(true);
        } else {
            this.m_swapButton.setImage((Image)this.m_disabledButtonContents[4]);
            this.m_swapButton.setEnabled(false);
        }
    }

    public void dispose() {
        this.removeListener();
        super.dispose();
    }

    public void addListModifiedListener(IUsedListModifiedListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeListModifiedListener(IUsedListModifiedListener listener) {
        this.m_listeners.remove(listener);
    }

    private void addListener() {
        this.m_selectionUsedToAvailableButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_selectionAvailableToUsedButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allAvailableToUsedButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allUsedToAvailableButton.addSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_swapButton.addSelectionListener((SelectionListener)this.m_selectionListener);
    }

    private void removeListener() {
        this.m_selectionAvailableToUsedButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_selectionUsedToAvailableButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allAvailableToUsedButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_allUsedToAvailableButton.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_availableTree.removeSelectionListener((SelectionListener)this.m_selectionListener);
        this.m_usedList.removeSelectionListener((SelectionListener)this.m_selectionListener);
    }

    public Button getAllAvailableToUsedButton() {
        return this.m_allAvailableToUsedButton;
    }

    public Button getAllUsedToAvailableButton() {
        return this.m_allUsedToAvailableButton;
    }

    public Tree getAvailableTree() {
        return this.m_availableTree;
    }

    public org.eclipse.swt.widgets.List getUsedList() {
        return this.m_usedList;
    }

    public Button getSelectionAvailableToUsedButton() {
        return this.m_selectionAvailableToUsedButton;
    }

    public Button getSelectionUsedToAvailableButton() {
        return this.m_selectionUsedToAvailableButton;
    }

    public Label getListOneLabel() {
        return (Label)this.m_availableTree.getData(LABEL);
    }

    public Label getListTwoLabel() {
        return (Label)this.m_usedList.getData(LABEL);
    }

    public static interface IChooserCompositeGuiObject {
        public String getParent();

        public String getTitle();

        public String getDisplayString();

        public Object getModelObject();
    }

    public static interface IUsedListModifiedListener {
        public void usedListModified(String[] var1);
    }

    private class WidgetSelectionListener
    implements SelectionListener {
        private WidgetSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(TreeElementChooserComposite.this.m_selectionAvailableToUsedButton)) {
                TreeElementChooserComposite.this.handleSelectionAvailableToUsedButtonEvent();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_selectionUsedToAvailableButton)) {
                TreeElementChooserComposite.this.handleSelectionUsedToAvailableButtonEvent();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_allAvailableToUsedButton)) {
                TreeElementChooserComposite.this.handleAllAvailableToUsedButtonEvent();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_allUsedToAvailableButton)) {
                TreeElementChooserComposite.this.handleAllUsedToAvailableButtonEvent();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_swapButton)) {
                TreeElementChooserComposite.this.handleSwapButtonEvent();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_availableTree)) {
                TreeElementChooserComposite.this.checkButtons();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_usedList)) {
                TreeElementChooserComposite.this.checkButtons();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "."));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Object o = e.getSource();
            if (o.equals(TreeElementChooserComposite.this.m_availableTree)) {
                TreeElementChooserComposite.this.handleSelectionAvailableToUsedButtonEvent();
                return;
            }
            if (o.equals(TreeElementChooserComposite.this.m_usedList)) {
                TreeElementChooserComposite.this.handleSelectionUsedToAvailableButtonEvent();
                return;
            }
            Assert.notReached((String)(String.valueOf(Messages.EventActivatedByUnknownWidget) + "."));
        }
    }
}

