/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.listener;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import javax.swing.tree.TreePath;
import org.eclipse.jubula.rc.common.AUTServer;
import org.eclipse.jubula.rc.common.exception.NoIdentifierForComponentException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.listener.AbstractAutSwingEventListener;
import org.eclipse.jubula.rc.swing.listener.ComponentHandler;
import org.eclipse.jubula.rc.swing.listener.RecordActions;
import org.eclipse.jubula.rc.swing.listener.RecordHelper;
import org.eclipse.jubula.tools.objects.IComponentIdentifier;
import org.eclipse.jubula.tools.xml.businessmodell.Action;

public class RecordListener
extends AbstractAutSwingEventListener {
    private static AutServerLogger log;
    private Component m_selectedComponent;
    private Component m_selectedComponentParent;
    private RecordHelper m_recordHelper = new RecordHelper();
    private RecordActions m_recordActions = new RecordActions();
    private int m_popupMouseBtn = 3;
    private ListSelectionListener m_listSelListener = new ListSelectionListener(){

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting() && AUTServer.getInstance().getMode() == 3) {
                JList jlst = (JList)e.getSource();
                IComponentIdentifier id = null;
                try {
                    id = ComponentHandler.getIdentifier(jlst);
                    if (jlst.getSelectedIndices().length != 0 && (RecordListener.this.getSelectedComponent() == jlst || RecordListener.this.getSelectedComponentParent() == jlst || RecordListener.this.getLastEvent().getSource() == jlst)) {
                        Action a = RecordListener.this.m_recordHelper.compSysToAction(id, "CompSystem.SelectValues");
                        RecordListener.this.m_recordActions.selectListValues(jlst, id, a);
                    }
                }
                catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                    log.error((Object)("no identifier for '" + RecordListener.this.getCurrentComponent()));
                }
            }
        }
    };
    private TreeExpansionListener m_treExpListener = new TreeExpansionListener(){

        public void treeCollapsed(TreeExpansionEvent event) {
            JTree jtre = (JTree)event.getSource();
            IComponentIdentifier id = null;
            TreePath path = event.getPath();
            if (path != null && AUTServer.getInstance().getMode() == 3 && (RecordListener.this.getSelectedComponent() == jtre || RecordListener.this.getSelectedComponentParent() == jtre || RecordListener.this.getLastEvent().getSource() == jtre)) {
                try {
                    id = ComponentHandler.getIdentifier(jtre);
                    RecordListener.this.m_recordActions.collExpTree(jtre, path, id, "CompSystem.CollapseByTextPath");
                }
                catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                    log.error((Object)("no identifier for '" + RecordListener.this.getCurrentComponent()));
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent event) {
            JTree jtre = (JTree)event.getSource();
            IComponentIdentifier id = null;
            TreePath path = event.getPath();
            if (path != null && AUTServer.getInstance().getMode() == 3 && (RecordListener.this.getSelectedComponent() == jtre || RecordListener.this.getSelectedComponentParent() == jtre || RecordListener.this.getLastEvent().getSource() == jtre)) {
                try {
                    id = ComponentHandler.getIdentifier(jtre);
                    RecordListener.this.m_recordActions.collExpTree(jtre, path, id, "CompSystem.ExpandByTextPath");
                }
                catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                    log.error((Object)("no identifier for '" + RecordListener.this.getCurrentComponent()));
                }
            }
        }
    };
    private TreeSelectionListener m_treSelListener = new TreeSelectionListener(){

        public void valueChanged(TreeSelectionEvent e) {
            JTree jtre = (JTree)e.getSource();
            IComponentIdentifier id = null;
            TreePath path = e.getPath();
            try {
                id = ComponentHandler.getIdentifier(jtre);
                if (path != null && AUTServer.getInstance().getMode() == 3 && (RecordListener.this.getSelectedComponent() == jtre || RecordListener.this.getSelectedComponentParent() == jtre || RecordListener.this.getLastEvent().getSource() == jtre)) {
                    Action a = RecordListener.this.m_recordHelper.compSysToAction(id, "CompSystem.SelectByTextPath");
                    int clickcount = 1;
                    RecordListener.this.m_recordActions.selectNode(jtre, path, id, a, clickcount);
                }
            }
            catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                log.error((Object)("no identifier for '" + RecordListener.this.getCurrentComponent()));
            }
        }
    };
    private ActionListener m_comboListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("comboBoxChanged") && AUTServer.getInstance().getMode() == 3) {
                JComboBox jcbx;
                Container parent;
                Component popComp = null;
                Component lastSrc = RecordListener.this.getEventSource(RecordListener.this.getLastEvent());
                if (lastSrc instanceof JList) {
                    parent = lastSrc.getParent();
                    while (parent != null) {
                        if (parent instanceof JPopupMenu) {
                            JPopupMenu popUp = (JPopupMenu)parent;
                            popComp = popUp.getInvoker();
                            if (popComp == null || !(popComp instanceof JComboBox)) break;
                            lastSrc = popComp;
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
                if (lastSrc instanceof JTextComponent && (parent = lastSrc.getParent()) instanceof JComboBox) {
                    lastSrc = parent;
                }
                if (e.getSource() instanceof JComboBox && (jcbx = (JComboBox)e.getSource()).getSelectedIndex() != -1 && (RecordListener.this.getSelectedComponent() == jcbx || RecordListener.this.getSelectedComponentParent() == jcbx || lastSrc == jcbx)) {
                    IComponentIdentifier id = null;
                    try {
                        id = ComponentHandler.getIdentifier(jcbx);
                        Action a = RecordListener.this.m_recordHelper.compSysToAction(id, "CompSystem.SelectValue");
                        RecordListener.this.m_recordActions.selectCbxValue(jcbx, id, a);
                        RecordListener.this.m_recordActions.setSelectionState(true);
                    }
                    catch (NoIdentifierForComponentException noIdentifierForComponentException) {
                        log.error((Object)("no identifier for '" + RecordListener.this.getCurrentComponent()));
                    }
                }
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.listener.RecordListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    protected void handleEvent(AWTEvent event) {
        if (event.equals(this.getLastEvent())) {
            return;
        }
        if (this.getEventSource(event) == null || event.getID() == 505) {
            return;
        }
        if (!this.m_recordHelper.isSupportedComponent(this.getEventSource(event)) && !(event instanceof KeyEvent)) {
            return;
        }
        if (event instanceof WindowEvent || event.getID() == 103 || event.getID() == 102) {
            this.handleWindowEvent(event);
        }
        if (event instanceof FocusEvent) {
            this.handleFocusEvent(event);
        }
        if (event instanceof MouseEvent && this.getEventSource(event) instanceof JComponent) {
            this.handleMouseEvent(event, this.getEventSource(event));
        }
        if (event instanceof KeyEvent) {
            this.setSelectedComponent(this.getEventSource(event));
            this.setSelectedComponentParent(this.getEventSource(event).getParent());
            KeyEvent keyEvent = (KeyEvent)event;
            this.handleKeyEvent(keyEvent);
        }
        if (event.getID() == 504) {
            this.setSelectedComponent(this.getEventSource(event));
            this.setSelectedComponentParent(this.getEventSource(event).getParent());
            this.handleMouseEnterEvent(this.getEventSource(event));
        }
        if (event.getID() != 505) {
            this.setLastEvent(event);
        }
    }

    protected void handleMouseEnterEvent(Component source) {
        if (source instanceof JList && !this.isComboPopup(source)) {
            JList jlst = (JList)source;
            boolean containsListener = false;
            ListSelectionListener[] lsls = jlst.getListSelectionListeners();
            int i = 0;
            while (i < lsls.length) {
                ListSelectionListener listener = lsls[i];
                if (listener == this.m_listSelListener) {
                    containsListener = true;
                }
                ++i;
            }
            if (!containsListener) {
                jlst.addListSelectionListener(this.m_listSelListener);
            }
        } else if (source instanceof JTree) {
            JTree jtre = (JTree)source;
            boolean containsSelListener = false;
            TreeSelectionListener[] tsl = jtre.getTreeSelectionListeners();
            int i = 0;
            while (i < tsl.length) {
                TreeSelectionListener listener = tsl[i];
                if (listener == this.m_treSelListener) {
                    containsSelListener = true;
                }
                ++i;
            }
            if (!containsSelListener) {
                jtre.addTreeSelectionListener(this.m_treSelListener);
            }
            boolean containsExpListener = false;
            TreeExpansionListener[] tel = jtre.getTreeExpansionListeners();
            int i2 = 0;
            while (i2 < tel.length) {
                TreeExpansionListener listener = tel[i2];
                if (listener == this.m_treExpListener) {
                    containsExpListener = true;
                }
                ++i2;
            }
            if (!containsExpListener) {
                jtre.addTreeExpansionListener(this.m_treExpListener);
            }
        } else if (source instanceof JComboBox || source.getParent() instanceof JComboBox) {
            Component src = source;
            if (src.getParent() instanceof JComboBox) {
                src = source.getParent();
            }
            JComboBox jcbx = (JComboBox)src;
            boolean containsActionListener = false;
            ActionListener[] actL = jcbx.getActionListeners();
            int i = 0;
            while (i < actL.length) {
                ActionListener listener = actL[i];
                if (listener == this.m_comboListener) {
                    containsActionListener = true;
                }
                ++i;
            }
            if (!containsActionListener) {
                jcbx.addActionListener(this.m_comboListener);
            }
        }
    }

    protected void handleMouseEvent(AWTEvent event, Component source) {
        MouseEvent me = (MouseEvent)event;
        if (me.isPopupTrigger()) {
            this.m_popupMouseBtn = me.getButton();
            this.m_recordActions.setPopupMouseButton(this.m_popupMouseBtn);
        }
        IComponentIdentifier id = null;
        try {
            id = ComponentHandler.getIdentifier(source);
            if (this.getLastEvent() == null) {
                return;
            }
            if (this.getLastEvent().getID() == 502 && !(me.getSource() instanceof JPopupMenu) && me.getButton() == this.m_popupMouseBtn) {
                this.m_recordActions.clickGraphComp(id, me, source);
            }
            if (me.getID() == 502) {
                if (me.getButton() == this.m_popupMouseBtn && this.getLastEvent().getSource() instanceof JPopupMenu) {
                    return;
                }
                if (source.getParent() instanceof JComboBox && source instanceof JButton) {
                    return;
                }
                if (source.getParent() instanceof JComboBox && !(source instanceof JComboBox)) {
                    id = ComponentHandler.getIdentifier(source.getParent());
                }
                Action a = new Action();
                if (source instanceof JTabbedPane) {
                    JTabbedPane jtpn = (JTabbedPane)source;
                    a = this.m_recordHelper.compSysToAction(id, "CompSystem.SelectTab");
                    this.m_recordActions.selectTab(jtpn, id, a);
                } else if (source instanceof JTable) {
                    JTable jtbl = (JTable)source;
                    int clickcount = me.getClickCount();
                    a = this.m_recordHelper.compSysToAction(id, "CompSystem.SelectCellNew");
                    this.m_recordActions.selectTableCell(jtbl, id, clickcount, a);
                } else if (source instanceof JMenuItem && !(source instanceof JMenu)) {
                    JMenuItem jmi = (JMenuItem)source;
                    this.m_recordActions.selectMenuItem(jmi);
                } else if (!(source == null || source instanceof JMenu || source instanceof JTree || source instanceof JList || source instanceof JTextComponent && ((JTextComponent)source).isEditable() || source.getParent() instanceof JTable || me.getButton() == this.m_popupMouseBtn)) {
                    this.m_recordActions.clickGraphComp(id, me, source);
                }
            }
        }
        catch (NoIdentifierForComponentException noIdentifierForComponentException) {
            log.error((Object)("no identifier for '" + this.getCurrentComponent()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyEvent(KeyEvent keyEvent) {
        Object object = this.getComponentLock();
        synchronized (object) {
            if (keyEvent.getKeyCode() != 0 && keyEvent.getID() == 401) {
                int accepted = this.getAcceptor().accept(keyEvent);
                boolean isSingleTrigger = this.getAcceptor().isSingleLineTrigger(keyEvent);
                boolean isMultiTrigger = this.getAcceptor().isMultiLineTrigger(keyEvent);
                IComponentIdentifier id = null;
                Component source = this.getEventSource(keyEvent);
                id = this.m_recordHelper.getApplicationCompID();
                int keycode = keyEvent.getKeyCode();
                if (accepted != 2 && accepted != 3) {
                    if (!(source instanceof JTextComponent) && !(source instanceof JComboBox) && keycode != 18 && keycode != 17 && keycode != 16) {
                        this.m_recordActions.keyComboApp(id, keyEvent, keycode);
                    }
                    if ((source instanceof JTextField || source instanceof JComboBox) && isSingleTrigger || (source instanceof JTextArea || source instanceof JTextPane || source instanceof JEditorPane) && isMultiTrigger) {
                        this.m_recordActions.replaceText(source);
                        this.m_recordActions.keyComboApp(id, keyEvent, keycode);
                    }
                }
                if (accepted == 2) {
                    if (source instanceof JTextComponent || source instanceof JComboBox) {
                        this.m_recordActions.replaceText(source);
                    }
                    this.changeCheckModeState(4);
                }
            }
        }
    }

    protected void handleFocusEvent(AWTEvent event) {
        Component source = this.getEventSource(event);
        FocusEvent fe = (FocusEvent)event;
        if (fe.getID() == 1004 && (source instanceof JTextComponent || source instanceof JComboBox)) {
            String content = null;
            if (source instanceof JTextComponent) {
                JTextComponent textComp = (JTextComponent)source;
                content = textComp.getText();
            }
            if (source instanceof JComboBox) {
                JComboBox cbx = (JComboBox)source;
                content = this.m_recordHelper.getRenderedComboText(cbx);
            }
            this.m_recordActions.addTextCompContent(source, content);
            this.m_recordActions.setComponentParent(source.getParent());
            if (source.getParent() instanceof JTable) {
                JTable tbl = (JTable)source.getParent();
                this.m_recordActions.setTableRowColumn(tbl.getSelectedRow(), tbl.getSelectedColumn());
            }
        }
        if (fe.getID() == 1005 && (source instanceof JTextComponent || source instanceof JComboBox)) {
            this.m_recordActions.replaceText(source);
        }
    }

    protected void handleWindowEvent(AWTEvent event) {
        Component window = this.getEventSource(event);
        IComponentIdentifier id = this.m_recordHelper.getApplicationCompID();
        Action wfw = this.m_recordHelper.compSysToAction(id, "CompSystem.WaitForWindow");
        Action wfwtc = this.m_recordHelper.compSysToAction(id, "CompSystem.WaitForWindowToClose");
        if (window instanceof JFrame || window instanceof JDialog) {
            if (event.getID() == 200 && this.getLastEvent().getID() != 102 || event.getID() == 102) {
                this.m_recordActions.waitForWindow(window, id, wfw);
            }
            if (event.getID() == 202 && this.getLastEvent().getID() != 103 || event.getID() == 103) {
                this.m_recordActions.waitForWindow(window, id, wfwtc);
            }
        }
    }

    private boolean isComboPopup(Component source) {
        if (source instanceof ComboPopup) {
            return true;
        }
        if (source instanceof JList) {
            Container parent = source.getParent();
            while (parent != null) {
                if (parent instanceof ComboPopup) {
                    return true;
                }
                parent = parent.getParent();
            }
        }
        return false;
    }

    protected Component getSelectedComponent() {
        return this.m_selectedComponent;
    }

    protected void setSelectedComponent(Component selectedComponent) {
        this.m_selectedComponent = selectedComponent;
    }

    protected Component getSelectedComponentParent() {
        return this.m_selectedComponentParent;
    }

    protected void setSelectedComponentParent(Component selectedComponentParent) {
        this.m_selectedComponentParent = selectedComponentParent;
    }

    public void update() {
    }

    public boolean highlightComponent(IComponentIdentifier comp) {
        return true;
    }
}

