/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.driver;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jubula.rc.common.driver.DragAndDropHelper;
import org.eclipse.jubula.rc.common.driver.IEventMatcher;
import org.eclipse.jubula.rc.common.driver.IRobotEventConfirmer;
import org.eclipse.jubula.rc.common.driver.InterceptorOptions;
import org.eclipse.jubula.rc.common.driver.RobotTiming;
import org.eclipse.jubula.rc.common.exception.RobotException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.common.util.WorkaroundUtil;
import org.eclipse.jubula.tools.objects.event.EventFactory;

class RobotEventConfirmerAwtImpl
implements IRobotEventConfirmer,
AWTEventListener {
    private static AutServerLogger log;
    private boolean m_enabled = false;
    private boolean m_waiting = false;
    private InterceptorOptions m_options;
    private Object m_eventTarget;
    private IEventMatcher m_eventMatcher;
    private List m_eventList = new LinkedList();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.driver.RobotEventConfirmerAwtImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    RobotEventConfirmerAwtImpl(InterceptorOptions options) {
        this.m_options = options;
    }

    private boolean isEventMatching(AWTEvent event) {
        Object eventSource = event.getSource();
        return (this.m_eventTarget == null || event.getID() == 506 || this.matchComponent(this.m_eventTarget, eventSource)) && this.m_eventMatcher.isMatching((Object)event);
    }

    private boolean matchComponent(Object evTarget, Object evSource) {
        return this.isComponentMatching(evTarget, evSource) || this.isComponentMatching(evSource, evTarget);
    }

    private boolean isComponentMatching(Object expComp, Object currComp) {
        if (expComp == currComp) {
            return true;
        }
        boolean match = false;
        if (currComp instanceof Container) {
            Container curr = (Container)currComp;
            Component[] children = curr.getComponents();
            int childLength = children.length;
            int i = 0;
            while (i < childLength) {
                match = this.isComponentMatching(expComp, children[i]);
                if (match) {
                    return match;
                }
                ++i;
            }
        }
        return match;
    }

    private synchronized boolean isEventMatching(List eventList) {
        Iterator it = eventList.iterator();
        while (it.hasNext()) {
            AWTEvent event = (AWTEvent)it.next();
            if (!this.isEventMatching(event)) continue;
            return true;
        }
        return false;
    }

    private synchronized void addEventToList(AWTEvent event) {
        ((LinkedList)this.m_eventList).addFirst(event);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Received event: " + String.valueOf(event.toString())));
        }
    }

    private synchronized void stopWaiting() {
        this.m_waiting = false;
        this.notify();
    }

    public synchronized void eventDispatched(AWTEvent event) {
        if (!this.m_enabled) {
            return;
        }
        this.addEventToList(event);
        if (this.m_waiting && this.isEventMatching(this.m_eventList)) {
            this.stopWaiting();
        }
    }

    void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
        this.m_eventList.clear();
        if (enabled) {
            int i = 0;
            while (i < this.m_options.getEventMask().length) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, this.m_options.getEventMask()[i]);
                ++i;
            }
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void waitToConfirm(Object eventTarget, IEventMatcher matcher, long pTimeout) throws RobotException {
        if (DragAndDropHelper.getInstance().isDragMode()) {
            this.setEnabled(false);
            return;
        }
        this.m_eventTarget = eventTarget;
        this.m_eventMatcher = matcher;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Waiting for EventID: " + String.valueOf(matcher) + " on Component: " + String.valueOf(this.m_eventTarget)));
        }
        try {
            boolean fallBackMatching;
            if (this.isEventMatching(this.m_eventList)) {
                Object var11_4 = null;
                this.setEnabled(false);
                return;
            }
            if (EventQueue.isDispatchThread()) {
                throw new IllegalThreadStateException();
            }
            this.m_waiting = true;
            try {
                long timeout = pTimeout;
                long done = System.currentTimeMillis() + timeout;
                do {
                    this.wait(pTimeout);
                    long now = System.currentTimeMillis();
                    timeout = done - now;
                } while (this.m_waiting && timeout > 0L);
            }
            catch (InterruptedException e) {
                throw new RobotException((Throwable)e);
            }
            if (this.m_waiting && !(fallBackMatching = this.m_eventMatcher.isFallBackEventMatching(this.m_eventList, this.m_eventTarget)) && !WorkaroundUtil.isIgnoreTimeout()) {
                throw new RobotException("Timeout received before confirming the posted event: " + this.m_eventMatcher.getEventId(), EventFactory.createActionError((String)"TestErrorEvent.ConfirmationTimeout"));
            }
        }
        catch (Throwable throwable) {
            Object var11_5 = null;
            this.setEnabled(false);
            throw throwable;
        }
        {
            Object var11_6 = null;
            this.setEnabled(false);
            return;
        }
    }

    public void waitToConfirm(Object eventTarget, IEventMatcher matcher) throws RobotException {
        this.waitToConfirm(eventTarget, matcher, RobotTiming.getEventConfirmTimeout());
    }
}

