/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.swing.swing.implclasses;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.util.Arrays;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.Validate;
import org.eclipse.jubula.rc.common.driver.ClickOptions;
import org.eclipse.jubula.rc.common.driver.IEventThreadQueuer;
import org.eclipse.jubula.rc.common.driver.IRobot;
import org.eclipse.jubula.rc.common.driver.IRunnable;
import org.eclipse.jubula.rc.common.exception.StepExecutionException;
import org.eclipse.jubula.rc.common.logger.AutServerLogger;
import org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxImplClass;
import org.eclipse.jubula.rc.swing.swing.implclasses.JListHelper;
import org.eclipse.jubula.tools.objects.event.EventFactory;

public class JComboBoxHelper {
    private static AutServerLogger log;
    private final IRobot m_robot;
    private final IEventThreadQueuer m_eventThreadQueuer;
    private final JListHelper m_listHelper;
    private final JComboBoxImplClass m_implClass;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = new AutServerLogger((Class)clazz);
    }

    public JComboBoxHelper(JComboBoxImplClass implClass) {
        Validate.notNull((Object)implClass, (String)"The JComboBox implementation class must not be null");
        this.m_robot = implClass.getRobot();
        this.m_eventThreadQueuer = implClass.getEventThreadQueuer();
        this.m_implClass = implClass;
        this.m_listHelper = new JListHelper(implClass);
    }

    private Component getComboBoxEditorComponent(JComboBox component) throws StepExecutionException {
        ComboBoxEditor cbe = component.getEditor();
        if (cbe == null) {
            throw new StepExecutionException("no ComboBoxEditor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        Component c = cbe.getEditorComponent();
        if (c == null) {
            throw new StepExecutionException("no EditorComponent found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        return c;
    }

    private Component getComponentViaHierarchy(Container component, Class c) {
        Component[] comps = component.getComponents();
        int i = 0;
        while (i < comps.length) {
            if (c.isInstance(comps[i])) {
                return comps[i];
            }
            ++i;
        }
        i = 0;
        while (i < comps.length) {
            Component ct;
            if (comps[i] instanceof Container && (ct = this.getComponentViaHierarchy((Container)comps[i], c)) != null) {
                return ct;
            }
            ++i;
        }
        return null;
    }

    private JPopupMenu getPopupMenu(JComboBox component) throws StepExecutionException {
        AccessibleContext ac = component.getAccessibleContext();
        int i = 0;
        while (i < ac.getAccessibleChildrenCount()) {
            Accessible a = ac.getAccessibleChild(i);
            if (a instanceof JPopupMenu) {
                return (JPopupMenu)a;
            }
            ++i;
        }
        throw new StepExecutionException("cannot find dropdown list", EventFactory.createActionError((String)"TestErrorEvent.DropdownListNotFound"));
    }

    public void input(String text, boolean replace) throws StepExecutionException, IllegalArgumentException {
        Validate.notNull((Object)text, (String)"text must not be null");
        Component editor = this.getComboBoxEditorComponent((JComboBox)this.m_implClass.getComponent());
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        if (replace) {
            this.selectAll();
        }
        this.m_robot.type((Object)editor, text);
    }

    private boolean isPopupVisible() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.rc.swing.swing.implclasses.JComboBoxHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Boolean visible = (Boolean)this.m_eventThreadQueuer.invokeAndWait(String.valueOf(clazz.getName()) + "isPopupVisible", new IRunnable(){

            public Object run() throws StepExecutionException {
                JComboBox comboBox = (JComboBox)JComboBoxHelper.this.m_implClass.getComponent();
                return comboBox.isPopupVisible() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return visible;
    }

    private Rectangle findArrowIconArea() {
        JComboBox comboBox = (JComboBox)this.m_implClass.getComponent();
        Component editor = this.getComboBoxEditorComponent(comboBox);
        Rectangle r = null;
        if (editor == null) {
            throw new StepExecutionException("could not find editor", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        Rectangle[] ra = SwingUtilities.computeDifference(comboBox.getBounds(), editor.getBounds());
        if (ra == null || ra.length < 1) {
            throw new StepExecutionException("could not arrow icon", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        r = ra[0];
        double bestAreaIndex = Double.MAX_VALUE;
        int i = 0;
        while (i < ra.length) {
            if (ra[i].height > 0 && ra[i].width > 0) {
                double areaIndex = (double)ra[i].width / (double)ra[i].height - 1.0;
                if (areaIndex < 0.0) {
                    areaIndex *= -1.0;
                }
                if (areaIndex < bestAreaIndex) {
                    bestAreaIndex = areaIndex;
                    r = ra[i];
                }
            }
            ++i;
        }
        return r;
    }

    private JPopupMenu openPopupMenu() {
        JComboBox comboBox = (JComboBox)this.m_implClass.getComponent();
        if (!this.isPopupVisible()) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("javax.swing.JButton");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Component c = this.getComponentViaHierarchy(comboBox, clazz);
            Rectangle r = null;
            if (c == null && !comboBox.isEditable()) {
                c = comboBox;
            } else if (c == null && comboBox.isEditable()) {
                c = comboBox;
                r = this.findArrowIconArea();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Opening popup by clicking on: " + c));
            }
            this.m_robot.click((Object)c, (Object)r);
        }
        if (!this.isPopupVisible()) {
            log.debug((Object)"Dropdown list still not visible, must be an error");
            throw new StepExecutionException("dropdown list not visible", EventFactory.createActionError((String)"TestErrorEvent.DropdownListNotFound"));
        }
        return this.getPopupMenu(comboBox);
    }

    private JList findJList() {
        JList list;
        JPopupMenu jPopupMenu = this.openPopupMenu();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("javax.swing.JList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((list = (JList)this.getComponentViaHierarchy(jPopupMenu, clazz)) == null) {
            throw new StepExecutionException("list component not found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        return list;
    }

    public void select(String[] values, String operator, String searchType, double maxWidth) throws StepExecutionException, IllegalArgumentException {
        int i = 0;
        while (i < values.length) {
            String text = values[i];
            Validate.notNull((Object)text, (String)"text must not be null");
            ++i;
        }
        JList list = this.findJList();
        Object[] indices = this.m_listHelper.findIndicesOfValues(list, values, operator, searchType);
        Arrays.sort(indices);
        if (indices.length == 0) {
            throw new StepExecutionException("Text '" + Arrays.asList(values).toString() + "' not found", EventFactory.createActionError((String)"TestErrorEvent.NotFound"));
        }
        this.m_listHelper.clickOnIndex(list, (Integer)indices[0], ClickOptions.create().setClickCount(1), maxWidth);
    }

    public void select(int index, double maxWidth) {
        this.m_listHelper.clickOnIndex(this.findJList(), new Integer(index), ClickOptions.create().setClickCount(1), maxWidth);
    }

    public void selectAll() {
        this.click(new Integer(1));
        this.m_robot.keyStroke(String.valueOf(this.m_robot.getSystemModifierSpec()) + " A");
    }

    public void click(Integer count) {
        Component editor = this.getComboBoxEditorComponent((JComboBox)this.m_implClass.getComponent());
        if (editor == null) {
            throw new StepExecutionException("no editor found", EventFactory.createActionError((String)"TestErrorEvent.CompNotFound"));
        }
        this.m_robot.click((Object)editor, null, ClickOptions.create().setClickCount(count.intValue()));
    }

    public boolean containsValue(String value, String operator) {
        return this.m_listHelper.containsValue(this.findJList(), value, operator);
    }

    public boolean containsValue(String value) {
        return this.m_listHelper.containsValue(this.findJList(), value);
    }

    public boolean isEditable() {
        Boolean editable = (Boolean)this.m_eventThreadQueuer.invokeAndWait("isEditable", new IRunnable(){

            public Object run() {
                JComboBox comboBox = (JComboBox)JComboBoxHelper.this.m_implClass.getComponent();
                return comboBox.isEditable() ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return editable;
    }

    public String getSelectedValue() {
        Object o = this.m_eventThreadQueuer.invokeAndWait("getSelectedItem", new IRunnable(){

            public Object run() {
                return JComboBoxHelper.this.getText();
            }
        });
        return o != null ? o.toString() : null;
    }

    public String getText() {
        final JComboBox comboBox = (JComboBox)this.m_implClass.getComponent();
        final int selIndex = comboBox.getSelectedIndex();
        if (selIndex == -1) {
            return null;
        }
        final JList jlist = new JList(comboBox.getModel());
        Object o = this.m_eventThreadQueuer.invokeAndWait("getText", new IRunnable(){

            public Object run() {
                Component disp = comboBox.getRenderer().getListCellRendererComponent(jlist, jlist.getModel().getElementAt(selIndex), selIndex, true, comboBox.hasFocus());
                return JComboBoxHelper.this.m_implClass.getRenderedText(disp, false);
            }
        });
        return o.toString();
    }
}

