/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.i18n;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompSystemI18n {
    private static Logger log;
    private static final List PLUGIN_BUNDLES;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.i18n.CompSystemI18n");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
        PLUGIN_BUNDLES = new LinkedList();
    }

    private CompSystemI18n() {
    }

    public static void addResourceBundle(ResourceBundle bundle) {
        if (bundle == null) {
            log.error("ResourceBundle is null!");
            return;
        }
        PLUGIN_BUNDLES.add(bundle);
    }

    public static String getString(String key) {
        if ("".equals(key)) {
            return key;
        }
        String str = key;
        try {
            str = CompSystemI18n.getStringInternal(key);
        }
        catch (MissingResourceException mre) {
            CompSystemI18n.logError(key, mre);
        }
        return str;
    }

    private static void logError(String key, Throwable throwable) {
        log.error("Cannot find I18N-key in resource bundles: " + key, throwable);
    }

    private static String getStringInternal(String key) {
        Iterator bundleIter = PLUGIN_BUNDLES.iterator();
        while (bundleIter.hasNext()) {
            ResourceBundle bundle = (ResourceBundle)bundleIter.next();
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        String string = "No entry found for key: " + key;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.i18n.CompSystemI18n");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        throw new MissingResourceException(string, clazz.getName(), key);
    }

    public static String getString(String key, boolean fallBack) {
        if (key == null) {
            return "";
        }
        if ("".equals(key)) {
            return key;
        }
        String str = "";
        try {
            str = CompSystemI18n.getStringInternal(key);
        }
        catch (MissingResourceException mre) {
            if (fallBack) {
                return key;
            }
            CompSystemI18n.logError(key, mre);
        }
        return str;
    }

    /*
     * Unable to fully structure code
     */
    public static String getString(String key, Object[] args) {
        if ("".equals(key)) {
            return key;
        }
        try {
            formatter = new MessageFormat(CompSystemI18n.getStringInternal(key));
            return formatter.format(args);
        }
        catch (MissingResourceException e) {
            CompSystemI18n.logError(key, e);
            buf = new StringBuffer(key);
            i = 0;
            ** while (i < args.length)
        }
lbl-1000:
        // 1 sources

        {
            if (args[i] != null) {
                buf.append(" ");
                buf.append(args[i]);
            }
            ++i;
            continue;
        }
lbl18:
        // 1 sources

        return buf.toString();
    }

    public static void setLanguage(String lang) {
        Locale.setDefault(new Locale(lang, ""));
    }

    public static List getPluginBundles() {
        return new ArrayList(PLUGIN_BUNDLES);
    }

    public static String bundlesToString() {
        StringBuffer entries = new StringBuffer();
        Iterator bundlesIt = PLUGIN_BUNDLES.iterator();
        while (bundlesIt.hasNext()) {
            ResourceBundle bundle = (ResourceBundle)bundlesIt.next();
            Enumeration<String> keys = bundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = String.valueOf(keys.nextElement());
                String value = bundle.getString(key);
                entries.append(key).append("=").append(value).append("\n");
            }
        }
        return entries.toString();
    }

    public static void fromString(String string) {
        ByteArrayInputStream stream = new ByteArrayInputStream(string.getBytes());
        try {
            PropertyResourceBundle bundle = new PropertyResourceBundle(stream);
            PLUGIN_BUNDLES.clear();
            CompSystemI18n.addResourceBundle(bundle);
        }
        catch (IOException e) {
            log.error("An error occured: ", (Throwable)e);
        }
    }
}

