/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.serialisation;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerializedImage {
    private static final Logger LOG;
    private static final String IMAGE_FORMAT = "png";
    private byte[] m_data = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jubula.tools.serialisation.SerializedImage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LoggerFactory.getLogger((Class)clazz);
    }

    private SerializedImage() {
    }

    public static SerializedImage computeSerializeImage(BufferedImage img) {
        SerializedImage si = new SerializedImage();
        ByteArrayOutputStream imageByteOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)img, IMAGE_FORMAT, imageByteOutputStream);
            imageByteOutputStream.flush();
            si.setData(imageByteOutputStream.toByteArray());
            imageByteOutputStream.close();
        }
        catch (IOException e) {
            LOG.error("An error occured: ", (Throwable)e);
        }
        return si;
    }

    public static BufferedImage computeImage(SerializedImage si) {
        BufferedImage bi = null;
        try {
            ByteArrayInputStream imageByteInputStream = new ByteArrayInputStream(si.getData());
            bi = ImageIO.read(imageByteInputStream);
        }
        catch (IOException e) {
            LOG.error("An error occured: ", (Throwable)e);
        }
        return bi;
    }

    private void setData(byte[] data) {
        this.m_data = data;
    }

    public byte[] getData() {
        return this.m_data;
    }
}

