/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.tools.utils;

import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.jubula.tools.utils.DevNull;
import org.eclipse.jubula.tools.utils.EnvironmentUtils;
import org.eclipse.jubula.tools.utils.TimeUtil;

public class ExternalCommandExecutor {
    private static final String[] DOS_CMD = new String[]{"command.com", "/c"};
    private static final String[] WIN_NT_CMD = new String[]{"cmd.exe", "/c"};
    private static final String[] WIN_9X_CMD = new String[]{"command.com", "/c"};

    public MonitorTask executeCommand(File path, String cmd, int timeout) {
        String[] prepend = new String[]{};
        if (EnvironmentUtils.isWin9xOS()) {
            prepend = WIN_9X_CMD;
        } else if (EnvironmentUtils.isDosOS()) {
            prepend = DOS_CMD;
        } else if (EnvironmentUtils.isWindowsOS()) {
            prepend = WIN_NT_CMD;
        }
        MonitorTask mt = new MonitorTask(path, prepend, cmd);
        Timer timer = new Timer();
        timer.schedule((TimerTask)mt, timeout);
        while (!mt.isFinished()) {
            TimeUtil.delay(750L);
        }
        timer.cancel();
        return mt;
    }

    public class MonitorTask
    extends TimerTask {
        private ExecuteTask m_task = null;
        private boolean m_finished = false;
        private int m_exitCode = 0;
        private Process m_process = null;
        private boolean m_isTimeout;
        private boolean m_isCmdValid;

        public MonitorTask(File path, String[] prepend, String cmd) {
            this.m_task = new ExecuteTask(path, prepend, cmd);
            this.m_task.start();
        }

        public void run() {
            if (this.finishTask()) {
                this.m_isTimeout = true;
            }
        }

        public boolean finishTask() {
            if (!this.isFinished()) {
                if (this.m_process != null) {
                    this.m_process.destroy();
                }
                this.m_finished = true;
                return true;
            }
            return false;
        }

        public boolean isFinished() {
            return this.m_finished;
        }

        public int getExitCode() throws IllegalThreadStateException {
            return this.m_process.exitValue();
        }

        public boolean hasTimeoutOccurred() {
            return this.m_isTimeout;
        }

        public boolean wasCmdValid() {
            return this.m_isCmdValid;
        }

        class ExecuteTask
        extends Thread {
            private String m_cmd;
            private String[] m_cmdParams;
            private String[] m_prepend;
            private File m_dir = null;

            public ExecuteTask(File path, String[] prepend, String cmdLine) {
                this.splitCmdLine(cmdLine);
                this.m_prepend = prepend != null ? prepend : new String[]{};
                this.m_dir = path;
                MonitorTask.this.m_isTimeout = false;
                MonitorTask.this.m_isCmdValid = true;
            }

            private void splitCmdLine(String cmdLine) {
                try {
                    String cmdLinePar = cmdLine.replaceAll("[\\\\]", "\\\\\\\\");
                    StreamTokenizer tk = new StreamTokenizer(new StringReader(cmdLinePar));
                    tk.slashSlashComments(false);
                    tk.slashStarComments(false);
                    tk.lowerCaseMode(false);
                    tk.resetSyntax();
                    tk.wordChars(0, 65535);
                    tk.whitespaceChars(32, 32);
                    tk.whitespaceChars(9, 9);
                    tk.quoteChar(34);
                    tk.quoteChar(39);
                    this.m_cmd = tk.nextToken() != -1 ? tk.sval : "";
                    ArrayList<String> params = new ArrayList<String>();
                    while (tk.nextToken() != -1) {
                        params.add(tk.sval);
                    }
                    this.m_cmdParams = params.toArray(new String[params.size()]);
                }
                catch (IOException iOException) {}
                if (this.m_cmd == null) {
                    this.m_cmd = "";
                }
                if (this.m_cmdParams == null) {
                    this.m_cmdParams = new String[0];
                }
            }

            public void run() {
                Runtime runtime = Runtime.getRuntime();
                try {
                    File absCmdFile;
                    File cmdFile = new File(this.m_cmd);
                    if (!cmdFile.isAbsolute() && (absCmdFile = new File(this.m_dir, this.m_cmd)).exists()) {
                        this.m_cmd = absCmdFile.getCanonicalPath();
                    }
                    ArrayList<String> commandTokens = new ArrayList<String>();
                    int i = 0;
                    while (i < this.m_prepend.length) {
                        commandTokens.add(this.m_prepend[i]);
                        ++i;
                    }
                    if (EnvironmentUtils.isWindowsOS()) {
                        commandTokens.add("\"" + this.m_cmd + "\"");
                    } else {
                        commandTokens.add(this.m_cmd);
                    }
                    i = 0;
                    while (i < this.m_cmdParams.length) {
                        commandTokens.add(this.m_cmdParams[i]);
                        ++i;
                    }
                    MonitorTask.this.m_process = runtime.exec(commandTokens.toArray(new String[commandTokens.size()]), null, this.m_dir);
                    if (MonitorTask.this.m_process != null) {
                        new DevNull(MonitorTask.this.m_process.getErrorStream()).start();
                        new DevNull(MonitorTask.this.m_process.getInputStream()).start();
                        MonitorTask.this.m_exitCode = MonitorTask.this.m_process.waitFor();
                    } else {
                        MonitorTask.this.m_isCmdValid = false;
                    }
                }
                catch (IOException iOException) {
                    MonitorTask.this.m_isCmdValid = false;
                }
                catch (InterruptedException interruptedException) {}
                MonitorTask.this.m_finished = true;
            }
        }
    }
}

