/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.converter.internal;

import org.eclipse.jwt.converter.internal.ATLTransformation;
import org.eclipse.jwt.converter.internal.exception.UnsupportedVersionException;

public class ConverterManager {
    private static ConverterManager instance = null;
    public static final int VER_0_0_0 = 0;
    public static final int VER_0_0_1 = 1;
    public static final int VER_0_1_0 = 10;
    public static final int VER_0_2_0 = 20;
    public static final int VER_0_3_0 = 30;
    public static final int VER_0_4_0 = 40;
    public static final int VER_0_5_0 = 50;
    public static final int VER_0_6_0 = 60;
    public static final int VER_0_7_0 = 70;
    public static final int VER_1_0_0 = 100;
    public static final int VER_1_1_0 = 110;
    private static String VER_STR_0_0_0 = "0.0.0";
    private static String VER_STR_0_0_1 = "0.0.1";
    private static String VER_STR_0_1_0 = "0.1.0";
    private static String VER_STR_0_2_0 = "0.2.0";
    private static String VER_STR_0_3_0 = "0.3.0";
    private static String VER_STR_0_4_0 = "0.4.0";
    private static String VER_STR_0_5_0 = "0.5.0";
    private static String VER_STR_0_6_0 = "0.6.0";
    private static String VER_STR_0_7_0 = "0.7.0";
    private static String VER_STR_1_0_0 = "1.0.0";
    private static String VER_STR_1_1_0 = "1.1.0";

    public static ConverterManager getInstance() {
        if (instance == null) {
            instance = new ConverterManager();
        }
        return instance;
    }

    private int stringToIntVersion(String version) {
        if (version.equals(VER_STR_0_0_0)) {
            return 0;
        }
        if (version.equals(VER_STR_0_0_1)) {
            return 1;
        }
        if (version.equals(VER_STR_0_1_0)) {
            return 10;
        }
        if (version.equals(VER_STR_0_2_0)) {
            return 20;
        }
        if (version.equals(VER_STR_0_3_0)) {
            return 30;
        }
        if (version.equals(VER_STR_0_4_0)) {
            return 40;
        }
        if (version.equals(VER_STR_0_5_0)) {
            return 50;
        }
        if (version.equals(VER_STR_0_6_0)) {
            return 60;
        }
        if (version.equals(VER_STR_0_7_0)) {
            return 70;
        }
        if (version.equals(VER_STR_1_0_0)) {
            return 100;
        }
        if (version.equals(VER_STR_1_1_0)) {
            return 110;
        }
        return 0;
    }

    public void convert(String inFilePath, String outFilePath, String inVersion, String outVersion) throws Exception {
        this.convert(inFilePath, outFilePath, this.stringToIntVersion(inVersion), this.stringToIntVersion(outVersion));
    }

    public void convert(String inFilePath, String outFilePath, int inVersion, int outVersion) throws Exception {
        ATLTransformation atl = ATLTransformation.getInstance();
        switch (inVersion) {
            case 0: {
                atl.setSourceVersion(0);
                atl.setTargetVersion(1, VER_STR_0_0_1);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 1) break;
            }
            case 1: {
                atl.setSourceVersion(1);
                atl.setTargetVersion(10, VER_STR_0_1_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 10) break;
            }
            case 10: {
                atl.setSourceVersion(10);
                atl.setTargetVersion(20, VER_STR_0_2_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 20) break;
            }
            case 20: {
                atl.setSourceVersion(20);
                atl.setTargetVersion(30, VER_STR_0_3_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 30) break;
            }
            case 30: {
                atl.setSourceVersion(30);
                atl.setTargetVersion(40, VER_STR_0_4_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 40) break;
            }
            case 40: {
                atl.setSourceVersion(40);
                atl.setTargetVersion(50, VER_STR_0_5_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 50) break;
            }
            case 50: {
                atl.setSourceVersion(50);
                atl.setTargetVersion(60, VER_STR_0_6_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 60) break;
            }
            case 60: {
                atl.setSourceVersion(60);
                atl.setTargetVersion(70, VER_STR_0_7_0);
                atl.jwt2jwt(inFilePath, outFilePath);
                if (outVersion == 70) break;
            }
            case 70: {
                atl.setSourceVersion(70);
                atl.setTargetVersion(100, VER_STR_1_0_0);
                atl.justUpdateFileTag(inFilePath, outFilePath);
                if (outVersion == 100) break;
            }
            case 100: {
                atl.setSourceVersion(100);
                atl.setTargetVersion(110, VER_STR_1_1_0);
                atl.justUpdateFileTag(inFilePath, outFilePath);
                if (outVersion == 110) break;
            }
            default: {
                throw new UnsupportedVersionException("Either " + inVersion + " or " + outVersion + " are not known.");
            }
        }
    }
}

