/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.model.application.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jwt.meta.model.application.provider.ApplicationItemProvider;
import org.eclipse.jwt.meta.model.application.provider.ApplicationTypeItemProvider;
import org.eclipse.jwt.meta.model.application.provider.WebServiceApplicationItemProvider;
import org.eclipse.jwt.meta.model.application.util.ApplicationAdapterFactory;

public class ApplicationItemProviderAdapterFactory
extends ApplicationAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    public static final String copyright = "Copyright (c) 2005-2011  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected ApplicationItemProvider applicationItemProvider;
    protected ApplicationTypeItemProvider applicationTypeItemProvider;
    protected WebServiceApplicationItemProvider webServiceApplicationItemProvider;

    public ApplicationItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createApplicationAdapter() {
        if (this.applicationItemProvider == null) {
            this.applicationItemProvider = new ApplicationItemProvider((AdapterFactory)this);
        }
        return this.applicationItemProvider;
    }

    public Adapter createApplicationTypeAdapter() {
        if (this.applicationTypeItemProvider == null) {
            this.applicationTypeItemProvider = new ApplicationTypeItemProvider((AdapterFactory)this);
        }
        return this.applicationTypeItemProvider;
    }

    public Adapter createWebServiceApplicationAdapter() {
        if (this.webServiceApplicationItemProvider == null) {
            this.webServiceApplicationItemProvider = new WebServiceApplicationItemProvider((AdapterFactory)this);
        }
        return this.webServiceApplicationItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.applicationItemProvider != null) {
            this.applicationItemProvider.dispose();
        }
        if (this.applicationTypeItemProvider != null) {
            this.applicationTypeItemProvider.dispose();
        }
        if (this.webServiceApplicationItemProvider != null) {
            this.webServiceApplicationItemProvider.dispose();
        }
    }
}

