/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.meta.model.primitiveTypes.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.jwt.meta.model.primitiveTypes.provider.IntegerTypeItemProvider;
import org.eclipse.jwt.meta.model.primitiveTypes.provider.PrimitiveTypeItemProvider;
import org.eclipse.jwt.meta.model.primitiveTypes.provider.StringTypeItemProvider;
import org.eclipse.jwt.meta.model.primitiveTypes.util.PrimitiveTypesAdapterFactory;

public class PrimitiveTypesItemProviderAdapterFactory
extends PrimitiveTypesAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    public static final String copyright = "Copyright (c) 2005-2011  Eclipse Java Workflow Tooling (JWT) Project <www.eclipse.org/jwt>";
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected PrimitiveTypeItemProvider primitiveTypeItemProvider;
    protected StringTypeItemProvider stringTypeItemProvider;
    protected IntegerTypeItemProvider integerTypeItemProvider;

    public PrimitiveTypesItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createPrimitiveTypeAdapter() {
        if (this.primitiveTypeItemProvider == null) {
            this.primitiveTypeItemProvider = new PrimitiveTypeItemProvider((AdapterFactory)this);
        }
        return this.primitiveTypeItemProvider;
    }

    public Adapter createStringTypeAdapter() {
        if (this.stringTypeItemProvider == null) {
            this.stringTypeItemProvider = new StringTypeItemProvider((AdapterFactory)this);
        }
        return this.stringTypeItemProvider;
    }

    public Adapter createIntegerTypeAdapter() {
        if (this.integerTypeItemProvider == null) {
            this.integerTypeItemProvider = new IntegerTypeItemProvider((AdapterFactory)this);
        }
        return this.integerTypeItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.primitiveTypeItemProvider != null) {
            this.primitiveTypeItemProvider.dispose();
        }
        if (this.stringTypeItemProvider != null) {
            this.stringTypeItemProvider.dispose();
        }
        if (this.integerTypeItemProvider != null) {
            this.integerTypeItemProvider.dispose();
        }
    }
}

