/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.base;

import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jwt.transformations.api.TransformationService;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.jwt.transformations.base.init.TransformationRegistry;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public abstract class JWTTransformationRequestDesc {
    private static final String JWT_TRANSFORMATION_BASE_PLUGIN_ID = "org.eclipse.jwt.transformations.baseTransformation";
    protected String outFilePath;
    protected String inFilePath;
    protected String transformationName;
    protected boolean openCreatedFile = false;
    protected Composite parentComposite;
    protected Listener listener;

    public JWTTransformationRequestDesc(Composite parent, Listener listener) {
        this.parentComposite = parent;
        this.listener = listener;
    }

    public JWTTransformationRequestDesc(Composite parent) {
        this(parent, new Listener(){

            public void handleEvent(Event event) {
            }
        });
    }

    public abstract Composite createControl();

    public abstract boolean hasAllRequiredInfo();

    public boolean apply() {
        TransformationService transfo = TransformationRegistry.getInstance().getTransformation(this.getTransformationName());
        boolean cancelled = PlatformUI.getWorkbench().saveAllEditors(true);
        if (!cancelled) {
            return false;
        }
        try {
            File destFile = new File(this.getOutFilePath());
            if (!destFile.exists()) {
                destFile.createNewFile();
            }
            transfo.transform(this.getInFilePath(), this.getOutFilePath());
            if (this.openCreatedFile) {
                IFileStore fileStore = EFS.getLocalFileSystem().getStore(new File(this.getOutFilePath()).toURI());
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)fileStore);
            }
            return true;
        }
        catch (Exception e1) {
            Status status = new Status(4, JWT_TRANSFORMATION_BASE_PLUGIN_ID, e1.getMessage(), (Throwable)e1);
            ErrorDialog.openError((Shell)this.getShell(), (String)TransformationsMessages.transformationError_title, (String)TransformationsMessages.transformationError_details, (IStatus)status);
            return false;
        }
    }

    public Shell getShell() {
        return this.parentComposite.getShell();
    }

    public String getOutFilePath() {
        return this.outFilePath;
    }

    public void setOutFilePath(String outFilePath) {
        this.outFilePath = outFilePath;
    }

    public String getInFilePath() {
        return this.inFilePath;
    }

    public void setInFilePath(String inFilePath) {
        this.inFilePath = inFilePath;
    }

    public String getTransformationName() {
        return this.transformationName;
    }

    public void setTransformationName(String transformationName) {
        this.transformationName = transformationName;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }
}

