/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.base.init;

import java.io.IOException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jwt.transformations.api.TransformationException;
import org.eclipse.jwt.transformations.api.TransformationService;
import org.eclipse.jwt.transformations.base.init.TransformationRegistry;
import org.eclipse.ui.WorkbenchException;

public class ProcessServiceMembers {
    private static final String TRANSFORMATION_NAME_ATTRIBUTE = "name";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String TYPE_ATTRIBUTE = "type";

    public static void process(String EXTENSION_POINT, TransformationRegistry transformationRegistry) throws WorkbenchException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(EXTENSION_POINT);
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        int m = 0;
        while (m < members.length) {
            IConfigurationElement member = members[m];
            String functionName = member.getAttribute(TRANSFORMATION_NAME_ATTRIBUTE);
            TransformationProxy proxy = new TransformationProxy(member);
            proxy.setDescription(member.getAttribute(DESCRIPTION_ATTRIBUTE));
            proxy.setType(member.getAttribute(TYPE_ATTRIBUTE));
            transformationRegistry.addTransformation(functionName, proxy);
            ++m;
        }
    }

    private static class TransformationProxy
    extends TransformationService {
        private TransformationService delegate = null;
        private IConfigurationElement element;
        private boolean invoked = false;

        public TransformationProxy(IConfigurationElement element) {
            this.element = element;
        }

        public final void transform(String inFilePath, String outFilePath) throws IOException, TransformationException {
            try {
                this.getDelegate();
            }
            catch (Exception exception) {
                throw new TransformationException("invalid function");
            }
            if (this.delegate == null) {
                throw new TransformationException("invalid function");
            }
            this.delegate.transform(inFilePath, outFilePath);
        }

        private final TransformationService getDelegate() throws Exception {
            if (this.invoked) {
                return this.delegate;
            }
            this.invoked = true;
            Object callback = this.element.createExecutableExtension(ProcessServiceMembers.CLASS_ATTRIBUTE);
            if (!(callback instanceof TransformationService)) {
                throw new Exception("TransformationService creation error");
            }
            this.delegate = (TransformationService)callback;
            return this.delegate;
        }
    }

    public class Type {
        public static final String EXPORT = "export";
        public static final String IMPORT = "import";
    }
}

