/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.exportTransformations;

import java.io.File;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jwt.transformations.base.JWTTransformationRequestDesc;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.jwt.transformations.base.init.TransformationRegistry;
import org.eclipse.jwt.we.misc.util.GeneralHelper;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ExportJWTTransformationRequestDesc
extends JWTTransformationRequestDesc {
    private boolean canUseCurrentModel;
    private String currentModelInFilePath;

    public ExportJWTTransformationRequestDesc(Composite parent, Listener listener) {
        super(parent, listener);
    }

    public ExportJWTTransformationRequestDesc(Composite parent) {
        super(parent);
    }

    public String getCurrentModelInFilePath() {
        if (this.currentModelInFilePath == null && this.canUseCurrentModel) {
            this.useCurrentModel();
        }
        return this.currentModelInFilePath;
    }

    public void setCurrentModelInFilePath(String currentModelInFilePath) {
        this.currentModelInFilePath = currentModelInFilePath;
    }

    public Composite createControl() {
        Composite composite = new Composite(this.parentComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group inFileGroup = new Group(composite, 0);
        inFileGroup.setText(TransformationsMessages.inputWorkflow);
        inFileGroup.setLayout((Layout)new GridLayout(2, false));
        inFileGroup.setLayoutData((Object)new GridData(1808));
        final Button checkbox = new Button((Composite)inFileGroup, 32);
        checkbox.setSelection(true);
        checkbox.setText(TransformationsMessages.useCurrentJWTModel);
        checkbox.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        final Text inFileText = new Text((Composite)inFileGroup, 2052);
        GridData filegridData = new GridData(768);
        inFileText.setLayoutData((Object)filegridData);
        inFileText.setText("");
        final Button inFileBrowse = new Button((Composite)inFileGroup, 0);
        inFileBrowse.setText(TransformationsMessages.browse);
        final Group transformationGroup = new Group(composite, 0);
        transformationGroup.setText(TransformationsMessages.transformationGroup);
        transformationGroup.setLayout((Layout)new GridLayout(1, false));
        transformationGroup.setLayoutData((Object)new GridData(1808));
        final Combo transformationsCombo = new Combo((Composite)transformationGroup, 8);
        transformationsCombo.setText(TransformationsMessages.chooseExportTransformation);
        transformationsCombo.setLayoutData((Object)new GridData(1808));
        Set<String> transformationsName = TransformationRegistry.getInstance().getTransformationsName();
        for (String trans : transformationsName) {
            if (!"export".equals(TransformationRegistry.getInstance().getTransformation(trans).getTye())) continue;
            transformationsCombo.add(trans);
        }
        final Label descriptionLabel = new Label((Composite)transformationGroup, 16704);
        Group outFileGroup = new Group(composite, 0);
        outFileGroup.setText(TransformationsMessages.outputFileGroup);
        outFileGroup.setLayout((Layout)new GridLayout(2, false));
        outFileGroup.setLayoutData((Object)new GridData(1808));
        final Text outFileText = new Text((Composite)outFileGroup, 2052);
        outFileText.setLayoutData((Object)filegridData);
        Button outFileBrowse = new Button((Composite)outFileGroup, 0);
        outFileBrowse.setText(TransformationsMessages.browse);
        final Button openOutputCheckbox = new Button((Composite)outFileGroup, 32);
        openOutputCheckbox.setSelection(this.openCreatedFile);
        openOutputCheckbox.setText(TransformationsMessages.openCreatedFile);
        openOutputCheckbox.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        outFileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(ExportJWTTransformationRequestDesc.this.getShell(), 8192);
                dialog.setText(TransformationsMessages.selectExportOutputFile);
                dialog.setFilterExtensions(new String[]{"*.*"});
                String path = dialog.open();
                outFileText.setText(path);
                if (ExportJWTTransformationRequestDesc.this.getOutFilePath() != null && ExportJWTTransformationRequestDesc.this.getOutFilePath().length() != 0) {
                    outFileText.setText(ExportJWTTransformationRequestDesc.this.getOutFilePath());
                }
            }
        });
        inFileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(ExportJWTTransformationRequestDesc.this.getShell(), 4096);
                dialog.setText(TransformationsMessages.selectExportInputFile);
                dialog.setFilterExtensions(new String[]{"*.workflow", "*.agilpro", "*.jwt"});
                String path = dialog.open();
                ExportJWTTransformationRequestDesc.this.setInFilePath(path);
                inFileText.setText(ExportJWTTransformationRequestDesc.this.getInFilePath());
            }
        });
        inFileText.addListener(24, new Listener(){

            public void handleEvent(Event event) {
                ExportJWTTransformationRequestDesc.this.setInFilePath(inFileText.getText());
                ExportJWTTransformationRequestDesc.this.listener.handleEvent(event);
            }
        });
        outFileText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                ExportJWTTransformationRequestDesc.this.setOutFilePath(outFileText.getText());
                ExportJWTTransformationRequestDesc.this.listener.handleEvent(e);
            }
        });
        checkbox.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                if (checkbox.getSelection()) {
                    inFileText.setText(ExportJWTTransformationRequestDesc.this.getCurrentModelInFilePath());
                }
                inFileText.setEnabled(!checkbox.getSelection());
                inFileBrowse.setEnabled(!checkbox.getSelection());
            }
        });
        transformationsCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ExportJWTTransformationRequestDesc.this.setTransformationName(transformationsCombo.getText());
                ExportJWTTransformationRequestDesc.this.listener.handleEvent(e);
                descriptionLabel.setText(TransformationRegistry.getInstance().getTransformation(transformationsCombo.getText()).getDescription());
                transformationGroup.layout(true);
                ExportJWTTransformationRequestDesc.this.getShell().update();
            }
        });
        openOutputCheckbox.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ExportJWTTransformationRequestDesc.this.openCreatedFile = openOutputCheckbox.getSelection();
            }
        });
        checkbox.setEnabled(this.canUseCurrentModel);
        checkbox.setSelection(this.canUseCurrentModel);
        if (this.canUseCurrentModel) {
            inFileText.setText(this.getCurrentModelInFilePath());
        } else if (this.getInFilePath() != null) {
            inFileText.setText(this.getInFilePath());
        } else {
            inFileText.setText("");
        }
        inFileText.setEnabled(!this.canUseCurrentModel);
        inFileBrowse.setEnabled(!this.canUseCurrentModel);
        return composite;
    }

    public boolean hasAllRequiredInfo() {
        return this.getInFilePath() != null && this.getInFilePath().length() != 0 && this.isJwtModelFile(this.getInFilePath()) && this.getOutFilePath() != null && this.getOutFilePath().length() != 0 && this.getTransformationName() != null && TransformationRegistry.getInstance().getTransformationsName().contains(this.getTransformationName());
    }

    private boolean isJwtModelFile(String inFilePath2) {
        return new File(inFilePath2).exists() && (inFilePath2.endsWith(".workflow") || inFilePath2.endsWith(".agilpro") || inFilePath2.endsWith(".jwt"));
    }

    public void setToExportItem(String inFilePath) {
        this.setInFilePath(inFilePath);
    }

    public void useCurrentModel() {
        if (!this.canUseCurrentModel) {
            Resource resource = GeneralHelper.getActiveInstance().getCurrentActivitySheet().getActivityModel().eResource();
            this.setCurrentModelInFilePath(CommonPlugin.resolve((URI)resource.getURI()).toFileString());
            this.canUseCurrentModel = true;
        }
    }
}

