/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.transformations.importTransformations;

import java.io.File;
import java.util.Set;
import org.eclipse.jwt.transformations.base.JWTTransformationRequestDesc;
import org.eclipse.jwt.transformations.base.TransformationsMessages;
import org.eclipse.jwt.transformations.base.init.TransformationRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class ImportJWTTransformationRequestDesc
extends JWTTransformationRequestDesc {
    public ImportJWTTransformationRequestDesc(Composite parent, Listener listener) {
        super(parent, listener);
    }

    public ImportJWTTransformationRequestDesc(Composite parent) {
        super(parent);
    }

    public Composite createControl() {
        Composite composite = new Composite(this.parentComposite, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Group inFileGroup = new Group(composite, 0);
        inFileGroup.setText(TransformationsMessages.importInputFileGroup);
        inFileGroup.setLayout((Layout)new GridLayout(2, false));
        inFileGroup.setLayoutData((Object)new GridData(1808));
        final Text inFileText = new Text((Composite)inFileGroup, 2052);
        GridData filegridData = new GridData(768);
        inFileText.setLayoutData((Object)filegridData);
        inFileText.setText("");
        Button inFileBrowse = new Button((Composite)inFileGroup, 0);
        inFileBrowse.setText(TransformationsMessages.browse);
        final Group transformationGroup = new Group(composite, 0);
        transformationGroup.setText(TransformationsMessages.transformationGroup);
        transformationGroup.setLayout((Layout)new GridLayout(1, false));
        transformationGroup.setLayoutData((Object)new GridData(1808));
        final Combo transformationsCombo = new Combo((Composite)transformationGroup, 8);
        transformationsCombo.setText(TransformationsMessages.chooseImportTransformation);
        transformationsCombo.setLayoutData((Object)new GridData(1808));
        Set<String> transformationsName = TransformationRegistry.getInstance().getTransformationsName();
        for (String trans : transformationsName) {
            if (!"import".equals(TransformationRegistry.getInstance().getTransformation(trans).getTye())) continue;
            transformationsCombo.add(trans);
        }
        final Label descriptionLabel = new Label((Composite)transformationGroup, 16704);
        Group outFileGroup = new Group(composite, 0);
        outFileGroup.setText(TransformationsMessages.outputFileGroup);
        outFileGroup.setLayout((Layout)new GridLayout(2, false));
        outFileGroup.setLayoutData((Object)new GridData(1808));
        final Text outFileText = new Text((Composite)outFileGroup, 2052);
        outFileText.setLayoutData((Object)filegridData);
        Button outFileBrowse = new Button((Composite)outFileGroup, 0);
        outFileBrowse.setText(TransformationsMessages.browse);
        final Button checkbox = new Button((Composite)outFileGroup, 32);
        checkbox.setSelection(false);
        checkbox.setText(TransformationsMessages.openCreatedJWTModel);
        checkbox.setLayoutData((Object)new GridData(0, 0, false, false, 2, 1));
        checkbox.setEnabled(true);
        inFileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(ImportJWTTransformationRequestDesc.this.getShell(), 4096);
                dialog.setText(TransformationsMessages.selectImportInputFile);
                dialog.setFilterExtensions(new String[]{"*.*"});
                ImportJWTTransformationRequestDesc.this.inFilePath = dialog.open();
                if (ImportJWTTransformationRequestDesc.this.inFilePath != null && ImportJWTTransformationRequestDesc.this.inFilePath.length() != 0) {
                    inFileText.setText(ImportJWTTransformationRequestDesc.this.inFilePath);
                    ImportJWTTransformationRequestDesc.this.listener.handleEvent(e);
                }
            }
        });
        outFileBrowse.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FileDialog dialog = new FileDialog(ImportJWTTransformationRequestDesc.this.getShell(), 8192);
                dialog.setText(TransformationsMessages.selectImportOutputFile);
                dialog.setFilterExtensions(new String[]{"*.*"});
                outFileText.setText(dialog.open());
                if (ImportJWTTransformationRequestDesc.this.outFilePath != null && ImportJWTTransformationRequestDesc.this.outFilePath.length() != 0) {
                    outFileText.setText(ImportJWTTransformationRequestDesc.this.outFilePath);
                    ImportJWTTransformationRequestDesc.this.listener.handleEvent(e);
                }
            }
        });
        inFileText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                ImportJWTTransformationRequestDesc.this.inFilePath = inFileText.getText();
                ImportJWTTransformationRequestDesc.this.listener.handleEvent(e);
            }
        });
        outFileText.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                ImportJWTTransformationRequestDesc.this.outFilePath = outFileText.getText();
                ImportJWTTransformationRequestDesc.this.listener.handleEvent(e);
            }
        });
        checkbox.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ImportJWTTransformationRequestDesc.this.openCreatedFile = checkbox.getSelection();
            }
        });
        transformationsCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ImportJWTTransformationRequestDesc.this.transformationName = transformationsCombo.getText();
                descriptionLabel.setText(TransformationRegistry.getInstance().getTransformation(transformationsCombo.getText()).getDescription());
                transformationGroup.layout(true);
                ImportJWTTransformationRequestDesc.this.parentComposite.update();
                ImportJWTTransformationRequestDesc.this.listener.handleEvent(e);
            }
        });
        return composite;
    }

    public boolean hasAllRequiredInfo() {
        return this.inFilePath != null && new File(this.inFilePath).exists() && this.transformationName != null && TransformationRegistry.getInstance().getTransformationsName().contains(this.transformationName) && this.outFilePath != null && this.outFilePath.length() != 0;
    }
}

