/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.aspects.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jwt.we.conf.model.Aspect;
import org.eclipse.jwt.we.conf.model.AspectInstance;
import org.eclipse.jwt.we.conf.model.ConfModel;
import org.eclipse.jwt.we.conf.model.Profile;
import org.eclipse.jwt.we.conf.model.aspects.AspectManager;
import org.eclipse.jwt.we.conf.model.aspects.ConfRegistry;
import org.eclipse.jwt.we.conf.model.aspects.factory.AspectFactory;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;
import org.eclipse.jwt.we.conf.model.plugin.internal.EMFUtils;
import org.eclipse.jwt.we.conf.model.plugin.internal.Logger;
import org.eclipse.jwt.we.conf.model.resource.ConfModelResourceManager;
import org.eclipse.jwt.we.conf.model.resource.ConfModelStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AspectManagerImpl
implements AspectManager {
    protected static Logger logger = Logger.getLogger(AspectManagerImpl.class);
    protected static final List<Profile> EMPTY_PROFILE_LIST = new ArrayList<Profile>(0);

    protected AspectManagerImpl() {
    }

    public static AspectManagerImpl createAspectManager() {
        AspectManagerImpl aspectManager = new AspectManagerImpl();
        return aspectManager;
    }

    @Override
    public final EObject getModelRoot(Object element) {
        EObject rootEObject = EMFUtils.getRootEObject(element);
        if (rootEObject instanceof ConfModel) {
            return ((ConfModel)rootEObject).getEnrichedModel();
        }
        return rootEObject;
    }

    @Override
    public ConfModel getConfModel(EObject modelElement) {
        if (modelElement instanceof ConfModel) {
            return (ConfModel)modelElement;
        }
        ConfModelStatus cmStatus = new ConfModelStatus();
        ConfModel confModel = this.getConfModel(modelElement, cmStatus);
        return confModel;
    }

    @Override
    public ConfModel getConfModel(EObject modelElement, ConfModelStatus cmStatus) {
        EObject rootEObject;
        if (!modelElement.eResource().getURI().lastSegment().endsWith(".workflow")) {
            return null;
        }
        if (modelElement == null) {
            // empty if block
        }
        if ((rootEObject = EMFUtils.getRootEObject(modelElement)) instanceof ConfModel) {
            return (ConfModel)rootEObject;
        }
        cmStatus.setCreateIfDoesntExist(true);
        return ConfModelResourceManager.INSTANCE.loadConfModelOfModel(rootEObject, cmStatus);
    }

    @Override
    public boolean isConfModelElement(EObject modelElement) {
        EObject rootEObject = EMFUtils.getRootEObject(modelElement);
        return rootEObject instanceof ConfModel;
    }

    @Override
    public List<Aspect> getAspects(EObject modelElement) {
        if (modelElement == null) {
            return null;
        }
        return this.getAspectsInternal(modelElement);
    }

    protected List<Aspect> getAspectsInternal(EObject modelElement) {
        List<Profile> activatedProfiles = this.getActivatedProfiles(modelElement);
        return this.getAspectsInternal(modelElement, activatedProfiles);
    }

    protected List<Aspect> getAspectsInternal(EObject modelElement, List<Profile> profiles) {
        EClass eclass = modelElement.eClass();
        ArrayList<Aspect> foundAspects = null;
        for (Profile profile : profiles) {
            for (Aspect aspect : profile.getAspects()) {
                for (EClass targetModelElementEClass : aspect.getTargetModelElements()) {
                    if (!eclass.isSuperTypeOf(targetModelElementEClass)) continue;
                    if (foundAspects == null) {
                        foundAspects = new ArrayList(2);
                    }
                    foundAspects.add(aspect);
                }
            }
        }
        if (foundAspects == null) {
            foundAspects = new ArrayList<Aspect>(0);
        }
        return foundAspects;
    }

    @Override
    public List<Profile> getActivatedProfiles(EObject modelElement) {
        if (modelElement == null) {
            return null;
        }
        return this.getActivatedProfilesInternal(modelElement);
    }

    private List<Profile> getActivatedProfilesInternal(EObject modelElement) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel == null) {
            logger.debug("No embedded conf model found for model element " + modelElement + " of model " + this.getModelRoot(modelElement));
            return EMPTY_PROFILE_LIST;
        }
        if (modelConfModel.isCachedNoMissingProfile() || modelConfModel.getUseEmbeddedConf().booleanValue()) {
            return modelConfModel.getProfiles();
        }
        ArrayList<Profile> activatedProfiles = new ArrayList<Profile>();
        for (Profile profileRef : modelConfModel.getProfiles()) {
            String profileId = profileRef.getName();
            Profile profile = ConfRegistry.INSTANCE.getInstalledProfile(profileId);
            if (profile == null) {
                logger.warning("In model " + this.getModelRoot(modelElement) + " of model element " + modelElement + ", no installed profile found for embedded profile reference with id " + profileId + ", using definition emebdded within workflow model.");
                continue;
            }
            activatedProfiles.add(profile);
        }
        if (activatedProfiles.size() == modelConfModel.getProfiles().size()) {
            modelConfModel.setCachedNoMissingProfile(true);
        }
        return activatedProfiles;
    }

    @Override
    public void activateProfile(EObject modelElement, Profile installedProfile) {
        this.activateProfile(modelElement, installedProfile, true);
    }

    @Override
    public void activateProfile(EObject modelElement, Profile profile, boolean executeBehaviours) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel == null) {
            return;
        }
        if (this.getProfile(modelConfModel, profile.getName()) != null) {
            return;
        }
        Profile importedProfile = (Profile)EcoreUtil.copy((EObject)profile);
        modelConfModel.getProfiles().add((Object)importedProfile);
        if (!executeBehaviours) {
            return;
        }
        ArrayList<Profile> importedProfiles = new ArrayList<Profile>(1);
        importedProfiles.add(importedProfile);
        EObject modelRoot = modelConfModel.getEnrichedModel();
        TreeIterator eObjectIt = modelRoot.eAllContents();
        while (eObjectIt.hasNext()) {
            EObject currentModelElement = (EObject)eObjectIt.next();
            List<Aspect> currentModelElementAspects = this.getAspectsInternal(currentModelElement, importedProfiles);
            ConfPlugin.getDefaultAspectEventManager().onCreatedInternal(currentModelElement, currentModelElementAspects);
        }
    }

    @Override
    public void disableProfile(EObject modelElement, Profile installedProfile) {
        this.disableProfile(modelElement, installedProfile, true);
    }

    @Override
    public void disableProfile(EObject modelElement, Profile profile, boolean removeAspectInstances) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel == null) {
            return;
        }
        Profile existingProfile = this.getProfile(modelConfModel, profile.getName());
        if (existingProfile == null) {
            return;
        }
        if (removeAspectInstances) {
            String disabledProfileName = existingProfile.getName();
            ArrayList<AspectInstance> toBeRemovedAspectInstances = new ArrayList<AspectInstance>();
            for (AspectInstance currentAspectInstance : modelConfModel.getAspectInstances()) {
                Aspect currentAspect = this.getAspect(currentAspectInstance);
                Profile currentProfile = (Profile)currentAspect.eContainer();
                if (currentProfile == null || !currentProfile.getName().equals(disabledProfileName)) continue;
                toBeRemovedAspectInstances.add(currentAspectInstance);
            }
            for (AspectInstance toBeRemovedAspectInstance : toBeRemovedAspectInstances) {
                modelConfModel.getAspectInstances().remove((Object)toBeRemovedAspectInstance);
            }
        }
        modelConfModel.getProfiles().remove((Object)existingProfile);
    }

    public Profile getProfile(ConfModel modelConfModel, String profileName) {
        for (Profile embeddedProfile : modelConfModel.getProfiles()) {
            if (!profileName.equals(embeddedProfile.getName())) continue;
            return embeddedProfile;
        }
        return null;
    }

    @Override
    public boolean useEmbeddedConf(EObject modelElement) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel == null) {
            return false;
        }
        return modelConfModel.getUseEmbeddedConf();
    }

    @Override
    public Aspect getAspect(AspectInstance aspectInstance) {
        EObject aspectInstanceContainer = aspectInstance.eContainer();
        if (aspectInstanceContainer == null) {
            return null;
        }
        return this.getAspect(aspectInstanceContainer, aspectInstance.getId());
    }

    @Override
    public Aspect getAspect(EObject modelElement, String aspectId) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel.isCachedNoMissingProfile() || !modelConfModel.getUseEmbeddedConf().booleanValue()) {
            return ConfRegistry.INSTANCE.getInstalledAspect(aspectId);
        }
        List<Profile> activatedProfiles = this.getActivatedProfiles(modelElement);
        if (activatedProfiles == null) {
            logger.debug("No model found for " + modelElement);
            return null;
        }
        for (Profile profile : activatedProfiles) {
            for (Aspect aspect : profile.getAspects()) {
                if (!aspect.getId().equals(aspectId)) continue;
                return aspect;
            }
        }
        return null;
    }

    @Override
    public List<Profile> getMissingInstalledProfiles(EObject modelElement) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel == null) {
            logger.debug("No embedded conf model found for model " + this.getModelRoot(modelElement) + " of model element " + modelElement);
            return EMPTY_PROFILE_LIST;
        }
        ArrayList<Profile> missingProfiles = new ArrayList<Profile>();
        for (Profile profileRef : modelConfModel.getProfiles()) {
            String profileId = profileRef.getName();
            Profile profile = ConfRegistry.INSTANCE.getInstalledProfile(profileId);
            if (profile != null) continue;
            missingProfiles.add(profileRef);
        }
        return missingProfiles;
    }

    @Override
    public List<AspectInstance> getAspectInstances(EObject modelElement) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        if (modelConfModel == null) {
            logger.debug("No embedded conf model found for model " + this.getModelRoot(modelElement) + " of model element " + modelElement);
            return new ArrayList<AspectInstance>(0);
        }
        ArrayList<AspectInstance> aspectInstances = new ArrayList<AspectInstance>();
        for (AspectInstance aspectInstance : modelConfModel.getAspectInstances()) {
            if (!modelElement.equals(aspectInstance.getTargetModelElement())) continue;
            aspectInstances.add(aspectInstance);
        }
        return aspectInstances;
    }

    @Override
    public AspectInstance getAspectInstance(EObject modelElement, Aspect aspect) {
        ConfModel modelConfModel = this.getConfModel(modelElement);
        for (AspectInstance aspectInstance : modelConfModel.getAspectInstances()) {
            if (!modelElement.equals(aspectInstance.getTargetModelElement()) || !aspectInstance.getId().equals(aspect.getId())) continue;
            return aspectInstance;
        }
        return null;
    }

    @Override
    public AspectInstance createAndAddAspectInstance(Aspect aspect, EObject modelElement) {
        AspectInstance newAspectInstance = AspectFactory.INSTANCE.createAspectInstance(aspect, modelElement);
        if (newAspectInstance == null) {
            logger.warning("Error creating aspects of element " + modelElement + ": error creating aspect " + aspect.getId());
            return null;
        }
        this.addAspectInstance(newAspectInstance, modelElement);
        return newAspectInstance;
    }

    protected void addAspectInstance(AspectInstance newAspectInstance, EObject modelElement) {
        this.getConfModel(modelElement).getAspectInstances().add((Object)newAspectInstance);
    }
}

