/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.conf.model.resource.internal;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ExtensibleURIConverterImpl;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.ClassNotFoundException;
import org.eclipse.emf.ecore.xmi.PackageNotFoundException;
import org.eclipse.jwt.we.conf.model.ConfFactory;
import org.eclipse.jwt.we.conf.model.ConfModel;
import org.eclipse.jwt.we.conf.model.Profile;
import org.eclipse.jwt.we.conf.model.aspects.event.AspectEventManager;
import org.eclipse.jwt.we.conf.model.plugin.ConfPlugin;
import org.eclipse.jwt.we.conf.model.plugin.internal.EMFUtils;
import org.eclipse.jwt.we.conf.model.plugin.internal.Logger;
import org.eclipse.jwt.we.conf.model.resource.ConfModelResourceManager;
import org.eclipse.jwt.we.conf.model.resource.ConfModelStatus;
import org.eclipse.jwt.we.conf.model.resource.ConfResourceException;
import org.eclipse.jwt.we.conf.model.resource.internal.ConfModelAvailabilityManager;
import org.eclipse.jwt.we.conf.model.resource.internal.ConfModelPatchingContext;
import org.eclipse.jwt.we.conf.model.resource.internal.ConfModelSavingModelResourceAdapter;
import org.eclipse.jwt.we.conf.model.resource.internal.EMFResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfModelResourceManagerImpl
implements ConfModelResourceManager {
    protected static Logger logger = Logger.getLogger(ConfModelResourceManagerImpl.class);
    protected static final HashMap<String, String> CONFMODEL_SAVE_OPTIONS = new HashMap<String, String>(){
        {
            this.put("ENCODING", "UTF-8");
        }
    };
    protected static final URIConverter uriConverter = new ExtensibleURIConverterImpl();
    protected final ConfModelAvailabilityManager confModelAvailabilityManager = new ConfModelAvailabilityManager();

    protected ConfModelResourceManagerImpl() {
    }

    public static ConfModelResourceManager createConfModelResourceManager() {
        return new ConfModelResourceManagerImpl();
    }

    public ConfModelAvailabilityManager getConfModelAvailabilityManager() {
        return this.confModelAvailabilityManager;
    }

    @Override
    public ConfModel exportProfilesToFile(Collection<Profile> profiles, File f) throws Exception {
        return this.exportProfilesToFile(profiles, f);
    }

    @Override
    public ConfModel exportProfiles(Collection<Profile> profiles, File f) throws ConfResourceException, IOException {
        ConfModel exportConfModel = ConfFactory.eINSTANCE.createConfModel();
        Collection exportedProfiles = EcoreUtil.copyAll(profiles);
        exportConfModel.getProfiles().addAll(exportedProfiles);
        ResourceSetImpl confResourceSet = new ResourceSetImpl();
        URI confModelUri = URI.createFileURI((String)f.getAbsolutePath());
        Resource confModelResource = confResourceSet.createResource(confModelUri);
        confModelResource.getContents().add((Object)exportConfModel);
        try {
            confModelResource.save(CONFMODEL_SAVE_OPTIONS);
        }
        catch (RuntimeException ex) {
            String msg = "Error saving confModel " + confModelUri + " after updating it to target the right external resource " + confModelUri;
            ConfPlugin.logger.warning(msg, ex);
            throw new ConfResourceException(msg, ex);
        }
        return exportConfModel;
    }

    @Override
    public ConfModel loadConfModelOfModel(EObject modelRoot, boolean createIfDoesntExist) throws ConfResourceException {
        ConfModelStatus cmStatus = new ConfModelStatus();
        cmStatus.setCreateIfDoesntExist(createIfDoesntExist);
        ConfModel confModel = this.loadConfModelOfModel(modelRoot, cmStatus);
        if (cmStatus.getSeverity() == 4) {
            IStatus[] iStatusArray = cmStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                if (childStatus.getSeverity() == 4) {
                    throw new ConfResourceException(childStatus.getMessage(), childStatus.getException());
                }
                ++n2;
            }
            throw new ConfResourceException("Unknown error loading conf model");
        }
        return confModel;
    }

    @Override
    public ConfModel loadConfModelOfModel(EObject modelRoot, ConfModelStatus cmStatus) {
        if (modelRoot == null) {
            return null;
        }
        Resource modelResource = modelRoot.eResource();
        if (modelResource == null) {
            return null;
        }
        URI modelUri = modelResource.getURI();
        if (modelUri == null) {
            return null;
        }
        ResourceSet modelResourceSet = modelResource.getResourceSet();
        URI confModelUri = this.buildConfModelUriForModel(modelUri);
        if (cmStatus.isCreateIfDoesntExist()) {
            this.confModelAvailabilityManager.unflagUnavailability(modelRoot, confModelUri);
        }
        ConfModelStatus tryGettingExistingOneFirstStatus = new ConfModelStatus(cmStatus);
        tryGettingExistingOneFirstStatus.setTryGettingExistingOneFirst(true);
        ConfModel confModel = this.loadConfModel(confModelUri, modelResourceSet, modelRoot, tryGettingExistingOneFirstStatus);
        if (!cmStatus.isCreateIfDoesntExist()) {
            String unavailableMsg;
            if (tryGettingExistingOneFirstStatus.getSeverity() == 4) {
                cmStatus.addAll((IStatus)tryGettingExistingOneFirstStatus);
                return null;
            }
            if (confModel == null && !cmStatus.isBypassFlaggedUnavailable() && (unavailableMsg = this.confModelAvailabilityManager.flaggedUnavailable(modelRoot, confModelUri)) != null) {
                cmStatus.add((IStatus)new Status(4, "org.eclipse.jwt.we.conf.model", 101, "ConfModel resource unavailable: " + unavailableMsg, null));
                return null;
            }
        }
        if (confModel == null) {
            if (cmStatus.isCreateIfDoesntExist()) {
                try {
                    confModel = this.createConfModel(confModelUri, modelResourceSet, modelRoot);
                }
                catch (ConfResourceException crex) {
                    cmStatus.add((IStatus)new Status(4, "org.eclipse.jwt.we.conf.model", 504, crex.getMessage(), (Throwable)crex));
                    return null;
                }
                this.confModelAvailabilityManager.unflagUnavailability(modelRoot, confModelUri);
            }
        } else {
            EObject confModelEnrichedModel = confModel.getEnrichedModel();
            if (confModelEnrichedModel == null) {
                String msg = "Found ConfModel at " + confModelUri + " but has no enriched model set" + " while looking for expected ConfModel of model " + modelUri;
                logger.debug(msg);
                if (cmStatus.isDontTryPatchingNoEnrichedModelReference()) {
                    cmStatus.add((IStatus)new Status(4, "org.eclipse.jwt.we.conf.model", 403, msg, null));
                    return null;
                }
                cmStatus.add((IStatus)new Status(1, "org.eclipse.jwt.we.conf.model", 403, msg, null));
                confModel.setEnrichedModel(modelRoot);
            } else {
                URI confModelEnrichedModelResourceURI = EMFUtils.getResourceOrProxyURI(confModelEnrichedModel);
                if (confModelEnrichedModelResourceURI != null && !confModelEnrichedModelResourceURI.equals((Object)modelUri)) {
                    String msg = "Found ConfModel at " + confModelUri + " but already refers to another enriched model at " + confModelEnrichedModelResourceURI + " while looking for expected ConfModel of model " + modelUri;
                    if (cmStatus.isDontTryPatchingReferencesAnotherEnrichedModel()) {
                        logger.severe(msg);
                        cmStatus.add((IStatus)new Status(4, "org.eclipse.jwt.we.conf.model", 404, msg, null));
                    }
                    logger.warning(msg);
                    cmStatus.add((IStatus)new Status(2, "org.eclipse.jwt.we.conf.model", 404, msg, null));
                    try {
                        confModel = this.migrateConfModelToModel(confModel, confModelEnrichedModelResourceURI, modelUri, modelRoot);
                    }
                    catch (ConfResourceException e) {
                        cmStatus.add((IStatus)new Status(4, "org.eclipse.jwt.we.conf.model", 505, e.getMessage(), (Throwable)e));
                        return null;
                    }
                }
            }
        }
        return confModel;
    }

    protected URI buildConfModelUriForModel(URI modelUri) {
        String confModelFragment = modelUri.fragment();
        String[] confModelSegments = modelUri.segments();
        if (confModelFragment != null && confModelFragment.length() != 0) {
            confModelFragment = String.valueOf(confModelFragment) + "_conf";
        } else {
            confModelSegments[confModelSegments.length - 1] = String.valueOf(modelUri.lastSegment()) + "_conf";
        }
        return URI.createHierarchicalURI((String)modelUri.scheme(), (String)modelUri.authority(), (String)modelUri.device(), (String[])confModelSegments, (String)modelUri.query(), (String)confModelFragment);
    }

    @Override
    public ConfModel createConfModel(URI confModelUri, ResourceSet modelResourceSet, EObject modelRoot) throws ConfResourceException {
        if (modelResourceSet == null) {
            modelResourceSet = modelRoot != null ? modelRoot.eResource().getResourceSet() : new ResourceSetImpl();
        }
        ConfModel confModel = ConfFactory.eINSTANCE.createConfModel();
        Resource confModelResource = null;
        try {
            confModelResource = modelResourceSet.createResource(confModelUri);
        }
        catch (RuntimeException ex) {
            String msg = "Error creating ConfModel in new file " + confModelUri + (modelRoot != null ? " while looking for expected ConfModel of model " + modelRoot.eResource().getURI() : "");
            logger.severe(msg, ex);
            EMFResourceUtils.cleanBadlyLoadedResource(modelResourceSet, confModelUri);
            throw new ConfResourceException(msg, ex);
        }
        confModelResource.getContents().add((Object)confModel);
        if (modelRoot != null) {
            confModel.setEnrichedModel(modelRoot);
            Resource modelResource = modelRoot.eResource();
            modelResource.eAdapters().add((Object)new ConfModelSavingModelResourceAdapter(confModelResource, modelResource.getURI()));
        }
        try {
            confModelResource.save(CONFMODEL_SAVE_OPTIONS);
        }
        catch (Exception ex) {
            String msg = "Error saving ConfModel " + confModelUri + " after patching it with the right enrichedModel" + (modelRoot != null ? " while looking for expected ConfModel of model " + modelRoot.eResource().getURI() : "");
            logger.warning(msg, ex);
            throw new ConfResourceException(msg, ex);
        }
        return confModel;
    }

    @Override
    public ConfModel loadConfModel(URI confModelUri, ResourceSet modelResourceSet, EObject modelRoot, boolean tryGettingExistingOneFirst) throws ConfResourceException {
        ConfModelStatus cmStatus = new ConfModelStatus();
        cmStatus.setTryGettingExistingOneFirst(tryGettingExistingOneFirst);
        ConfModel confModel = this.loadConfModel(confModelUri, modelResourceSet, modelRoot, cmStatus);
        if (cmStatus.getSeverity() == 4) {
            IStatus[] iStatusArray = cmStatus.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus childStatus = iStatusArray[n2];
                if (childStatus.getSeverity() == 4) {
                    throw new ConfResourceException(childStatus.getMessage(), childStatus.getException());
                }
                ++n2;
            }
            throw new ConfResourceException("Unknown error loading conf model at " + confModelUri);
        }
        return confModel;
    }

    @Override
    public ConfModel loadConfModel(URI confModelUri, ResourceSet modelResourceSet, EObject modelRoot, ConfModelStatus cmStatus) {
        ConfModel confModel;
        String msg;
        Resource confModelResource;
        block18: {
            block17: {
                if (modelResourceSet == null) {
                    modelResourceSet = modelRoot != null ? modelRoot.eResource().getResourceSet() : new ResourceSetImpl();
                }
                confModelResource = null;
                if (cmStatus.isTryGettingExistingOneFirst()) {
                    try {
                        confModelResource = modelResourceSet.getResource(confModelUri, false);
                        if (confModelResource != null) {
                            return this.getConfModelFromConfModelResource(confModelResource);
                        }
                    }
                    catch (RuntimeException ex) {
                        msg = "Error trying to get already loaded ConfModel from file " + confModelUri + (modelRoot != null ? " while looking for expected ConfModel of model " + modelRoot.eResource().getURI() : "");
                        logger.log(Level.INFO, msg, ex);
                        cmStatus.add((IStatus)new Status(1, "org.eclipse.jwt.we.conf.model", 101, msg, (Throwable)ex));
                        EMFResourceUtils.cleanBadlyLoadedResource(modelResourceSet, confModelUri);
                        confModelResource = null;
                    }
                }
                if (this.confModelAvailabilityManager.flaggedUnavailable(modelRoot, confModelUri) == null) break block17;
                if (cmStatus.isBypassFlaggedUnavailable()) {
                    this.confModelAvailabilityManager.unflagUnavailability(modelRoot, confModelUri);
                    break block17;
                }
                return null;
            }
            boolean resourceExists = uriConverter.exists(confModelUri, CONFMODEL_SAVE_OPTIONS);
            if (resourceExists) break block18;
            msg = "ConfModel resource doesn't exist";
            this.handleResourceLoadingError(modelRoot, null, confModelUri, cmStatus, 401, msg, null);
            return null;
        }
        try {
            confModelResource = modelResourceSet.getResource(confModelUri, true);
            if (confModelResource == null) {
                msg = "ConfModel resource can't be loaded";
                this.handleResourceLoadingError(modelRoot, null, confModelUri, cmStatus, 501, msg, null);
                return null;
            }
        }
        catch (RuntimeException rex) {
            String msg2;
            Throwable actualException;
            Throwable throwable = actualException = rex instanceof WrappedException ? rex.getCause() : rex;
            if (!(actualException instanceof PackageNotFoundException) && !(actualException instanceof ClassNotFoundException)) {
                msg2 = "Error loading ConfModel";
                this.handleResourceLoadingError(modelRoot, (ResourceSet)modelResourceSet, confModelUri, cmStatus, 502, msg2, actualException);
            }
            if (!cmStatus.isTryPatchingMissingEmf()) {
                msg2 = "Patchable (but won't try to patch) error loading conf model resource";
                this.handleResourceLoadingError(modelRoot, (ResourceSet)modelResourceSet, confModelUri, cmStatus, 402, msg2, actualException);
                return null;
            }
            ConfModelPatchingContext confModelPatcher = new ConfModelPatchingContext(confModelUri, (ResourceSet)modelResourceSet);
            try {
                confModelPatcher.auditConfModel();
                confModelPatcher.patchConfModel();
                confModelResource = modelResourceSet.getResource(confModelUri, true);
                String msg3 = "Patched ConfModel file " + confModelUri + " by removing unknown profiles " + confModelPatcher.getNokProfileNameSet() + " and associated aspect instances. A backup has been made." + " Have a look at your plugin configuration." + (modelRoot != null ? " While looking for expected ConfModel of model " + modelRoot.eResource().getURI() : "");
                logger.severe(msg3);
                cmStatus.add((IStatus)new Status(1, "org.eclipse.jwt.we.conf.model", 201, msg3, null));
            }
            catch (ConfResourceException crex) {
                String msg4 = "Error patching and reloading ConfModel";
                this.handleResourceLoadingError(modelRoot, (ResourceSet)modelResourceSet, confModelUri, cmStatus, 503, msg4, crex);
                return null;
            }
        }
        if ((confModel = this.getConfModelFromConfModelResource(confModelResource)) != null && modelRoot != null) {
            Resource modelResource = modelRoot.eResource();
            for (Adapter resourceAdapter : new ArrayList(modelResource.eAdapters())) {
                if (!resourceAdapter.isAdapterForType(ConfModelResourceManager.class)) continue;
                modelResource.eAdapters().remove((Object)resourceAdapter);
            }
            modelResource.eAdapters().add((Object)new ConfModelSavingModelResourceAdapter(confModelResource, modelResource.getURI()));
            modelRoot.eAdapters().add((Object)new AspectEventManager());
        }
        return confModel;
    }

    private void handleResourceLoadingError(EObject modelRoot, ResourceSet modelResourceSet, URI confModelUri, ConfModelStatus cmStatus, int code, String msg, Throwable ex) {
        String errMsg = String.valueOf(msg) + " for ConfModel file " + confModelUri + (modelRoot != null ? " while looking for expected ConfModel of model " + modelRoot.eResource().getURI() : "");
        this.confModelAvailabilityManager.flagUnavailable(modelRoot, confModelUri, msg);
        if (modelResourceSet != null) {
            EMFResourceUtils.cleanBadlyLoadedResource(modelResourceSet, confModelUri);
        }
        logger.log(Level.SEVERE, errMsg, ex);
        cmStatus.add((IStatus)new Status(4, "org.eclipse.jwt.we.conf.model", code, errMsg, ex));
    }

    private ConfModel getConfModelFromConfModelResource(Resource confModelResource) {
        if (confModelResource == null) {
            return null;
        }
        EList confModelResourceContents = confModelResource.getContents();
        if (confModelResourceContents == null || confModelResourceContents.isEmpty()) {
            return null;
        }
        EObject confModelObject = (EObject)confModelResourceContents.get(0);
        if (confModelObject instanceof ConfModel) {
            return (ConfModel)confModelObject;
        }
        return null;
    }

    @Override
    public ConfModel migrateConfModelToModel(ConfModel confModel, URI oldModelURI, URI newModelURI, EObject modelRoot) throws ConfResourceException {
        EMFResourceUtils.updateModelExternalResourceUri(confModel, oldModelURI, newModelURI);
        URI confModelUri = confModel.eResource().getURI();
        try {
            confModel.eResource().save(CONFMODEL_SAVE_OPTIONS);
        }
        catch (Exception ex) {
            String msg = "Error saving confModel " + confModelUri + " after updating it to target the right external resource " + newModelURI;
            ConfPlugin.logger.warning(msg, ex);
            throw new ConfResourceException(msg, ex);
        }
        this.cleanModelResourceSetFromConfModel(confModelUri, oldModelURI, newModelURI, modelRoot);
        return this.loadConfModel(confModelUri, null, modelRoot, true);
    }

    protected void cleanModelResourceSetFromConfModel(URI confModelUri, URI oldModelURI, URI newModelURI, EObject modelRoot) {
        Resource modelResource = modelRoot.eResource();
        ResourceSet modelResourceSet = modelResource.getResourceSet();
        EMFResourceUtils.removeResourceFromResourceSet(confModelUri, modelResourceSet);
        EMFResourceUtils.removeResourceFromResourceSet(oldModelURI, modelResourceSet);
        for (Resource resource : new ArrayList(modelResourceSet.getResources())) {
            if (!newModelURI.equals((Object)resource.getURI()) || modelResource == resource) continue;
            if (resource.isLoaded()) {
                resource.unload();
            }
            modelResourceSet.getResources().remove((Object)resource);
        }
    }

    @Override
    public boolean deleteConfModel(ConfModel confModel) {
        return EMFResourceUtils.deleteEMFResource(confModel);
    }
}

