/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we;

import org.eclipse.gef.EditPartFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jwt.we.IFactoryRegistry;
import org.eclipse.jwt.we.Plugin;
import org.eclipse.jwt.we.editors.palette.IPaletteFactory;
import org.eclipse.jwt.we.editors.palette.internal.PaletteFactory;
import org.eclipse.jwt.we.figures.IFigureFactory;
import org.eclipse.jwt.we.figures.IImageFactory;
import org.eclipse.jwt.we.figures.StandardFigureFactory;
import org.eclipse.jwt.we.figures.internal.ImageFactory;
import org.eclipse.jwt.we.misc.logging.Logger;
import org.eclipse.jwt.we.parts.JWTEditPartFactory;

public class DefaultFactoryRegistry
implements IFactoryRegistry {
    protected IImageFactory imageFactory;
    protected IFigureFactory figureFactory;
    protected EditPartFactory editPartFactory;
    protected PaletteFactory paletteFactory;
    private static final Logger logger = Logger.getLogger(DefaultFactoryRegistry.class);

    public IImageFactory getImageFactory(Object ... objects) {
        IImageFactory imageFactory = this.getImageFactory();
        if (imageFactory == null) {
            ImageRegistry imageRegistry = Plugin.getInstance().getImageRegistry();
            this.imageFactory = imageFactory = new ImageFactory(imageRegistry, Plugin.getDefault(), "icons/");
        }
        return imageFactory;
    }

    public IImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public IPaletteFactory getPaletteFactory() {
        if (this.paletteFactory == null) {
            this.paletteFactory = new PaletteFactory();
        }
        return this.paletteFactory;
    }

    public IFigureFactory getFigureFactory() {
        if (this.figureFactory == null) {
            this.figureFactory = new StandardFigureFactory();
        }
        return this.figureFactory;
    }

    public EditPartFactory getEditPartFactory() {
        if (this.editPartFactory == null) {
            this.editPartFactory = new JWTEditPartFactory();
        }
        return this.editPartFactory;
    }
}

