/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.core;

import java.util.Collection;
import java.util.HashSet;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.DeleteCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.core.Package;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.misc.util.EMFHelper;
import org.eclipse.jwt.we.misc.views.LayoutDataManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WERemovePackageSubpackagesCommand
extends RemoveCommand {
    private WEEditor weeditor;
    private EditingDomain editingDomain;
    private Command removeViewDataCommand;

    public WERemovePackageSubpackagesCommand(WEEditor weeditor, EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, owner, feature, collection);
        this.editingDomain = domain;
        this.weeditor = weeditor;
    }

    public void doExecute() {
        HashSet<Scope> containedScopes = new HashSet<Scope>();
        for (Package pack : this.collection) {
            TreeIterator iterator2 = pack.eAllContents();
            while (iterator2.hasNext()) {
                EObject content = (EObject)iterator2.next();
                if (!(content instanceof Scope)) continue;
                containedScopes.add((Scope)content);
                TreeIterator iterator3 = ((Scope)content).eAllContents();
                while (iterator3.hasNext()) {
                    Object object = iterator3.next();
                    if (!(object instanceof Scope)) continue;
                    containedScopes.add((Scope)object);
                }
            }
        }
        HashSet removeViewDataSet = new HashSet();
        Collection refEdgesCollection = EMFHelper.getAllContainedReferenceEdges(this.weeditor, containedScopes);
        Collection refsCollection = EMFHelper.getAllContainedReferences(this.weeditor, containedScopes);
        Collection laydataCollection = LayoutDataManager.getAllContainedLayoutDatas(this.weeditor, containedScopes);
        if (refEdgesCollection != null) {
            removeViewDataSet.addAll(refEdgesCollection);
        }
        if (refsCollection != null) {
            removeViewDataSet.addAll(refsCollection);
        }
        if (laydataCollection != null) {
            removeViewDataSet.addAll(laydataCollection);
        }
        this.removeViewDataCommand = DeleteCommand.create((EditingDomain)this.editingDomain, removeViewDataSet);
        if (this.removeViewDataCommand.canExecute()) {
            this.removeViewDataCommand.execute();
        }
        this.doExecuteOriginal();
    }

    protected void doExecuteOriginal() {
        super.doExecute();
    }

    public void doRedo() {
        if (this.removeViewDataCommand.canExecute()) {
            this.removeViewDataCommand.redo();
        }
        super.doRedo();
    }

    public void doUndo() {
        super.doUndo();
        if (this.removeViewDataCommand.canUndo()) {
            this.removeViewDataCommand.undo();
        }
    }

    public void doDispose() {
        super.doDispose();
        if (this.removeViewDataCommand != null) {
            this.removeViewDataCommand.dispose();
        }
    }
}

