/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.commands.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jwt.meta.model.application.Application;
import org.eclipse.jwt.meta.model.core.ReferenceableElement;
import org.eclipse.jwt.meta.model.data.Data;
import org.eclipse.jwt.meta.model.organisations.Role;
import org.eclipse.jwt.meta.model.processes.Action;
import org.eclipse.jwt.meta.model.processes.ProcessesPackage;
import org.eclipse.jwt.meta.model.processes.Scope;
import org.eclipse.jwt.we.model.view.Diagram;
import org.eclipse.jwt.we.model.view.Reference;
import org.eclipse.jwt.we.model.view.ReferenceEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveReferenceEdgeCommand
extends RemoveCommand {
    private EditingDomain editingDomain;
    private CompoundCommand removeFeatureCommands;
    private Map<ReferenceEdge, Scope> scopeMap;
    private Map<ReferenceEdge, Action> actionMap;
    private Map<ReferenceEdge, Reference> referenceMap;
    private Map<ReferenceEdge, Diagram> diagramMap;

    public RemoveReferenceEdgeCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        super(domain, owner, feature, collection);
        this.editingDomain = domain;
    }

    protected EStructuralFeature[] getReferenceFeature(ReferenceEdge edge) {
        if (edge.getReference() == null) {
            return null;
        }
        ReferenceableElement element = edge.getReference().getReference();
        if (element instanceof Application) {
            return new EStructuralFeature[]{ProcessesPackage.Literals.ACTION__EXECUTED_BY};
        }
        if (element instanceof Role) {
            return new EStructuralFeature[]{ProcessesPackage.Literals.ACTION__PERFORMED_BY};
        }
        if (element instanceof Data) {
            boolean input = false;
            if (edge.getAction().getInputs() != null) {
                input = edge.getAction().getInputs().contains((Object)element);
            }
            boolean output = false;
            if (edge.getAction().getOutputs() != null) {
                output = edge.getAction().getOutputs().contains((Object)element);
            }
            if (input && output) {
                return new EStructuralFeature[]{ProcessesPackage.Literals.ACTION__INPUTS, ProcessesPackage.Literals.ACTION__OUTPUTS};
            }
            if (input) {
                return new EStructuralFeature[]{ProcessesPackage.Literals.ACTION__INPUTS};
            }
            if (output) {
                return new EStructuralFeature[]{ProcessesPackage.Literals.ACTION__OUTPUTS};
            }
            return new EStructuralFeature[0];
        }
        return null;
    }

    public void doExecute() {
        ArrayList<ReferenceEdge> newCollection = new ArrayList<ReferenceEdge>();
        for (ReferenceEdge refEdge : this.collection) {
            if (refEdge.eContainer() == null) continue;
            newCollection.add(refEdge);
        }
        this.collection = newCollection;
        this.removeFeatureCommands = new CompoundCommand();
        for (ReferenceEdge edge : this.collection) {
            EStructuralFeature[] features = this.getReferenceFeature(edge);
            if (features == null) continue;
            EStructuralFeature[] eStructuralFeatureArray = features;
            int n = features.length;
            int n2 = 0;
            while (n2 < n) {
                EStructuralFeature feature = eStructuralFeatureArray[n2];
                if (feature.isMany()) {
                    this.removeFeatureCommands.append((Command)new RemoveCommand(this.editingDomain, (EObject)edge.getAction(), feature, (Object)edge.getReference().getReference()));
                } else {
                    this.removeFeatureCommands.append((Command)new SetCommand(this.editingDomain, (EObject)edge.getAction(), feature, null));
                }
                ++n2;
            }
        }
        if (this.removeFeatureCommands.canExecute()) {
            this.removeFeatureCommands.execute();
        }
        this.scopeMap = new HashMap<ReferenceEdge, Scope>();
        this.actionMap = new HashMap<ReferenceEdge, Action>();
        this.referenceMap = new HashMap<ReferenceEdge, Reference>();
        this.diagramMap = new HashMap<ReferenceEdge, Diagram>();
        for (ReferenceEdge refEdge : this.collection) {
            if (refEdge.eContainer() != null) {
                this.diagramMap.put(refEdge, (Diagram)refEdge.eContainer());
                ((Diagram)refEdge.eContainer()).getReferenceEdges().remove((Object)refEdge);
            }
            if (refEdge.getContainedIn() != null) {
                this.scopeMap.put(refEdge, refEdge.getContainedIn());
                refEdge.setContainedIn(null);
            }
            if (refEdge.getAction() != null) {
                this.actionMap.put(refEdge, refEdge.getAction());
                refEdge.setAction(null);
            }
            if (refEdge.getReference() == null) continue;
            this.referenceMap.put(refEdge, refEdge.getReference());
            refEdge.setReference(null);
        }
    }

    public void doRedo() {
        if (this.removeFeatureCommands.canExecute()) {
            this.removeFeatureCommands.redo();
        }
        for (ReferenceEdge refEdge : this.collection) {
            if ((Diagram)refEdge.eContainer() != null) {
                ((Diagram)refEdge.eContainer()).getReferenceEdges().remove((Object)refEdge);
            }
            refEdge.setContainedIn(null);
            refEdge.setAction(null);
            refEdge.setReference(null);
        }
    }

    public void doUndo() {
        for (Map.Entry<ReferenceEdge, Scope> entry : this.scopeMap.entrySet()) {
            entry.getKey().setContainedIn(entry.getValue());
            entry.getKey().setAction(this.actionMap.get(entry.getKey()));
            entry.getKey().setReference(this.referenceMap.get(entry.getKey()));
            this.diagramMap.get(entry.getKey()).getReferenceEdges().add((Object)entry.getKey());
        }
        if (!this.removeFeatureCommands.isEmpty()) {
            this.removeFeatureCommands.undo();
        }
    }
}

