/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.figures;

import org.eclipse.draw2d.IFigure;
import org.eclipse.jwt.we.figures.IFigureFactory;
import org.eclipse.jwt.we.misc.logging.Logger;

public class StandardFigureFactory
implements IFigureFactory {
    private static final Logger logger = Logger.getLogger(StandardFigureFactory.class);
    private static final String MODEL_ROOT_PACKAGE = "org.eclipse.jwt.we.model";
    private static final String MODEL_EXTERNAL_ROOT_PACKAGE = "org.eclipse.jwt.meta.model";
    private static final String FIGURE_ROOT_PACKAGE = StandardFigureFactory.class.getPackage().getName();
    private static final String FIGURE_POSTFIX = "Figure";

    public IFigure createFigure(Class modelType) {
        IFigure figure = null;
        String target = modelType.getName();
        if (target.startsWith(MODEL_EXTERNAL_ROOT_PACKAGE)) {
            target = target.replace(MODEL_EXTERNAL_ROOT_PACKAGE, MODEL_ROOT_PACKAGE);
        }
        if (!target.startsWith(MODEL_ROOT_PACKAGE)) {
            return null;
        }
        String figureClass = String.valueOf(FIGURE_ROOT_PACKAGE) + target.substring(MODEL_ROOT_PACKAGE.length()) + FIGURE_POSTFIX;
        try {
            figure = (IFigure)Class.forName(figureClass).newInstance();
        }
        catch (Exception exception) {
            logger.debug("Can't find figure class for " + modelType);
            return null;
        }
        return figure;
    }
}

