/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.misc.util;

import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Control;

public class SaveImage {
    public static boolean save(GraphicalViewer viewer, String saveFilePath, int format) {
        if (format != 0 && format != 4 && format != 5) {
            throw new IllegalArgumentException("Save format not supported");
        }
        try {
            SaveImage.saveEditorContentsAsImage(viewer, saveFilePath, format);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void saveEditorContentsAsImage(GraphicalViewer viewer, String saveFilePath, int format) {
        ScalableFreeformRootEditPart rootEditPart = (ScalableFreeformRootEditPart)viewer.getRootEditPart();
        FreeformFigure rootFigure = (FreeformFigure)rootEditPart.getLayer((Object)"Printable Layers");
        Rectangle rootFigureBounds = rootFigure.getFreeformExtent();
        Control figureCanvas = viewer.getControl();
        GC figureCanvasGC = new GC((Drawable)figureCanvas);
        Image img = new Image(null, rootFigureBounds.width, rootFigureBounds.height);
        GC imageGC = new GC((Drawable)img);
        imageGC.setBackground(figureCanvasGC.getBackground());
        imageGC.setForeground(figureCanvasGC.getForeground());
        imageGC.setFont(figureCanvasGC.getFont());
        imageGC.setLineStyle(figureCanvasGC.getLineStyle());
        imageGC.setLineWidth(figureCanvasGC.getLineWidth());
        SWTGraphics imgGraphics = new SWTGraphics(imageGC);
        imgGraphics.translate(rootFigureBounds.getLocation().negate());
        rootFigure.paint((Graphics)imgGraphics);
        ImageData[] imgData = new ImageData[]{img.getImageData()};
        ImageLoader imgLoader = new ImageLoader();
        imgLoader.data = imgData;
        imgLoader.save(saveFilePath, format);
        figureCanvasGC.dispose();
        imageGC.dispose();
        img.dispose();
    }
}

