/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.facet;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.libra.facet.OSGiBundleFacetUtils;
import org.eclipse.libra.facet.internal.LibraFacetPlugin;
import org.eclipse.pde.core.project.IBundleProjectDescription;
import org.eclipse.pde.core.project.IBundleProjectService;
import org.eclipse.pde.core.project.IPackageImportDescription;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;

public class OSGiBundleFacetEventHandler
implements IDelegate {
    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        if ("jpt.jpa".equals(fv.getProjectFacet().getId()) && OSGiBundleFacetUtils.isOSGiBundle(project)) {
            IPackageImportDescription imp2;
            IBundleProjectService bundleProjectService = LibraFacetPlugin.getDefault().getBundleProjectService();
            IBundleProjectDescription bundleProjectDescription = bundleProjectService.getDescription(project);
            String metaPersistenceHeader = bundleProjectDescription.getHeader("Meta-Persistence");
            if (metaPersistenceHeader == null) {
                metaPersistenceHeader = "";
            }
            bundleProjectDescription.setHeader("Meta-Persistence", metaPersistenceHeader);
            ArrayList<IPackageImportDescription> imports = new ArrayList<IPackageImportDescription>();
            imports.addAll(Arrays.asList(bundleProjectDescription.getPackageImports()));
            for (IPackageImportDescription imp2 : imports) {
                if (!"javax.persistence;jpa=\"%s\"".equals(imp2.getName())) continue;
                imports.remove(imp2);
                break;
            }
            imp2 = bundleProjectService.newPackageImport(String.format("javax.persistence;jpa=\"%s\"", fv.getVersionString()), null, false);
            imports.add(imp2);
            IPackageImportDescription[] newImports = imports.toArray(new IPackageImportDescription[imports.size()]);
            bundleProjectDescription.setPackageImports(newImports);
            bundleProjectDescription.apply(monitor);
        }
    }
}

