/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.parts.IFormEntryListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralInfoSection
extends PDESection {
    private FormEntry idEntry;
    private FormEntry nameEntry;
    private FormEntry versionEntry;
    private static int NUM_COLUMNS = 3;

    public GeneralInfoSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    protected void createClient(Section section, FormToolkit toolkit) {
        section.setText(PDEUIMessages.GeneralInfoSection_title);
        section.setDescription(PDEUIMessages.GeneralInfoSection_desc);
        TableWrapLayout wrapLayout = FormLayoutFactory.createClearTableWrapLayout((boolean)false, (int)1);
        section.setLayout((Layout)wrapLayout);
        TableWrapData data = new TableWrapData(256);
        data.colspan = 2;
        section.setLayoutData((Object)data);
        Composite client = toolkit.createComposite((Composite)section);
        GridLayout gridLayout = FormLayoutFactory.createSectionClientGridLayout((boolean)false, (int)NUM_COLUMNS);
        client.setLayout((Layout)gridLayout);
        IEditorSite site = this.getPage().getPDEEditor().getEditorSite();
        IActionBars actionBars = site.getActionBars();
        this.createIdEntry(client, toolkit, actionBars);
        this.createVersionEntry(client, toolkit, actionBars);
        this.createNameEntry(client, toolkit, actionBars);
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    private void createNameEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.nameEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_productname, null, false);
        this.nameEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this, actionBars){

            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getProduct().setName(entry.getValue().trim());
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.nameEntry.getText().setLayoutData((Object)gd);
        this.nameEntry.setEditable(this.isEditable());
    }

    private void createIdEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.idEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_id, null, false);
        this.idEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this, actionBars){

            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getProduct().setId(entry.getValue().trim());
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.idEntry.getText().setLayoutData((Object)gd);
        this.idEntry.setEditable(this.isEditable());
    }

    private void createVersionEntry(Composite client, FormToolkit toolkit, IActionBars actionBars) {
        this.versionEntry = new FormEntry(client, toolkit, PDEUIMessages.ProductInfoSection_version, null, false);
        this.versionEntry.setFormEntryListener((IFormEntryListener)new FormEntryAdapter((IContextPart)this, actionBars){

            public void textValueChanged(FormEntry entry) {
                GeneralInfoSection.this.getProduct().setVersion(entry.getValue().trim());
            }
        });
        GridData gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.versionEntry.getText().setLayoutData((Object)gd);
        this.versionEntry.setEditable(this.isEditable());
    }

    public void commit(boolean onSave) {
        this.idEntry.commit();
        this.nameEntry.commit();
        this.versionEntry.commit();
        super.commit(onSave);
    }

    public void cancelEdit() {
        this.idEntry.cancelEdit();
        this.nameEntry.cancelEdit();
        this.versionEntry.cancelEdit();
        super.cancelEdit();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    public void refresh() {
        IProduct product = this.getProduct();
        if (product.getId() != null) {
            this.idEntry.setValue(product.getId(), true);
        }
        if (product.getName() != null) {
            this.nameEntry.setValue(product.getName(), true);
        }
        if (product.getVersion() != null) {
            this.versionEntry.setValue(product.getVersion(), true);
        }
        super.refresh();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        } else {
            String prop = e.getChangedProperty();
            Object[] objects = e.getChangedObjects();
            if (prop != null && objects != null && objects[0] instanceof IProduct) {
                if (prop.equals("uid")) {
                    this.idEntry.setValue(e.getNewValue().toString(), true);
                } else if (prop.equals("name")) {
                    this.nameEntry.setValue(e.getNewValue().toString(), true);
                } else if (prop.equals("version")) {
                    this.versionEntry.setValue(e.getNewValue().toString(), true);
                }
            }
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
        this.getPage().setLastFocusControl((Control)this.idEntry.getText());
    }

    public boolean canPaste(Clipboard clipboard) {
        boolean result = false;
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        if (c instanceof Text) {
            result = true;
        }
        return result;
    }
}

