/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.exportwizard;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.libra.warproducts.core.IWARProduct;
import org.eclipse.libra.warproducts.core.WARProductExportOperation;
import org.eclipse.libra.warproducts.core.WARWorkspaceProductModel;
import org.eclipse.libra.warproducts.ui.Messages;
import org.eclipse.libra.warproducts.ui.exportwizard.ExportPage;
import org.eclipse.libra.warproducts.ui.exportwizard.SelectionPage;
import org.eclipse.libra.warproducts.ui.exportwizard.ValidationPage;
import org.eclipse.libra.warproducts.ui.validation.IValidationListener;
import org.eclipse.libra.warproducts.ui.validation.WARProductValidateAction;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.AbstractExportWizardPage;
import org.eclipse.pde.internal.ui.wizards.exports.ProductExportWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.IProgressConstants;
import org.osgi.framework.Version;

public class ExportWARProductWizard
extends ProductExportWizard {
    private IWARProduct product;
    private IFile warProductFile;
    private ExportPage exportPage;
    private SelectionPage selectionPage;
    private ValidationPage validationPage;
    private boolean isProductValid;

    public ExportWARProductWizard() {
        this(null);
    }

    public ExportWARProductWizard(IProject project) {
        super(project);
    }

    public void addPages() {
        this.selectionPage = new SelectionPage();
        this.validationPage = new ValidationPage();
        this.exportPage = new ExportPage();
        this.loadProductFromSelection(this.getSelection());
        if (this.product == null) {
            this.addPage((IWizardPage)this.selectionPage);
            this.addPage((IWizardPage)this.validationPage);
        } else if (!this.isProductValid) {
            this.addPage((IWizardPage)this.validationPage);
        }
        this.addPage((IWizardPage)this.exportPage);
    }

    public boolean canFinish() {
        boolean result = false;
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        if (currentPage != null && currentPage.equals((Object)this.exportPage) && this.exportPage.isPageComplete() && this.product != null) {
            result = true;
        }
        return result;
    }

    private void loadProductFromFile() {
        WARWorkspaceProductModel productModel = new WARWorkspaceProductModel(this.warProductFile, false);
        try {
            productModel.load();
            if (!productModel.isLoaded()) {
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)PDEUIMessages.ProductExportWizard_corrupt);
            } else {
                this.product = (IWARProduct)productModel.getProduct();
                this.validateProduct();
            }
        }
        catch (CoreException coreException) {
            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)PDEUIMessages.ProductExportWizard_error, (String)PDEUIMessages.ProductExportWizard_corrupt);
        }
    }

    private void validateProduct() {
        WARProductValidateAction action = new WARProductValidateAction(this.product);
        action.addValidationListener(new IValidationListener(){

            public void validationFinished(Map errors) {
                ExportWARProductWizard.this.validationPage.setInput(errors);
                ExportWARProductWizard.this.isProductValid = errors.size() == 0;
            }
        });
        action.run();
    }

    protected boolean confirmDelete() {
        File zipFile;
        boolean result = true;
        if (!this.exportPage.doExportToDirectory() && (zipFile = new File(this.exportPage.getDestination(), this.exportPage.getFileName())).exists()) {
            String bind = NLS.bind((String)PDEUIMessages.BaseExportWizard_confirmReplace_desc, (Object)zipFile.getAbsolutePath());
            String confirmReplaceTitle = PDEUIMessages.BaseExportWizard_confirmReplace_title;
            boolean openQuestion = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)confirmReplaceTitle, (String)bind);
            if (!openQuestion) {
                result = false;
            } else {
                zipFile.delete();
            }
        }
        return result;
    }

    protected void scheduleExportJob() {
        FeatureExportInfo info = new FeatureExportInfo();
        info.toDirectory = this.exportPage.doExportToDirectory();
        info.exportSource = false;
        info.exportSourceBundle = false;
        info.allowBinaryCycles = false;
        info.exportMetadata = false;
        info.destinationDirectory = this.exportPage.getDestination();
        info.zipFileName = this.exportPage.getFileName();
        info.items = this.getPluginModels();
        String rootDirectory = "WEB-INF";
        WARProductExportOperation job = new WARProductExportOperation(info, PDEUIMessages.ProductExportJob_name, (IProduct)this.product, rootDirectory);
        job.setUser(true);
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.schedule();
        job.setProperty(IProgressConstants.ICON_PROPERTY, (Object)PDEPluginImages.DESC_FEATURE_OBJ);
    }

    private BundleDescription[] getPluginModels() {
        ArrayList<BundleDescription> list = new ArrayList<BundleDescription>();
        State state = TargetPlatformHelper.getState();
        IProductPlugin[] plugins = this.product.getPlugins();
        int i = 0;
        while (i < plugins.length) {
            BundleDescription bundle = null;
            String v = plugins[i].getVersion();
            if (v != null && v.length() > 0) {
                bundle = state.getBundle(plugins[i].getId(), Version.parseVersion((String)v));
            }
            if (bundle == null) {
                bundle = state.getBundle(plugins[i].getId(), null);
            }
            if (bundle != null) {
                list.add(bundle);
            }
            ++i;
        }
        BundleDescription[] bundleArray = list.toArray(new BundleDescription[list.size()]);
        return bundleArray;
    }

    public void loadProductFromFile(IFile file) {
        this.warProductFile = file;
        this.loadProductFromFile();
    }

    void resetProduct() {
        this.warProductFile = null;
    }

    protected void initialize(IStructuredSelection selection) {
        if (selection.size() > 0) {
            this.loadProductFromSelection(selection);
        }
    }

    private void loadProductFromSelection(IStructuredSelection selection) {
        Object object = selection.getFirstElement();
        if (object instanceof IFile) {
            this.handleFileSelection(object);
        } else if (object instanceof IContainer) {
            this.handleContainerSelection(object);
        }
    }

    private void handleFileSelection(Object object) {
        IFile file = (IFile)object;
        boolean isWarProduct = "warproduct".equals(file.getFileExtension());
        if (isWarProduct) {
            this.loadProductFromFile(file);
        }
    }

    private void handleContainerSelection(Object object) {
        IContainer container = (IContainer)object;
        try {
            if (container.isAccessible()) {
                IResource[] resources = container.members();
                int i = 0;
                while (i < resources.length) {
                    IResource resource = resources[i];
                    String resourceName = resource.getName();
                    boolean hasWarProductExtension = resourceName.endsWith(".warproduct");
                    if (resource instanceof IFile && hasWarProductExtension) {
                        IFile file = (IFile)resource;
                        this.loadProductFromFile(file);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException e) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LoadWARProductError, (String)e.getMessage());
        }
    }

    public IFile getProductFile() {
        return this.warProductFile;
    }

    protected boolean performPreliminaryChecks() {
        return this.product != null;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractExportWizardPage nextPage = null;
        if (page.equals((Object)this.selectionPage)) {
            nextPage = this.isProductValid ? this.exportPage : this.validationPage;
        } else if (page.equals((Object)this.validationPage)) {
            nextPage = this.exportPage;
        }
        return nextPage;
    }
}

