/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.callgraph.graphlisteners;

import org.eclipse.linuxtools.callgraph.StapGraph;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;

public class StapGraphMouseMoveListener
implements MouseMoveListener {
    private StapGraph graph;
    private int prevX;
    private int prevY;
    private static final int INIT = -20000;
    private boolean stop;
    private boolean showMessage;

    public StapGraphMouseMoveListener(StapGraph graph) {
        this.graph = graph;
        this.prevX = -20000;
        this.prevY = -20000;
        this.showMessage = true;
    }

    public void setPoint(int x, int y) {
        this.prevX = x;
        this.prevY = y;
    }

    public void setStop(boolean val) {
        this.stop = val;
    }

    public void mouseMove(MouseEvent e) {
        if (this.graph.getDrawMode() == 2) {
            if (this.showMessage) {
                this.showMessage = false;
            }
            return;
        }
        if (this.prevX == -20000 && this.prevY == -20000) {
            this.prevX = e.x;
            this.prevY = e.y;
            return;
        }
        if (!this.stop) {
            int xDiff = this.prevX - e.x;
            int yDiff = this.prevY - e.y;
            if (this.graph.scale > 1.0) {
                this.graph.scrollSmoothBy((int)((double)xDiff / this.graph.scale), (int)((double)yDiff / this.graph.scale));
            } else {
                this.graph.scrollSmoothBy(xDiff, yDiff);
            }
            this.prevX = e.x;
            this.prevY = e.y;
        }
    }
}

