/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.dataviewers.charts.viewer;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.dataviewers.charts.Activator;
import org.eclipse.linuxtools.dataviewers.charts.actions.ChartActionRenderer;
import org.eclipse.linuxtools.dataviewers.charts.provider.ChartUpdateNotifier;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class ChartViewer
implements PaintListener,
ControlListener {
    private transient Canvas preview = null;
    private Chart cm = null;
    private transient boolean bIsPainting = false;
    private transient Image buffer;
    private static int X_OFFSET = 3;
    private static int Y_OFFSET = 3;
    private GeneratedChartState gcs = null;
    private IDeviceRenderer deviceRenderer = null;
    private Bounds bo;

    public ChartViewer() {
        try {
            this.deviceRenderer = PluginSettings.instance().getDevice("dv.SWT");
        }
        catch (ChartException e) {
            Status s = new Status(4, "org.eclipse.linuxtools.dataviewers.charts", 4, e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)s);
        }
    }

    public void renderModel(Chart cm) {
        this.cm = cm;
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
    }

    public Bounds getBounds() {
        return this.bo;
    }

    public Chart getChart() {
        return this.cm;
    }

    private void updateBuffer() {
        if (this.bIsPainting) {
            return;
        }
        Exception paintError = null;
        Rectangle re = this.preview.getClientArea();
        Rectangle adjustedRe = new Rectangle(0, 0, re.width, re.height);
        if (adjustedRe.width - 2 * X_OFFSET <= 0 || adjustedRe.height - 2 * Y_OFFSET <= 0) {
            if (this.buffer != null && !this.buffer.isDisposed()) {
                this.buffer.dispose();
                this.buffer = null;
            }
            return;
        }
        if (this.cm == null) {
            this.buffer = null;
        } else {
            this.bIsPainting = true;
            Image oldBuffer = null;
            if (this.buffer == null) {
                this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
            } else {
                Rectangle ore = this.buffer.getBounds();
                oldBuffer = this.buffer;
                if (!adjustedRe.equals((Object)ore)) {
                    this.buffer = new Image((Device)Display.getDefault(), adjustedRe);
                }
            }
            GC gc = new GC((Drawable)this.buffer);
            gc.setForeground(Display.getDefault().getSystemColor(1));
            gc.fillRectangle(this.buffer.getBounds());
            this.bo = BoundsImpl.create((double)X_OFFSET, (double)Y_OFFSET, (double)(adjustedRe.width - 2 * X_OFFSET), (double)(adjustedRe.height - 2 * Y_OFFSET));
            try {
                this.deviceRenderer.setProperty("device.output.context", (Object)gc);
                this.bo.scale(72.0 / (double)this.deviceRenderer.getDisplayServer().getDpiResolution());
                Generator gr = Generator.instance();
                this.gcs = gr.build(this.deviceRenderer.getDisplayServer(), this.cm, this.bo, null, null, null);
                this.gcs.getRunTimeContext().setActionRenderer((IActionRenderer)new ChartActionRenderer());
                this.deviceRenderer.setProperty("device.component", (Object)new ChartUpdateNotifier(this.preview, this.cm, this.gcs.getChartModel()));
                gr.render(this.deviceRenderer, this.gcs);
            }
            catch (Exception ex) {
                paintError = ex;
            }
            if (paintError != null) {
                this.buffer = oldBuffer;
            }
            if (oldBuffer != null && oldBuffer != this.buffer) {
                oldBuffer.dispose();
            }
            this.bIsPainting = false;
        }
    }

    public void paintControl(PaintEvent pe) {
        GC gc = pe.gc;
        if (this.buffer != null) {
            gc.drawImage(this.buffer, 0, 0);
        }
    }

    public void setViewer(Canvas paintCanvas) {
        this.preview = paintCanvas;
    }

    public void controlMoved(ControlEvent e) {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
    }

    public void controlResized(ControlEvent e) {
        if (this.preview != null && !this.preview.isDisposed()) {
            this.updateBuffer();
            this.preview.redraw();
        }
    }

    public void setBuffer(Image buffer) {
        this.buffer = buffer;
    }
}

