/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.consolelog.structures;

import org.eclipse.linuxtools.systemtap.ui.consolelog.internal.ConsoleLogPlugin;
import org.eclipse.linuxtools.systemtap.ui.editor.SimpleEditor;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class ErrorTableDisplay {
    private final MouseListener mouseListener = new MouseListener(){

        public void mouseDown(MouseEvent me) {
        }

        public void mouseUp(MouseEvent me) {
        }

        public void mouseDoubleClick(MouseEvent me) {
            try {
                String location = ErrorTableDisplay.this.table.getSelection()[0].getText(4);
                if (location.length() > 0) {
                    int line = 0;
                    if (location.indexOf(58) > 0) {
                        String[] pos = location.split(":");
                        line = Integer.parseInt(pos[0]);
                    } else {
                        line = Integer.parseInt(location);
                    }
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IEditorPart ed = page.getActiveEditor();
                    if (ed instanceof SimpleEditor) {
                        SimpleEditor editor = (SimpleEditor)ed;
                        editor.selectLine(line);
                        editor.setFocus();
                    }
                }
            }
            catch (Exception exception) {}
        }
    };
    private Table table;
    private String[] titles;
    private TableItem item;

    public ErrorTableDisplay(Composite parent, String[] titles) {
        this.titles = titles;
        this.createControl(parent);
    }

    public void createControl(Composite parent) {
        this.table = new Table(parent, 4);
        this.table.setHeaderVisible(true);
        this.table.getVerticalBar().setVisible(true);
        this.table.setLinesVisible(true);
        this.table.addMouseListener(this.mouseListener);
        int i = 0;
        while (i < this.titles.length) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setText(this.titles[i]);
            ++i;
        }
        this.updateColumns();
    }

    public void clear() {
        this.table.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    ErrorTableDisplay.this.table.removeAll();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    public void addRow(String[] row) {
        this.addRow(row, ConsoleLogPlugin.getImageDescriptor("icons/views/error_st_obj.gif").createImage());
    }

    public void addRow(final String[] row, final Image img) {
        this.table.getDisplay().syncExec(new Runnable(){
            boolean stop = false;

            public void run() {
                if (this.stop) {
                    return;
                }
                try {
                    ErrorTableDisplay.this.item = new TableItem(ErrorTableDisplay.this.table, 0);
                    int i = 0;
                    while (i < row.length) {
                        ErrorTableDisplay.this.item.setText(i + 1, row[i]);
                        ++i;
                    }
                    ErrorTableDisplay.this.item.setImage(img);
                    ErrorTableDisplay.this.updateColumns();
                }
                catch (Exception exception) {
                    this.stop = true;
                }
            }
        });
    }

    private void updateColumns() {
        TableColumn[] columns = this.table.getColumns();
        int i = 0;
        while (i < columns.length) {
            columns[i].pack();
            columns[i].setMoveable(true);
            ++i;
        }
    }

    public Control getControl() {
        return this.table;
    }

    public void dispose() {
        if (this.table != null && !this.table.isDisposed()) {
            this.table.removeMouseListener(this.mouseListener);
            this.table.dispose();
            this.table = null;
        }
        if (this.titles != null) {
            int i = 0;
            while (i < this.titles.length) {
                this.titles[i] = null;
                ++i;
            }
        }
        this.titles = null;
        if (this.item != null) {
            this.item.dispose();
        }
        this.item = null;
    }
}

