/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.systemtap.ui.graphing.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingConstants;
import org.eclipse.linuxtools.systemtap.ui.graphing.GraphingPerspective;
import org.eclipse.linuxtools.systemtap.ui.graphing.internal.Localization;
import org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataEntry;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSet;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.nonui.datasets.IDataSetParser;
import org.eclipse.linuxtools.systemtap.ui.graphingapi.ui.wizards.dataset.DataSetWizard;
import org.eclipse.linuxtools.systemtap.ui.logging.LogManager;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;

public class OpenScriptOutputAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private IWorkbenchWindow fWindow;
    private IDataSet dataSet;
    private IDataSetParser parser;

    public void init(IWorkbenchWindow window) {
        LogManager.logDebug((String)"Start OpenScriptOutputAction.init", (Object)((Object)this));
        LogManager.logDebug((String)"Initializing", (Object)((Object)this));
        this.fWindow = window;
        LogManager.logDebug((String)"End OpenScriptOutputAction.init", (Object)((Object)this));
    }

    public void run(IAction act) {
        LogManager.logDebug((String)"Start OpenScriptOutputAction.run", (Object)((Object)this));
        File f = this.queryFile();
        if (f != null) {
            if (!f.exists()) {
                this.displayError(Localization.getString("OpenScriptOutputAction.SelectedFileDNE"));
            } else if (!f.canRead()) {
                this.displayError(Localization.getString("OpenScriptOutputAction.SelectedFileCanNotRead"));
            } else {
                StringBuilder sb = new StringBuilder();
                this.readFile(f, sb);
                if (this.getChartingOptions(f.getAbsolutePath())) {
                    IDataEntry output;
                    while ((output = this.parser.parse(sb)) != null) {
                        this.dataSet.setData(output);
                    }
                    try {
                        IWorkbenchPage p = PlatformUI.getWorkbench().showPerspective(GraphingPerspective.ID, PlatformUI.getWorkbench().getActiveWorkbenchWindow());
                        IViewPart ivp = p.findView("org.eclipse.linuxtools.systemtap.ui.graphing.views.GraphSelectorView");
                        ((GraphSelectorView)ivp).createScriptSet(f.getName(), this.dataSet);
                    }
                    catch (WorkbenchException we) {
                        LogManager.logCritical((String)("WorkbenchException OpenScriptOutputAction.run:" + we.getMessage()), (Object)((Object)this));
                    }
                }
            }
        }
        LogManager.logDebug((String)"End OpenScriptOutputAction.run", (Object)((Object)this));
    }

    private File queryFile() {
        LogManager.logDebug((String)"Start queryFile:", (Object)((Object)this));
        FileDialog dialog = new FileDialog(this.fWindow.getShell(), 4096);
        dialog.setText(Localization.getString("OpenScriptOutputAction.OpenFile"));
        String path = dialog.open();
        if (path != null && path.length() > 0) {
            LogManager.logDebug((String)("queryFile: returnVal-" + path), (Object)((Object)this));
            return new File(path);
        }
        LogManager.logDebug((String)"queryFile: returnVal-null", (Object)((Object)this));
        return null;
    }

    private void displayError(String message) {
        LogManager.logDebug((String)"Start OpenScriptOutputAction.displayError", (Object)((Object)this));
        LogManager.logInfo((String)"Initializing", MessageDialog.class);
        MessageDialog.openWarning((Shell)this.fWindow.getShell(), (String)Localization.getString("OpenScriptOutputAction.Problem"), (String)message);
        LogManager.logInfo((String)"Disposing", MessageDialog.class);
        LogManager.logDebug((String)"End OpenScriptOutputAction.displayError", (Object)((Object)this));
    }

    private void readFile(File f, StringBuilder sb) {
        LogManager.logDebug((String)"Start ImportDataSetAction.readData", (Object)((Object)this));
        try {
            String line;
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
            LogManager.logCritical((String)("FileNotFoundException ImportDataSetAction.readData:" + fnfe.getMessage()), (Object)((Object)this));
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            LogManager.logCritical((String)("IOException ImportDataSetAction.readData:" + ioe.getMessage()), (Object)((Object)this));
        }
        LogManager.logDebug((String)"End ImportDataSetAction.readData", (Object)((Object)this));
    }

    protected boolean getChartingOptions(String filePath) {
        DataSetWizard wizard = new DataSetWizard(GraphingConstants.DataSetMetaData, filePath);
        IWorkbench workbench = PlatformUI.getWorkbench();
        wizard.init(workbench, null);
        WizardDialog dialog = new WizardDialog(workbench.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.open();
        this.parser = wizard.getParser();
        this.dataSet = wizard.getDataSet();
        wizard.dispose();
        return this.parser != null && this.dataSet != null;
    }

    public void selectionChanged(IAction a, ISelection s) {
    }

    public void dispose() {
        LogManager.logDebug((String)"Start OpenScriptOutputAction.dispose", (Object)((Object)this));
        LogManager.logInfo((String)"Disposing", (Object)((Object)this));
        this.fWindow = null;
        this.parser = null;
        LogManager.logDebug((String)"End OpenScriptOutputAction.dispose", (Object)((Object)this));
    }
}

