/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.project.handlers;

import java.io.FileNotFoundException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.experiment.TmfExperiment;
import org.eclipse.linuxtools.tmf.signal.TmfExperimentSelectedSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignal;
import org.eclipse.linuxtools.tmf.signal.TmfSignalManager;
import org.eclipse.linuxtools.tmf.trace.ITmfTrace;
import org.eclipse.linuxtools.tmf.ui.editors.TmfEditorInput;
import org.eclipse.linuxtools.tmf.ui.project.handlers.Messages;
import org.eclipse.linuxtools.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class OpenTraceHandler
extends AbstractHandler {
    private TmfTraceElement fTrace = null;

    public boolean isEnabled() {
        TreeSelection sel;
        Object element;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return false;
        }
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IWorkbenchPart part = page.getActivePart();
        ISelectionProvider selectionProvider = part.getSite().getSelectionProvider();
        if (selectionProvider == null) {
            return false;
        }
        ISelection selection = selectionProvider.getSelection();
        this.fTrace = null;
        if (selection instanceof TreeSelection && (element = (sel = (TreeSelection)selection).getFirstElement()) instanceof TmfTraceElement) {
            this.fTrace = (TmfTraceElement)element;
        }
        return this.fTrace != null;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        block11: {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (window == null) {
                return null;
            }
            if (this.fTrace == null) {
                return null;
            }
            TmfEvent traceEvent = this.fTrace.instantiateEvent();
            ITmfTrace<?> trace = this.fTrace.instantiateTrace();
            if (trace == null) {
                this.displayErrorMsg(Messages.OpenTraceHandler_NoTraceType);
                return null;
            }
            String editorId = this.fTrace.getEditorId();
            boolean usesEditor = editorId != null && editorId.length() > 0;
            try {
                trace.initTrace(this.fTrace.getLocation().getPath(), traceEvent.getClass(), usesEditor);
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.displayErrorMsg(Messages.OpenTraceHandler_NoTrace);
                return null;
            }
            if (usesEditor) {
                try {
                    IResource resource = this.fTrace.getResource();
                    TmfEditorInput editorInput = new TmfEditorInput(resource, trace);
                    IWorkbench wb = PlatformUI.getWorkbench();
                    IWorkbenchPage activePage = wb.getActiveWorkbenchWindow().getActivePage();
                    IEditorPart editor = activePage.findEditor((IEditorInput)editorInput);
                    if (editor != null && editor instanceof IReusableEditor) {
                        activePage.reuseEditor((IReusableEditor)editor, (IEditorInput)editorInput);
                        activePage.activate((IWorkbenchPart)editor);
                        break block11;
                    }
                    editor = activePage.openEditor((IEditorInput)editorInput, editorId);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            } else {
                TmfExperiment currentExperiment = TmfExperiment.getCurrentExperiment();
                if (currentExperiment != null) {
                    currentExperiment.dispose();
                }
                ITmfTrace[] traces = new ITmfTrace[]{trace};
                TmfExperiment experiment = new TmfExperiment(traceEvent.getClass(), this.fTrace.getName(), traces, trace.getCacheSize());
                TmfExperiment.setCurrentExperiment((TmfExperiment)experiment);
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfExperimentSelectedSignal((Object)this, experiment));
            }
        }
        return null;
    }

    private void displayErrorMsg(String errorMsg) {
        MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        mb.setText(Messages.OpenTraceHandler_Title);
        mb.setMessage(errorMsg);
        mb.open();
    }
}

