/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.TmfTimeAnalysisProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.ITmfTimeAnalysisEntry;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.model.TimeEvent;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.GroupItem;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.ITimeDataProvider;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.Item;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.ItemData;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.PlainSelection;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TraceColorScheme;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TraceCtrl;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.TraceItem;
import org.eclipse.linuxtools.tmf.ui.viewers.timeAnalysis.widgets.Utils;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class TmfTimeStatesCtrl
extends TraceCtrl
implements FocusListener,
KeyListener,
MouseMoveListener,
MouseListener,
MouseWheelListener,
ControlListener,
SelectionListener,
MouseTrackListener,
TraverseListener,
ISelectionProvider {
    private static final int DRAG_NONE = 0;
    private static final int DRAG_TRACE_ITEM = 1;
    private static final int DRAG_GROUP_ITEM = 2;
    private static final int DRAG_SPLIT_LINE = 3;
    public static final boolean DEFAULT_DRAW_THREAD_JOIN = true;
    public static final boolean DEFAULT_DRAW_THREAD_WAIT = true;
    public static final boolean DEFAULT_DRAW_THREAD_RELEASE = true;
    public static int H_SCROLLBAR_MAX = 0x7FFFFFFE;
    private final double zoomCoeff = 1.5;
    private ITimeDataProvider _timeProvider;
    private boolean _isInFocus = false;
    private boolean _isDragCursor3 = false;
    private boolean _isWaitCursor = true;
    private boolean _mouseHover = false;
    private int _itemHeightDefault;
    private int _itemHeight = this._itemHeightDefault = 19;
    private int _minimumItemWidth = 0;
    private int _topItem = 0;
    private int _dragState = 0;
    private int _hitIdx = 0;
    private int _dragX0 = 0;
    private int _dragX = 0;
    private int _idealNameWidth = 0;
    private long _time0bak;
    private long _time1bak;
    private TmfTimeAnalysisProvider utilImpl = null;
    private ItemData _data = null;
    private List<SelectionListener> _selectionListeners;
    private List<ISelectionChangedListener> _selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private Rectangle _rect0 = new Rectangle(0, 0, 0, 0);
    private Rectangle _rect1 = new Rectangle(0, 0, 0, 0);
    private Cursor _dragCursor3;
    private Cursor _WaitCursor;
    private boolean drawTracesInteraction = false;
    private boolean drawTraceJoins = true;
    private boolean drawTraceWaits = true;
    private boolean drawTraceReleases = true;
    private boolean _visibleVerticalScroll = true;
    private int _borderWidth = 0;
    private int _headerHeight = 0;
    private Listener mouseScrollFilterListener;

    public TmfTimeStatesCtrl(Composite parent, TraceColorScheme colors, TmfTimeAnalysisProvider rutilImp) {
        super(parent, colors, 537133824);
        this.utilImpl = rutilImp;
        this._data = new ItemData(this.utilImpl);
        this.addFocusListener(this);
        this.addMouseListener(this);
        this.addMouseMoveListener(this);
        this.addMouseTrackListener(this);
        this.addMouseWheelListener(this);
        this.addTraverseListener(this);
        this.addKeyListener(this);
        this.addControlListener(this);
        ScrollBar scrollVer = this.getVerticalBar();
        ScrollBar scrollHor = this.getHorizontalBar();
        if (scrollVer != null) {
            scrollVer.addSelectionListener((SelectionListener)this);
            scrollVer.setVisible(this._visibleVerticalScroll);
        }
        if (scrollHor != null) {
            scrollHor.addSelectionListener((SelectionListener)this);
        }
        this._dragCursor3 = new Cursor((Device)super.getDisplay(), 9);
        this._WaitCursor = new Cursor((Device)super.getDisplay(), 1);
    }

    @Override
    public void dispose() {
        super.dispose();
        this._dragCursor3.dispose();
        this._WaitCursor.dispose();
    }

    public void setTimeProvider(ITimeDataProvider timeProvider) {
        this._timeProvider = timeProvider;
        this.adjustScrolls();
        this.redraw();
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            SWT.error((int)4);
        }
        if (this._selectionListeners == null) {
            this._selectionListeners = new ArrayList<SelectionListener>();
        }
        this._selectionListeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this._selectionListeners != null) {
            this._selectionListeners.remove(listener);
        }
    }

    public void fireSelectionChanged() {
        if (this._selectionListeners != null) {
            for (SelectionListener listener : this._selectionListeners) {
                listener.widgetSelected(null);
            }
        }
    }

    public void fireDefaultSelection() {
        if (this._selectionListeners != null) {
            for (SelectionListener listener : this._selectionListeners) {
                listener.widgetDefaultSelected(null);
            }
        }
    }

    public Object[] getTraces() {
        return this._data.getTraces();
    }

    public boolean[] getTraceFilter() {
        return this._data.getTraceFilter();
    }

    public void refreshData() {
        this._data.refreshData();
        this.adjustScrolls();
        this.redraw();
    }

    public void refreshData(Object[] traces) {
        this._data.refreshData(traces);
        this.adjustScrolls();
        this.redraw();
    }

    public void refreshPartial(ITmfTimeAnalysisEntry parent, TimeEvent item) {
        this._data.refreshPartial(parent, item);
        this.adjustScrolls();
        this.redraw();
    }

    public void adjustScrolls() {
        if (this._timeProvider == null) {
            this.getVerticalBar().setValues(0, 1, 1, 1, 1, 1);
            this.getHorizontalBar().setValues(0, 1, 1, 1, 1, 1);
            return;
        }
        int page = this.countPerPage();
        if (this._topItem + page > this._data._items.length) {
            this._topItem = this._data._items.length - page;
        }
        if (this._topItem < 0) {
            this._topItem = 0;
        }
        this.getVerticalBar().setValues(this._topItem, 0, this._data._items.length, page, 1, page);
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long timeMin = this._timeProvider.getMinTime();
        long timeMax = this._timeProvider.getMaxTime();
        long delta = timeMax - timeMin;
        int timePos = 0;
        int thumb = H_SCROLLBAR_MAX;
        if (delta != 0L) {
            thumb = Math.max(1, (int)((double)H_SCROLLBAR_MAX * ((double)(time1 - time0) / (double)delta)));
            timePos = (int)((double)H_SCROLLBAR_MAX * ((double)(time0 - timeMin) / (double)delta));
        }
        this.getHorizontalBar().setValues(timePos, 0, H_SCROLLBAR_MAX, thumb, Math.max(1, thumb / 2), Math.max(2, thumb));
    }

    boolean ensureVisibleItem(int idx, boolean redraw) {
        boolean changed = false;
        if (idx < 0) {
            idx = 0;
            while (idx < this._data._items.length) {
                if (((Item)this._data._items[idx])._selected) break;
                ++idx;
            }
        }
        if (idx >= this._data._items.length) {
            return changed;
        }
        if (idx < this._topItem) {
            this._topItem = idx;
            this.getVerticalBar().setSelection(this._topItem);
            if (redraw) {
                this.redraw();
            }
            changed = true;
        } else {
            int page = this.countPerPage();
            if (idx >= this._topItem + page) {
                this._topItem = idx - page + 1;
                this.getVerticalBar().setSelection(this._topItem);
                if (redraw) {
                    this.redraw();
                }
                changed = true;
            }
        }
        return changed;
    }

    public ISelection getSelection() {
        PlainSelection sel = new PlainSelection();
        ITmfTimeAnalysisEntry trace = this.getSelectedTrace();
        if (trace != null && this._timeProvider != null) {
            long selectedTime = this._timeProvider.getSelectedTime();
            ITimeEvent event = Utils.findEvent(trace, selectedTime, 0);
            if (event != null) {
                sel.add(event);
            } else {
                sel.add(trace);
            }
        }
        return sel;
    }

    public ISelection getSelectionTrace() {
        PlainSelection sel = new PlainSelection();
        ITmfTimeAnalysisEntry trace = this.getSelectedTrace();
        if (trace != null) {
            sel.add(trace);
        }
        return sel;
    }

    public void selectTrace(int n) {
        if (n != 1 && n != -1) {
            return;
        }
        boolean changed = false;
        int lastSelection = -1;
        int i = 0;
        while (i < this._data._items.length) {
            Item item = (Item)this._data._items[i];
            if (item._selected) {
                lastSelection = i;
                if (1 == n && i < this._data._items.length - 1) {
                    item._selected = false;
                    if (item._hasChildren) {
                        this._data.expandItem(i, true);
                    }
                    item = (Item)this._data._items[i + 1];
                    if (item._hasChildren) {
                        this._data.expandItem(i + 1, true);
                        item = (Item)this._data._items[i + 2];
                    }
                    item._selected = true;
                    changed = true;
                    break;
                }
                if (-1 != n || i <= 0) break;
                Item prevItem = (Item)this._data._items[--i];
                if (prevItem._hasChildren) {
                    if (prevItem._expanded && i > 0) {
                        prevItem = (Item)this._data._items[--i];
                    }
                    if (prevItem._expanded) break;
                    int added = this._data.expandItem(i, true);
                    prevItem = (Item)this._data._items[i + added];
                    item._selected = false;
                    prevItem._selected = true;
                    changed = true;
                    break;
                }
                item._selected = false;
                prevItem._selected = true;
                changed = true;
                break;
            }
            ++i;
        }
        if (lastSelection < 0 && this._data._items.length > 0) {
            Item item = (Item)this._data._items[0];
            if (item._hasChildren) {
                this._data.expandItem(0, true);
                item = (Item)this._data._items[1];
                item._selected = true;
                changed = true;
            } else {
                item._selected = true;
                changed = true;
            }
        }
        if (changed) {
            this.ensureVisibleItem(-1, false);
            this.redraw();
            this.fireSelectionChanged();
        }
    }

    public void selectEvent(int n) {
        if (this._timeProvider == null) {
            return;
        }
        ITmfTimeAnalysisEntry trace = this.getSelectedTrace();
        if (trace == this._timeProvider || trace == null) {
            return;
        }
        long selectedTime = this._timeProvider.getSelectedTime();
        long endTime = this._timeProvider.getEndTime();
        ITimeEvent nextEvent = -1 == n && selectedTime > endTime ? Utils.findEvent(trace, selectedTime, 0) : Utils.findEvent(trace, selectedTime, n);
        if (nextEvent == null && -1 == n) {
            nextEvent = Utils.getFirstEvent(trace);
        }
        if (nextEvent != null) {
            long nextTime = nextEvent.getTime();
            if (nextTime <= selectedTime && n == 1 && (nextTime = nextEvent.getTime() + nextEvent.getDuration()) > endTime) {
                nextTime = endTime;
            }
            this._timeProvider.setSelectedTimeInt(nextTime, true);
            this.fireSelectionChanged();
        } else if (1 == n) {
            this._timeProvider.setSelectedTimeInt(endTime, true);
            this.fireSelectionChanged();
        }
    }

    public void selectNextEvent() {
        this.selectEvent(1);
        this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getTime0(), this._timeProvider.getTime1());
    }

    public void selectPrevEvent() {
        this.selectEvent(-1);
        this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getTime0(), this._timeProvider.getTime1());
    }

    public void selectNextTrace() {
        this.selectTrace(1);
    }

    public void selectPrevTrace() {
        this.selectTrace(-1);
    }

    public void zoom(boolean zoomIn) {
        int globalX = this.getDisplay().getCursorLocation().x;
        Point p = this.toControl(globalX, 0);
        int nameSpace = this._timeProvider.getNameSpace();
        int timeSpace = this._timeProvider.getTimeSpace();
        int xPos = Math.max(nameSpace, Math.min(nameSpace + timeSpace, p.x));
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long interval = time1 - time0;
        if (interval == 0L) {
            interval = 1L;
        }
        long newInterval = zoomIn ? Math.max(Math.round((double)interval * 0.8), this._timeProvider.getMinTimeInterval()) : (long)Math.ceil((double)interval * 1.25);
        long center = time0 + Math.round((double)(xPos - nameSpace) / (double)timeSpace * (double)interval);
        long newTime0 = center - Math.round((double)newInterval * (double)(center - time0) / (double)interval);
        long newTime1 = newTime0 + newInterval;
        this._timeProvider.setStartFinishTime(newTime0, newTime1);
    }

    public void zoomIn() {
        long _time0 = this._timeProvider.getTime0();
        long _time1 = this._timeProvider.getTime1();
        long _range = _time1 - _time0;
        long selTime = this._timeProvider.getSelectedTime();
        if (selTime <= _time0 || selTime >= _time1) {
            selTime = (_time0 + _time1) / 2L;
        }
        long time0 = selTime - (long)((double)(selTime - _time0) / 1.5);
        long time1 = selTime + (long)((double)(_time1 - selTime) / 1.5);
        long inaccuracy = this._timeProvider.getMaxTime() - this._timeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0L && inaccuracy < 100L) {
            this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getMinTime(), this._timeProvider.getMaxTime());
            return;
        }
        long m = this._timeProvider.getMinTimeInterval();
        if (time1 - time0 < m) {
            time0 = selTime - (selTime - _time0) * m / _range;
            time1 = time0 + m;
        }
        this._timeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void zoomOut() {
        long _time0 = this._timeProvider.getTime0();
        long _time1 = this._timeProvider.getTime1();
        long selTime = this._timeProvider.getSelectedTime();
        if (selTime <= _time0 || selTime >= _time1) {
            selTime = (_time0 + _time1) / 2L;
        }
        long time0 = (long)((double)selTime - (double)(selTime - _time0) * 1.5);
        long time1 = (long)((double)selTime + (double)(_time1 - selTime) * 1.5);
        long inaccuracy = this._timeProvider.getMaxTime() - this._timeProvider.getMinTime() - (time1 - time0);
        if (inaccuracy > 0L && inaccuracy < 100L) {
            this._timeProvider.setStartFinishTimeNotify(this._timeProvider.getMinTime(), this._timeProvider.getMaxTime());
            return;
        }
        this._timeProvider.setStartFinishTimeNotify(time0, time1);
    }

    public void groupTraces(boolean on) {
        this._data.groupTraces(on);
        this.adjustScrolls();
        this.redraw();
    }

    public void toggleTraceInteractionDrawing() {
        this.drawTracesInteraction = !this.drawTracesInteraction;
        this.redraw();
    }

    public void setTraceJoinDrawing(boolean on) {
        this.drawTraceJoins = on;
        this.drawTracesInteraction = true;
        this.redraw();
    }

    public void setTraceWaitDrawing(boolean on) {
        this.drawTraceWaits = on;
        this.drawTracesInteraction = true;
        this.redraw();
    }

    public void setTraceReleaseDrawing(boolean on) {
        this.drawTraceReleases = on;
        this.drawTracesInteraction = true;
        this.redraw();
    }

    public boolean getTracesInteractionDrawing() {
        return this.drawTracesInteraction;
    }

    public boolean getTraceJoinDrawing() {
        return this.drawTraceJoins;
    }

    public boolean getTraceWaitDrawing() {
        return this.drawTraceWaits;
    }

    public boolean getTraceReleaseDrawing() {
        return this.drawTraceReleases;
    }

    public ITmfTimeAnalysisEntry getSelectedTrace() {
        ITmfTimeAnalysisEntry trace = null;
        int idx = this.getSelectedIndex();
        if (idx >= 0 && this._data._items[idx] instanceof TraceItem) {
            trace = ((TraceItem)this._data._items[idx])._trace;
        }
        return trace;
    }

    public int getSelectedIndex() {
        int idx = -1;
        int i = 0;
        while (i < this._data._items.length) {
            Item item = (Item)this._data._items[i];
            if (item._selected) {
                idx = i;
                break;
            }
            ++i;
        }
        return idx;
    }

    boolean toggle(int idx) {
        boolean toggled = false;
        if (idx >= 0 && idx < this._data._items.length) {
            Item item = (Item)this._data._items[idx];
            if (item._hasChildren) {
                item._expanded = !item._expanded;
                this._data.updateItems();
                this.adjustScrolls();
                this.redraw();
                toggled = true;
            }
        }
        return toggled;
    }

    int hitTest(int x, int y) {
        if (x < 0 || y < 0) {
            return -1;
        }
        int hit = -1;
        int idx = y / this._itemHeight;
        if ((idx += this._topItem) < this._data._items.length) {
            hit = idx;
        }
        return hit;
    }

    int hitSplitTest(int x, int y) {
        if (x < 0 || y < 0 || this._timeProvider == null) {
            return -1;
        }
        int w = 4;
        int hit = -1;
        int nameWidth = this._timeProvider.getNameSpace();
        if (x > nameWidth - w && x < nameWidth + w) {
            hit = 1;
        }
        return hit;
    }

    public Item getItem(Point pt) {
        int idx = this.hitTest(pt.x, pt.y);
        return idx >= 0 ? (Item)this._data._items[idx] : null;
    }

    long hitTimeTest(int x) {
        if (this._timeProvider == null) {
            return -1L;
        }
        long hitTime = -1L;
        Point size = this.getCtrlSize();
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        int nameWidth = this._timeProvider.getNameSpace();
        if ((x -= nameWidth) >= 0 && size.x >= nameWidth) {
            hitTime = time1 - time0 > (long)(size.x - nameWidth - 2) ? time0 + (long)((double)(time1 - time0) * ((double)(x + 1) / (double)(size.x - nameWidth - 2))) - 1L : time0 + (long)((double)(time1 - time0) * ((double)x / (double)(size.x - nameWidth - 2)));
        }
        return hitTime;
    }

    void selectItem(int idx, boolean addSelection) {
        boolean changed = false;
        if (addSelection) {
            if (idx >= 0 && idx < this._data._items.length) {
                Item item = (Item)this._data._items[idx];
                changed = !item._selected;
                item._selected = true;
            }
        } else {
            int i = 0;
            while (i < this._data._items.length) {
                Item item = (Item)this._data._items[i];
                if (i == idx && !item._selected) {
                    changed = true;
                }
                item._selected = i == idx;
                ++i;
            }
        }
        if (changed |= this.ensureVisibleItem(idx, true)) {
            this.redraw();
        }
    }

    public void selectItem(ITmfTimeAnalysisEntry trace, boolean addSelection) {
        Integer idx = this._data.findTraceItemIndex(trace);
        if (idx != null) {
            this.selectItem(idx, addSelection);
        }
    }

    public int countPerPage() {
        int height = this.getCtrlSize().y;
        int count = 0;
        if (height > 0) {
            count = height / this._itemHeight;
        }
        return count;
    }

    public int getTopIndex() {
        int idx = -1;
        if (this._data._items.length > 0) {
            idx = 0;
        }
        return idx;
    }

    public int getBottomIndex() {
        int idx = this._data._items.length - 1;
        return idx;
    }

    Point getCtrlSize() {
        Point size = this.getSize();
        if (this.getVerticalBar().isVisible()) {
            size.x -= this.getVerticalBar().getSize().x;
        }
        if (this.getHorizontalBar().isVisible()) {
            size.y -= this.getHorizontalBar().getSize().y;
        }
        return size;
    }

    void getNameRect(Rectangle rect, Rectangle bound, int idx, int nameWidth) {
        rect.x = bound.x;
        rect.y = bound.y + (idx -= this._topItem) * this._itemHeight;
        rect.width = nameWidth;
        rect.height = this._itemHeight;
    }

    void getStatesRect(Rectangle rect, Rectangle bound, int idx, int nameWidth) {
        rect.x = bound.x + nameWidth;
        rect.y = bound.y + (idx -= this._topItem) * this._itemHeight;
        rect.width = bound.width - rect.x;
        rect.height = this._itemHeight;
    }

    public void drawTraceEvent(Rectangle bound, ITimeEvent e, int nItem, int color, GC gc) {
        long time1;
        int nameWidth = this._timeProvider.getNameSpace();
        long time0 = this._timeProvider.getTime0();
        if (time0 == (time1 = this._timeProvider.getTime1())) {
            return;
        }
        int xr = bound.x + nameWidth;
        double pixelsPerNanoSec = bound.width - xr <= 2 ? 0.0 : (double)(bound.width - xr - 2) / (double)(time1 - time0);
        int x0 = xr + (int)((double)(e.getTime() - time0) * pixelsPerNanoSec);
        if (x0 < xr) {
            return;
        }
        int y0 = bound.y + (nItem - this._topItem) * this._itemHeight + 3;
        gc.setBackground(this._colors.getColor(color));
        int[] c = new int[]{x0 - 3, y0 - 3, x0, y0, x0 + 3, y0 - 3};
        gc.fillPolygon(c);
    }

    public void drawTraceInteractions(Rectangle bound, GC gc) {
    }

    @Override
    void paint(Rectangle bound, PaintEvent e) {
        GC gc = e.gc;
        gc.setBackground(this._colors.getColor(32));
        this.drawBackground(gc, bound.x, bound.y, bound.width, bound.height);
        if (bound.width < 2 || bound.height < 2 || this._timeProvider == null) {
            return;
        }
        this._idealNameWidth = 0;
        int nameWidth = this._timeProvider.getNameSpace();
        long time0 = this._timeProvider.getTime0();
        long time1 = this._timeProvider.getTime1();
        long endTime = this._timeProvider.getEndTime();
        long selectedTime = this._timeProvider.getSelectedTime();
        Object[] items = this._data._items;
        int i = this._topItem;
        while (i < items.length) {
            Item item = (Item)items[i];
            this.getNameRect(this._rect0, bound, i, nameWidth);
            if (this._rect0.y >= bound.y + bound.height) break;
            if (item instanceof GroupItem) {
                this.getStatesRect(this._rect1, bound, i, nameWidth);
                this._rect0.width += this._rect1.width;
                this.drawName(item, this._rect0, gc);
            } else {
                this.drawName(item, this._rect0, gc);
            }
            this.getStatesRect(this._rect0, bound, i, nameWidth);
            this.drawItemDataDurations(item, this._rect0, time0, time1, endTime, selectedTime, gc);
            ++i;
        }
        if (this.drawTracesInteraction) {
            this.drawTraceInteractions(bound, e.gc);
        }
        if (this._itemHeight * items.length < bound.height) {
            gc.setBackground(this._colors.getBkColor(false, false, true));
            this.drawBackground(gc, bound.x, this._itemHeight * items.length, nameWidth, bound.height - this._itemHeight * items.length);
        }
        if (3 == this._dragState) {
            gc.setForeground(this._colors.getColor(43));
            gc.drawLine(bound.x + nameWidth, bound.y, bound.x + nameWidth, bound.y + bound.height - 1);
        } else if (this._dragState == 0 && this._mouseHover && this._timeProvider.getNameSpace() > 0) {
            gc.setForeground(this._colors.getColor(62));
            gc.drawLine(bound.x + nameWidth, bound.y, bound.x + nameWidth, bound.y + bound.height - 1);
        }
    }

    void drawName(Item item, Rectangle rect, GC gc) {
        int elemHeight;
        if (this._timeProvider.getNameSpace() == 0) {
            return;
        }
        boolean group = item instanceof GroupItem;
        int elemWidth = elemHeight = rect.height / 2;
        String name = item._name;
        if (group) {
            gc.setBackground(this._colors.getBkColorGroup(item._selected, this._isInFocus));
            gc.fillRectangle(rect);
            if (item._selected && this._isInFocus) {
                gc.setForeground(this._colors.getBkColor(item._selected, this._isInFocus, false));
                gc.drawRectangle(rect.x, rect.y, rect.width - 2, rect.height - 2);
            }
            gc.setForeground(this._colors.getBkColor(false, false, false));
            gc.drawLine(rect.x, rect.y + rect.height - 1, rect.width - 1, rect.y + rect.height - 1);
            gc.setForeground(this._colors.getFgColorGroup(false, false));
            gc.setBackground(this._colors.getBkColor(false, false, false));
            Utils.init(this._rect1, rect);
            this._rect1.x += 4;
            this._rect1.y += (rect.height - elemHeight) / 2;
            this._rect1.width = elemWidth;
            this._rect1.height = elemHeight;
            gc.fillRectangle(this._rect1);
            gc.drawRectangle(this._rect1.x, this._rect1.y, this._rect1.width - 1, this._rect1.height - 1);
            int p = this._rect1.y + this._rect1.height / 2;
            gc.drawLine(this._rect1.x + 2, p, this._rect1.x + this._rect1.width - 3, p);
            if (!item._expanded) {
                p = this._rect1.x + this._rect1.width / 2;
                gc.drawLine(p, this._rect1.y + 2, p, this._rect1.y + this._rect1.height - 3);
            }
            gc.setForeground(this._colors.getFgColorGroup(item._selected, this._isInFocus));
            elemWidth += 4;
        } else {
            gc.setBackground(this._colors.getBkColor(item._selected, this._isInFocus, true));
            gc.setForeground(this._colors.getFgColor(item._selected, this._isInFocus));
            gc.fillRectangle(rect);
            Utils.init(this._rect1, rect);
            this._rect1.x += 4;
            ITmfTimeAnalysisEntry trace = ((TraceItem)item)._trace;
            Image img = this.utilImpl.getItemImage(trace);
            if (img != null) {
                this._rect1.y += (rect.height - img.getImageData().height) / 2;
                gc.drawImage(img, this._rect1.x, this._rect1.y);
            }
            elemWidth = 16;
            Point size = gc.stringExtent(name);
            if (this._idealNameWidth < size.x) {
                this._idealNameWidth = size.x;
            }
            int width = rect.width - 4 - 4 - elemWidth;
            int cuts = 0;
            while (size.x > width && name.length() > 1) {
                ++cuts;
                name = name.substring(0, name.length() - 1);
                size = gc.stringExtent(String.valueOf(name) + "...");
            }
            if (cuts > 0) {
                name = String.valueOf(name) + "...";
            }
            elemWidth += 4;
        }
        Utils.init(this._rect1, rect);
        int leftMargin = 4 + elemWidth;
        this._rect1.x += leftMargin;
        this._rect1.width -= leftMargin;
        int textWidth = 0;
        if (this._rect1.width > 0) {
            this._rect1.y += 2;
            textWidth = Utils.drawText(gc, name, this._rect1, true) + 8;
            this._rect1.y -= 2;
        }
        if (this._rect1.width > 0 && !group) {
            Utils.init(this._rect1, rect);
            this._rect1.x += leftMargin + textWidth;
            this._rect1.width -= textWidth;
            gc.setForeground(this._colors.getColor(61));
            int midy = this._rect1.y + this._rect1.height / 2;
            gc.drawLine(this._rect1.x, midy, this._rect1.x + this._rect1.width, midy);
        }
    }

    void drawItemData(Item item, Rectangle rect, long time0, long time1, long endTime, long selectedTime, GC gc) {
        int x;
        if (rect.isEmpty()) {
            return;
        }
        if (time1 <= time0) {
            gc.setBackground(this._colors.getBkColor(false, false, false));
            gc.fillRectangle(rect);
            return;
        }
        Utils.init(this._rect1, rect);
        boolean selected = item._selected;
        double pixelsPerNanoSec = rect.width <= 2 ? 0.0 : (double)(rect.width - 2) / (double)(time1 - time0);
        boolean group = item instanceof GroupItem;
        if (!group && item instanceof TraceItem) {
            int xEnd;
            ITmfTimeAnalysisEntry trace = ((TraceItem)item)._trace;
            int x0 = rect.x;
            Iterator iterator = trace.getTraceEventsIterator();
            ITimeEvent lastEvent = null;
            if (iterator.hasNext()) {
                long currEventTime;
                ITimeEvent currEvent = (ITimeEvent)iterator.next();
                ITimeEvent nextEvent = null;
                long nextEventTime = currEventTime = currEvent.getTime();
                x0 = rect.x + (int)((double)(currEventTime - time0) * pixelsPerNanoSec);
                int xEnd2 = rect.x + (int)((double)(time1 - time0) * pixelsPerNanoSec);
                int x1 = -1;
                this._rect1.y += 3;
                this._rect1.height -= 6;
                this.fillSpace(rect, gc, selected);
                while (x0 <= xEnd2 && currEvent != null) {
                    boolean stopped = false;
                    if (iterator.hasNext()) {
                        nextEvent = (ITimeEvent)iterator.next();
                        nextEventTime = nextEvent.getTime();
                    } else if (stopped) {
                        nextEvent = null;
                        nextEventTime = time1;
                    } else {
                        nextEvent = null;
                        nextEventTime = endTime;
                    }
                    x1 = rect.x + (int)((double)(nextEventTime - time0) * pixelsPerNanoSec);
                    if (x1 >= rect.x) {
                        this._rect1.x = x0 >= rect.x ? x0 : rect.x;
                        this._rect1.width = (x1 <= xEnd2 ? x1 : xEnd2) - this._rect1.x;
                        boolean timeSelected = currEventTime <= selectedTime && selectedTime < nextEventTime;
                        this.utilImpl.drawState(this._colors, currEvent, this._rect1, gc, selected, false, timeSelected);
                    }
                    lastEvent = currEvent;
                    currEvent = nextEvent;
                    currEventTime = nextEventTime;
                    x0 = x1;
                }
            }
            if (x0 < (xEnd = rect.x + rect.width)) {
                this._rect1.x = x0 >= rect.x ? x0 : rect.x;
                this._rect1.width = xEnd - this._rect1.x;
                gc.setBackground(this._colors.getBkColor(selected, this._isInFocus, false));
                gc.fillRectangle(this._rect1);
                gc.setForeground(this._colors.getColor(this.utilImpl.getEventColorVal(lastEvent)));
                int midy = this._rect1.y + this._rect1.height / 2;
                int lw = gc.getLineWidth();
                gc.setLineWidth(2);
                gc.drawLine(this._rect1.x, midy, this._rect1.x + this._rect1.width, midy);
                gc.setLineWidth(lw);
            }
        }
        if ((x = rect.x + (int)((double)(selectedTime - time0) * pixelsPerNanoSec)) >= rect.x && x < rect.x + rect.width) {
            gc.setForeground(this._colors.getColor(68));
            if (group) {
                gc.drawLine(x, rect.y + rect.height - 1, x, rect.y + rect.height);
            } else {
                gc.drawLine(x, rect.y, x, rect.y + rect.height);
            }
        }
    }

    void drawItemDataBurst(Item item, Rectangle rect, long time0, long time1, long endTime, long selectedTime, GC gc) {
        int x;
        if (rect.isEmpty()) {
            return;
        }
        if (time1 <= time0) {
            gc.setBackground(this._colors.getBkColor(false, false, false));
            gc.fillRectangle(rect);
            return;
        }
        Utils.init(this._rect1, rect);
        boolean selected = item._selected;
        double pixelsPerNanoSec = rect.width <= 2 ? 0.0 : (double)(rect.width - 2) / (double)(time1 - time0);
        boolean group = item instanceof GroupItem;
        if (!group && item instanceof TraceItem) {
            int xEnd;
            ITmfTimeAnalysisEntry trace = ((TraceItem)item)._trace;
            double x0 = rect.x;
            Iterator iterator = trace.getTraceEventsIterator();
            ITimeEvent lastEvent = null;
            if (iterator.hasNext()) {
                long currEventTime;
                ITimeEvent currEvent = (ITimeEvent)iterator.next();
                ITimeEvent nextEvent = null;
                long nextEventTime = currEventTime = currEvent.getTime();
                double step = (double)(currEventTime - time0) * pixelsPerNanoSec;
                x0 = (double)rect.x + step;
                double xEnd2 = (double)rect.x + (double)(time1 - time0) * pixelsPerNanoSec;
                double x1 = -1.0;
                this._rect1.y += 3;
                this._rect1.height -= 6;
                this.fillSpace(rect, gc, selected);
                while (x0 <= xEnd2 && currEvent != null) {
                    boolean stopped = false;
                    if (iterator.hasNext()) {
                        nextEvent = (ITimeEvent)iterator.next();
                        nextEventTime = nextEvent.getTime();
                    } else if (stopped) {
                        nextEvent = null;
                        nextEventTime = time1;
                    } else {
                        nextEvent = null;
                        nextEventTime = endTime;
                    }
                    x1 = x0 + 2.0;
                    if (x1 >= (double)rect.x && x0 <= xEnd2) {
                        this._rect1.x = (int)(x0 >= (double)rect.x ? x0 : (double)rect.x);
                        this._rect1.width = (int)((x1 <= xEnd2 ? x1 : xEnd2) - (double)this._rect1.x);
                        boolean timeSelected = currEventTime <= selectedTime && selectedTime < nextEventTime;
                        this.utilImpl.drawState(this._colors, currEvent, this._rect1, gc, selected, false, timeSelected);
                        this._rect1.x += this._rect1.width;
                        x0 = x1;
                    }
                    this.fillSpace(rect, gc, selected);
                    lastEvent = currEvent;
                    currEvent = nextEvent;
                    currEventTime = nextEventTime;
                    x0 = (double)rect.x + (double)(nextEventTime - time0) * pixelsPerNanoSec;
                }
            }
            if (x0 < (double)(xEnd = rect.x + rect.width)) {
                this._rect1.x = (int)(x0 >= (double)rect.x ? x0 : (double)rect.x);
                this._rect1.width = xEnd - this._rect1.x;
                gc.setBackground(this._colors.getBkColor(selected, this._isInFocus, false));
                gc.fillRectangle(this._rect1);
                gc.setForeground(this._colors.getColor(this.utilImpl.getEventColorVal(lastEvent)));
                int midy = this._rect1.y + this._rect1.height / 2;
                int lw = gc.getLineWidth();
                gc.setLineWidth(2);
                gc.drawLine(this._rect1.x, midy, this._rect1.x + this._rect1.width, midy);
                gc.setLineWidth(lw);
            }
        }
        if ((x = rect.x + (int)((double)(selectedTime - time0) * pixelsPerNanoSec)) >= rect.x && x < rect.x + rect.width) {
            gc.setForeground(this._colors.getColor(68));
            if (group) {
                gc.drawLine(x, rect.y + rect.height - 1, x, rect.y + rect.height);
            } else {
                gc.drawLine(x, rect.y, x, rect.y + rect.height);
            }
        }
    }

    void drawItemDataDurations(Item item, Rectangle rect, long time0, long time1, long endTime, long selectedTime, GC gc) {
        int x;
        if (rect.isEmpty()) {
            return;
        }
        if (time1 <= time0) {
            gc.setBackground(this._colors.getBkColor(false, false, false));
            gc.fillRectangle(rect);
            return;
        }
        Utils.init(this._rect1, rect);
        boolean selected = item._selected;
        double pixelsPerNanoSec = rect.width <= 2 ? 0.0 : (double)(rect.width - 2) / (double)(time1 - time0);
        boolean group = item instanceof GroupItem;
        if (!group && item instanceof TraceItem) {
            ITmfTimeAnalysisEntry trace = ((TraceItem)item)._trace;
            double x0 = rect.x;
            long maxDuration = this._timeProvider.getTimeSpace() == 0 ? Long.MAX_VALUE : 1L * (this._timeProvider.getTime1() - this._timeProvider.getTime0()) / (long)this._timeProvider.getTimeSpace();
            Iterator iterator = trace.getTraceEventsIterator(this._timeProvider.getTime0(), this._timeProvider.getTime1(), maxDuration);
            this._rect1.y += 3;
            this._rect1.height -= 6;
            int xEnd = rect.x + rect.width;
            this.fillSpace(rect, gc, selected);
            if (iterator.hasNext()) {
                ITimeEvent currEvent = (ITimeEvent)iterator.next();
                ITimeEvent nextEvent = null;
                long currEventTime = currEvent.getTime();
                long currEventDuration = currEvent.getDuration();
                long nextEventTime = currEventTime;
                double step = (double)(currEventTime - time0) * pixelsPerNanoSec;
                x0 = (double)rect.x + step;
                double x1 = -1.0;
                double xNext = 0.0;
                while (currEvent != null) {
                    boolean stopped = false;
                    currEventDuration = currEvent.getDuration();
                    if (iterator.hasNext()) {
                        nextEvent = (ITimeEvent)iterator.next();
                        nextEventTime = nextEvent.getTime();
                    } else if (stopped) {
                        nextEvent = null;
                        nextEventTime = time1;
                    } else {
                        nextEvent = null;
                        nextEventTime = endTime;
                    }
                    xNext = (double)rect.x + (double)(nextEventTime - time0) * pixelsPerNanoSec;
                    x1 = currEventDuration < 0L ? (double)rect.x + (double)(nextEventTime - time0) * pixelsPerNanoSec : (currEventDuration == 0L ? x0 : x0 + (double)currEventDuration * pixelsPerNanoSec);
                    if (currEventDuration != 0L) {
                        double d = x1 = x1 > xNext ? xNext : x1;
                    }
                    if (x1 >= (double)rect.x && x0 <= (double)xEnd) {
                        if (currEventDuration != 0L) {
                            x0 = x0 >= (double)rect.x ? x0 : (double)rect.x;
                            this._rect1.width = (int)((x1 <= (double)xEnd ? x1 : (double)xEnd) - x0);
                        } else {
                            this._rect1.width = 1;
                        }
                        this._rect1.width = Math.max(this._minimumItemWidth, this._rect1.width);
                        this._rect1.x = (int)x0;
                        boolean timeSelected = currEventTime <= selectedTime && selectedTime < nextEventTime;
                        this.utilImpl.drawState(this._colors, currEvent, this._rect1, gc, selected, false, timeSelected);
                        this._rect1.x += this._rect1.width;
                        x0 = this._rect1.x;
                    }
                    currEvent = nextEvent;
                    currEventTime = nextEventTime;
                    x0 = (double)rect.x + (double)(nextEventTime - time0) * pixelsPerNanoSec;
                }
            }
        }
        if ((x = rect.x + (int)((double)(selectedTime - time0) * pixelsPerNanoSec)) >= rect.x && x < rect.x + rect.width) {
            gc.setForeground(this._colors.getColor(68));
            if (group) {
                gc.drawLine(x, rect.y + rect.height - 1, x, rect.y + rect.height);
            } else {
                gc.drawLine(x, rect.y, x, rect.y + rect.height);
            }
        }
    }

    private void fillSpace(Rectangle rect, GC gc, boolean selected) {
        gc.setBackground(this._colors.getBkColor(selected, this._isInFocus, false));
        gc.fillRectangle(rect);
        gc.setForeground(this._colors.getColor(61));
        int midy = rect.y + rect.height / 2;
        gc.drawLine(rect.x, midy, rect.x + rect.width, midy);
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16 || e.detail == 8) {
            e.doit = true;
        }
    }

    public void keyPressed(KeyEvent e) {
        int idx = -1;
        if (0x1000007 == e.keyCode) {
            idx = this.getTopIndex();
        } else if (0x1000008 == e.keyCode) {
            idx = this.getBottomIndex();
        } else if (0x1000002 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx < this._data._items.length - 1) {
                ++idx;
            }
        } else if (0x1000001 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            } else if (idx > 0) {
                --idx;
            }
        } else if (0x1000003 == e.keyCode) {
            this.selectPrevEvent();
        } else if (0x1000004 == e.keyCode) {
            this.selectNextEvent();
        } else if (0x1000006 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx += page) >= this._data._items.length) {
                idx = this._data._items.length - 1;
            }
        } else if (0x1000005 == e.keyCode) {
            int page = this.countPerPage();
            idx = this.getSelectedIndex();
            if (idx < 0) {
                idx = 0;
            }
            if ((idx -= page) < 0) {
                idx = 0;
            }
        } else if (13 == e.keyCode) {
            idx = this.getSelectedIndex();
            if (idx >= 0) {
                if (this._data._items[idx] instanceof TraceItem) {
                    this.fireDefaultSelection();
                } else if (this._data._items[idx] instanceof GroupItem) {
                    this.toggle(idx);
                }
            }
            idx = -1;
        }
        if (idx >= 0) {
            this.selectItem(idx, false);
            this.fireSelectionChanged();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void focusGained(FocusEvent e) {
        this._isInFocus = true;
        this.redraw();
        if (this.mouseScrollFilterListener == null) {
            this.mouseScrollFilterListener = new Listener(){

                public void handleEvent(Event event) {
                    event.doit = false;
                }
            };
            this.getDisplay().addFilter(37, this.mouseScrollFilterListener);
        }
    }

    public void focusLost(FocusEvent e) {
        this._isInFocus = false;
        if (this._dragState != 0) {
            this.setCapture(false);
            this._dragState = 0;
        }
        this.redraw();
        if (this.mouseScrollFilterListener != null) {
            this.getDisplay().removeFilter(37, this.mouseScrollFilterListener);
            this.mouseScrollFilterListener = null;
        }
    }

    public boolean isInFocus() {
        return this._isInFocus;
    }

    public void mouseMove(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        Point size = this.getCtrlSize();
        if (1 == this._dragState) {
            int nameWidth = this._timeProvider.getNameSpace();
            int x = e.x - nameWidth;
            if (x > 0 && size.x > nameWidth && this._dragX != x) {
                long time0;
                long maxTime;
                this._dragX = x;
                double pixelsPerNanoSec = size.x - nameWidth <= 2 ? 0.0 : (double)(size.x - nameWidth - 2) / (double)(this._time1bak - this._time0bak);
                long timeDelta = (long)(pixelsPerNanoSec == 0.0 ? 0.0 : (double)(this._dragX - this._dragX0) / pixelsPerNanoSec);
                long time1 = this._time1bak - timeDelta;
                if (time1 > (maxTime = this._timeProvider.getMaxTime())) {
                    time1 = maxTime;
                }
                if ((time0 = time1 - (this._time1bak - this._time0bak)) < this._timeProvider.getMinTime()) {
                    time0 = this._timeProvider.getMinTime();
                    time1 = time0 + (this._time1bak - this._time0bak);
                }
                this._timeProvider.setStartFinishTime(time0, time1);
            }
        } else if (3 == this._dragState) {
            this._dragX = e.x;
            this._timeProvider.setNameSpace(this._hitIdx + this._dragX - this._dragX0);
        } else if (this._dragState == 0) {
            boolean mouseHover;
            boolean bl = mouseHover = this.hitSplitTest(e.x, e.y) > 0;
            if (this._mouseHover != mouseHover) {
                this.redraw();
            }
            this._mouseHover = mouseHover;
            this._timeProvider.notifyStartFinishTime();
        }
        this.updateCursor(e.x, e.y);
    }

    public void mouseDoubleClick(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        if (1 == e.button) {
            int idx = this.hitSplitTest(e.x, e.y);
            if (idx >= 0) {
                this._timeProvider.setNameSpace(this._idealNameWidth + 12 + 16);
                return;
            }
            idx = this.hitTest(e.x, e.y);
            if (idx >= 0) {
                this.selectItem(idx, false);
                if (this._data._items[idx] instanceof TraceItem) {
                    this.fireDefaultSelection();
                }
            }
        }
    }

    void updateCursor(int x, int y) {
        if (!this._isWaitCursor) {
            int idx = this.hitSplitTest(x, y);
            if (idx > 0 && !this._isDragCursor3 && this._timeProvider.getNameSpace() > 0) {
                this.setCursor(this._dragCursor3);
                this._isDragCursor3 = true;
            } else if (idx <= 0 && this._isDragCursor3) {
                this.setCursor(null);
                this._isDragCursor3 = false;
            }
        }
    }

    public void waitCursor(boolean waitInd) {
        if (waitInd) {
            this.setCursor(this._WaitCursor);
            this._isWaitCursor = true;
        } else {
            this.setCursor(null);
            this._isWaitCursor = false;
        }
        this._isDragCursor3 = false;
    }

    public void mouseDown(MouseEvent e) {
        if (this._timeProvider == null) {
            return;
        }
        if (1 == e.button) {
            int idx;
            int namewidth = this._timeProvider.getNameSpace();
            if (namewidth != 0 && (idx = this.hitSplitTest(e.x, e.y)) > 0) {
                this._dragState = 3;
                this._dragX = this._dragX0 = e.x;
                this._hitIdx = this._timeProvider.getNameSpace();
                this._time0bak = this._timeProvider.getTime0();
                this._time1bak = this._timeProvider.getTime1();
                this.redraw();
                return;
            }
            idx = this.hitTest(e.x, e.y);
            if (idx >= 0) {
                if (this._data._items[idx] instanceof TraceItem) {
                    long hitTime = this.hitTimeTest(e.x);
                    if (hitTime >= 0L) {
                        this.setCapture(true);
                        this._dragState = 1;
                        this._dragX = this._dragX0 = e.x - this._timeProvider.getNameSpace();
                        this._hitIdx = idx;
                        this._time0bak = this._timeProvider.getTime0();
                        this._time1bak = this._timeProvider.getTime1();
                        return;
                    }
                } else if (this._data._items[idx] instanceof GroupItem) {
                    this._dragX0 = e.x;
                    this._dragState = 2;
                }
                this.selectItem(idx, false);
                this.fireSelectionChanged();
            } else {
                this.selectItem(idx, false);
                this.redraw();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        if (this._dragState != 0) {
            this.setCapture(false);
            if (1 == this._dragState) {
                this._timeProvider.notifyStartFinishTime();
                if (this._dragX == this._dragX0) {
                    long time = this.hitTimeTest(e.x);
                    this._timeProvider.setSelectedTimeInt(time, false);
                    this.selectItem(this._hitIdx, false);
                    this.fireSelectionChanged();
                }
            } else if (2 == this._dragState) {
                if (e.x == this._dragX0) {
                    this.toggle(this._hitIdx);
                }
            } else if (3 == this._dragState) {
                this.redraw();
            }
            this._dragState = 0;
        }
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
        this.adjustScrolls();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.getVerticalBar()) {
            this._topItem = this.getVerticalBar().getSelection();
            if (this._topItem < 0) {
                this._topItem = 0;
            }
            this.redraw();
        } else if (e.widget == this.getHorizontalBar() && this._timeProvider != null) {
            int start = this.getHorizontalBar().getSelection();
            long time0 = this._timeProvider.getTime0();
            long time1 = this._timeProvider.getTime1();
            long timeMin = this._timeProvider.getMinTime();
            long timeMax = this._timeProvider.getMaxTime();
            long delta = timeMax - timeMin;
            long range = time1 - time0;
            time0 = timeMin + (long)((double)delta * ((double)start / (double)H_SCROLLBAR_MAX));
            time1 = time0 + range;
            if (e.detail == 1) {
                this._timeProvider.setStartFinishTime(time0, time1);
            } else {
                this._timeProvider.setStartFinishTimeNotify(time0, time1);
            }
        }
    }

    public void mouseEnter(MouseEvent e) {
    }

    public void mouseExit(MouseEvent e) {
        if (this._mouseHover) {
            this._mouseHover = false;
            this.redraw();
        }
    }

    public void mouseHover(MouseEvent e) {
    }

    public void mouseScrolled(MouseEvent e) {
        if (!this._isInFocus || this._dragState != 0) {
            return;
        }
        if (e.count > 0) {
            this.zoom(true);
        } else if (e.count < 0) {
            this.zoom(false);
        }
    }

    public boolean isVisibleVerticalScroll() {
        return this._visibleVerticalScroll;
    }

    public void setVisibleVerticalScroll(boolean visibleVerticalScroll) {
        ScrollBar scrollVer = this.getVerticalBar();
        if (scrollVer != null) {
            scrollVer.setVisible(visibleVerticalScroll);
        }
        this._visibleVerticalScroll = visibleVerticalScroll;
    }

    public int getBorderWidth() {
        return this._borderWidth;
    }

    public void setBorderWidth(int borderWidth) {
        this._borderWidth = borderWidth;
    }

    public int getHeaderHeight() {
        return this._headerHeight;
    }

    public void setHeaderHeight(int headerHeight) {
        this._headerHeight = headerHeight;
    }

    public int getItemHeight() {
        return this._itemHeight;
    }

    public void setItemHeight(int rowHeight) {
        this._itemHeight = rowHeight;
    }

    public void setMinimumItemWidth(int width) {
        this._minimumItemWidth = width;
    }

    public Vector<ITmfTimeAnalysisEntry> getFilteredOut() {
        return this._data.getFilteredOut();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null && !this._selectionChangedListeners.contains(listener)) {
            this._selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this._selectionChangedListeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        PlainSelection sel;
        Object ob;
        if (selection instanceof PlainSelection && (ob = (sel = (PlainSelection)selection).getFirstElement()) instanceof ITmfTimeAnalysisEntry) {
            ITmfTimeAnalysisEntry trace = (ITmfTimeAnalysisEntry)ob;
            this.selectItem(trace, false);
        }
    }
}

