/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.tmf.ui.views.timechart;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.linuxtools.tmf.event.TmfEvent;
import org.eclipse.linuxtools.tmf.filter.ITmfFilter;

public class TimeChartDecorationProvider {
    private IResource fResource;
    private Set<Long> fBookmarksSet = new HashSet<Long>();
    private ITmfFilter fFilterFilter;
    private ITmfFilter fSearchFilter;

    public TimeChartDecorationProvider(IResource resource) {
        this.fResource = resource;
        this.refreshBookmarks();
    }

    public IResource getResource() {
        return this.fResource;
    }

    public boolean isBookmark(long rank) {
        return this.fBookmarksSet.contains(rank);
    }

    public void refreshBookmarks() {
        try {
            this.fBookmarksSet.clear();
            IMarker[] iMarkerArray = this.fResource.findMarkers("org.eclipse.core.resources.bookmark", false, 0);
            int n = iMarkerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker bookmark = iMarkerArray[n2];
                int location = bookmark.getAttribute("location", -1);
                if (location != -1) {
                    Long rank = location;
                    this.fBookmarksSet.add(rank);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void filterApplied(ITmfFilter filter) {
        this.fFilterFilter = filter;
    }

    public boolean isVisible(TmfEvent event) {
        if (this.fFilterFilter != null) {
            return this.fFilterFilter.matches(event);
        }
        return true;
    }

    public void searchApplied(ITmfFilter filter) {
        this.fSearchFilter = filter;
    }

    public boolean isSearchMatch(TmfEvent event) {
        if (this.fSearchFilter != null) {
            return this.fSearchFilter.matches(event);
        }
        return false;
    }
}

