/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.console;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.console.ConsoleDocument;
import org.eclipse.m2e.core.ui.internal.console.IMavenConsoleListener;
import org.eclipse.m2e.core.ui.internal.console.MavenConsole;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class MavenConsoleImpl
extends IOConsole
implements MavenConsole,
IPropertyChangeListener {
    private boolean initialized = false;
    private boolean visible = false;
    private ConsoleDocument consoleDocument;
    private Color commandColor;
    private Color messageColor;
    private Color errorColor;
    private IOConsoleOutputStream commandStream;
    private IOConsoleOutputStream messageStream;
    private IOConsoleOutputStream errorStream;
    private static final String TITLE = Messages.MavenConsoleImpl_title;
    private List<IMavenConsoleListener> listeners = new CopyOnWriteArrayList<IMavenConsoleListener>();

    public MavenConsoleImpl(ImageDescriptor imageDescriptor) {
        super(TITLE, imageDescriptor);
        this.setConsoleDocument(new ConsoleDocument());
    }

    protected void init() {
        super.init();
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)MavenConsoleImpl.this);
                MavenConsoleImpl.this.initializeConsoleStreams(Display.getDefault());
                MavenConsoleImpl.this.dumpConsole();
            }
        });
    }

    protected void initializeConsoleStreams(Display display) {
        if (!this.initialized) {
            this.setCommandStream(this.newOutputStream());
            this.setErrorStream(this.newOutputStream());
            this.setMessageStream(this.newOutputStream());
            this.commandColor = new Color((Device)display, new RGB(0, 0, 0));
            this.messageColor = new Color((Device)display, new RGB(0, 0, 255));
            this.errorColor = new Color((Device)display, new RGB(255, 0, 0));
            this.getCommandStream().setColor(this.commandColor);
            this.getMessageStream().setColor(this.messageColor);
            this.getErrorStream().setColor(this.errorColor);
            this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
            this.initialized = true;
        }
    }

    protected void dumpConsole() {
        this.setVisible(true);
        ConsoleDocument.ConsoleLine[] lines = this.getConsoleDocument().getLines();
        int i = 0;
        while (i < lines.length) {
            ConsoleDocument.ConsoleLine line = lines[i];
            this.appendLine(line.type, line.line);
            ++i;
        }
        this.getConsoleDocument().clear();
    }

    private void appendLine(final int type, final String line) {
        this.show(false);
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (MavenConsoleImpl.this.isVisible()) {
                    try {
                        switch (type) {
                            case 0: {
                                MavenConsoleImpl.this.getCommandStream().write(line);
                                MavenConsoleImpl.this.getCommandStream().write(10);
                                break;
                            }
                            case 1: {
                                MavenConsoleImpl.this.getMessageStream().write(line);
                                MavenConsoleImpl.this.getMessageStream().write(10);
                                break;
                            }
                            case 2: {
                                MavenConsoleImpl.this.getErrorStream().write(line);
                                MavenConsoleImpl.this.getErrorStream().write(10);
                            }
                        }
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                } else {
                    MavenConsoleImpl.this.getConsoleDocument().appendConsoleLine(type, line);
                }
            }
        });
    }

    public void show(boolean showNoMatterWhat) {
        if (showNoMatterWhat) {
            if (!this.isVisible()) {
                this.showConsole();
            } else {
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)this);
            }
        }
    }

    public void showConsole() {
        boolean exists = false;
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] iConsoleArray = manager.getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConsole element = iConsoleArray[n2];
            if (this == element) {
                exists = true;
            }
            ++n2;
        }
        if (!exists) {
            manager.addConsoles(new IConsole[]{this});
        }
        manager.showConsoleView((IConsole)this);
    }

    public void closeConsole() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.removeConsoles(new IConsole[]{this});
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(this.newLifecycle());
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setFont(JFaceResources.getFontRegistry().get("pref_console_font"));
    }

    private void bringConsoleToFront() {
        if (PlatformUI.isWorkbenchRunning()) {
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            if (!this.isVisible()) {
                manager.addConsoles(new IConsole[]{this});
            }
            manager.showConsoleView((IConsole)this);
        }
    }

    protected void dispose() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                MavenConsoleImpl.this.setVisible(false);
                JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)MavenConsoleImpl.this);
            }
        });
    }

    public void shutdown() {
        super.dispose();
        if (this.commandColor != null) {
            this.commandColor.dispose();
        }
        if (this.messageColor != null) {
            this.messageColor.dispose();
        }
        if (this.errorColor != null) {
            this.errorColor.dispose();
        }
    }

    private DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance((int)3, (int)1, (ULocale)ULocale.getDefault());
    }

    public void debug(String message) {
        if (!M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.debugOutput")) {
            return;
        }
        if (this.showConsoleOnOutput()) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, String.valueOf(this.getDateFormat().format(new Date())) + ": " + message);
        for (IMavenConsoleListener listener : this.listeners) {
            try {
                listener.loggingMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void info(String message) {
        if (this.showConsoleOnOutput()) {
            this.bringConsoleToFront();
        }
        this.appendLine(1, String.valueOf(this.getDateFormat().format(new Date())) + ": " + message);
        for (IMavenConsoleListener listener : this.listeners) {
            try {
                listener.loggingMessage(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void error(String message) {
        if (this.showConsoleOnError()) {
            this.bringConsoleToFront();
        }
        this.appendLine(2, String.valueOf(this.getDateFormat().format(new Date())) + ": " + message);
        for (IMavenConsoleListener listener : this.listeners) {
            try {
                listener.loggingError(message);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean showConsoleOnError() {
        return M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.showConsoleOnErr");
    }

    public boolean showConsoleOnOutput() {
        return M2EUIPluginActivator.getDefault().getPreferenceStore().getBoolean("eclipse.m2.showConsoleOnOutput");
    }

    public IConsoleListener newLifecycle() {
        return new MavenConsoleLifecycle();
    }

    protected void setCommandStream(IOConsoleOutputStream commandStream) {
        this.commandStream = commandStream;
    }

    protected IOConsoleOutputStream getCommandStream() {
        return this.commandStream;
    }

    protected void setMessageStream(IOConsoleOutputStream messageStream) {
        this.messageStream = messageStream;
    }

    protected IOConsoleOutputStream getMessageStream() {
        return this.messageStream;
    }

    protected void setErrorStream(IOConsoleOutputStream errorStream) {
        this.errorStream = errorStream;
    }

    protected IOConsoleOutputStream getErrorStream() {
        return this.errorStream;
    }

    protected void setVisible(boolean visible) {
        this.visible = visible;
    }

    protected boolean isVisible() {
        return this.visible;
    }

    private void setConsoleDocument(ConsoleDocument consoleDocument) {
        this.consoleDocument = consoleDocument;
    }

    protected ConsoleDocument getConsoleDocument() {
        return this.consoleDocument;
    }

    public void addMavenConsoleListener(IMavenConsoleListener listener) {
        this.listeners.remove(listener);
        this.listeners.add(listener);
    }

    public void removeMavenConsoleListener(IMavenConsoleListener listener) {
        this.listeners.remove(listener);
    }

    public class MavenConsoleLifecycle
    implements IConsoleListener {
        public void consolesAdded(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == MavenConsoleImpl.this) {
                    MavenConsoleImpl.this.init();
                }
                ++i;
            }
        }

        public void consolesRemoved(IConsole[] consoles) {
            int i = 0;
            while (i < consoles.length) {
                IConsole console = consoles[i];
                if (console == MavenConsoleImpl.this) {
                    ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener((IConsoleListener)this);
                    MavenConsoleImpl.this.dispose();
                }
                ++i;
            }
        }
    }
}

