/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.util;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2e.core.internal.M2EUtils;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2EErrorDialog
extends MessageDialog {
    private TableViewer errorTable;
    private static final int PROJECT_COL = 0;
    protected static final int TABLE_WIDTH = 700;
    protected String[] COL_NAMES = new String[]{Messages.M2EErrorDialog_column_name, Messages.M2EErrorDialog_column_error};
    protected int[] COL_STYLES = new int[]{16384, 16384};
    protected Map<String, Throwable> errorMap;

    public M2EErrorDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, Map<String, Throwable> errorMap) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.errorMap = errorMap;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        comp.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        gd.widthHint = 750;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)gd);
        gd = new GridData(4, 4, true, true);
        gd.widthHint = 700;
        gd.heightHint = 200;
        this.errorTable = new TableViewer(comp, 68352);
        this.errorTable.getTable().setHeaderVisible(true);
        this.errorTable.getTable().setLinesVisible(true);
        this.errorTable.setContentProvider((IContentProvider)new ErrorTableContentProvider());
        this.errorTable.setLabelProvider((IBaseLabelProvider)new ErrorTableLabelProvider());
        this.errorTable.getControl().setLayoutData((Object)gd);
        this.setupTableColumns();
        this.errorTable.setInput(this.errorMap);
        return comp;
    }

    protected void setupTableColumns() {
        GC gc = new GC((Drawable)this.errorTable.getControl());
        gc.setFont(this.errorTable.getControl().getFont());
        int i = 0;
        while (i < this.COL_NAMES.length) {
            TableColumn col = new TableColumn(this.errorTable.getTable(), this.COL_STYLES[i]);
            col.setText(this.COL_NAMES[i]);
            int width = this.calcStringWidth(gc, i);
            col.setWidth(width);
            ++i;
        }
        gc.dispose();
    }

    private int calcStringWidth(GC gc, int column) {
        int maxWidth = 100;
        if (column == 0) {
            Set<String> keySet = this.errorMap.keySet();
            for (String projectName : keySet) {
                int width = gc.stringExtent((String)projectName).x + 10;
                maxWidth = Math.max(maxWidth, width);
            }
            return maxWidth;
        }
        Collection<Throwable> values = this.errorMap.values();
        for (Throwable t : values) {
            String msg = M2EUtils.getRootCauseMessage((Throwable)t);
            if (msg == null) {
                msg = "";
            }
            int width = gc.stringExtent((String)msg).x + 10;
            maxWidth = Math.max(maxWidth, width);
        }
        return maxWidth;
    }

    class ErrorTableContentProvider
    implements IStructuredContentProvider {
        ErrorTableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                return ((Map)inputElement).keySet().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ErrorTableLabelProvider
    implements ITableLabelProvider {
        ErrorTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return element.toString();
            }
            String msg = M2EUtils.getRootCauseMessage((Throwable)M2EErrorDialog.this.errorMap.get(element));
            return msg == null ? "" : msg;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

