/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.views.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndex;
import org.eclipse.m2e.core.internal.index.nexus.NexusIndexManager;
import org.eclipse.m2e.core.repository.IRepository;
import org.eclipse.m2e.core.repository.IRepositoryRegistry;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.views.nodes.IMavenRepositoryNode;
import org.eclipse.m2e.core.ui.internal.views.nodes.RepositoryNode;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoriesNode
implements IMavenRepositoryNode {
    protected final NexusIndexManager indexManager = (NexusIndexManager)MavenPlugin.getIndexManager();
    protected final IRepositoryRegistry repositoryRegistry = MavenPlugin.getRepositoryRegistry();

    @Override
    public Object[] getChildren() {
        ArrayList<RepositoryNode> mirrorNodes = new ArrayList<RepositoryNode>();
        ArrayList<RepositoryNode> globalRepoNodes = new ArrayList<RepositoryNode>();
        for (IRepository repo : this.getRepositories()) {
            NexusIndex index = this.indexManager.getIndex(repo);
            RepositoryNode node = new RepositoryNode(index);
            if (repo.getMirrorOf() != null) {
                mirrorNodes.add(node);
                continue;
            }
            globalRepoNodes.add(node);
        }
        ArrayList<RepositoryNode> nodes = new ArrayList<RepositoryNode>();
        nodes.addAll(mirrorNodes);
        nodes.addAll(globalRepoNodes);
        return nodes.toArray(new Object[nodes.size()]);
    }

    protected abstract List<IRepository> getRepositories();

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean hasChildren() {
        Object[] kids = this.getChildren();
        return kids != null && kids.length > 0;
    }

    @Override
    public Image getImage() {
        return MavenImages.IMG_INDEXES;
    }

    @Override
    public boolean isUpdating() {
        return false;
    }
}

