/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.internal.lifecyclemapping.discovery.LifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.AbstractProjectScanner;
import org.eclipse.m2e.core.project.LocalProjectScanner;
import org.eclipse.m2e.core.project.MavenProjectInfo;
import org.eclipse.m2e.core.project.ProjectImportConfiguration;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenWizardPage;
import org.eclipse.m2e.core.ui.internal.wizards.MavenImportWizard;
import org.eclipse.m2e.core.ui.internal.wizards.WorkingSetGroup;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IWorkingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImportWizardPage
extends AbstractMavenWizardPage {
    private static final Logger log = LoggerFactory.getLogger(MavenImportWizardPage.class);
    static final Object[] EMPTY = new Object[0];
    protected Combo rootDirectoryCombo;
    protected CheckboxTreeViewer projectTreeViewer;
    private List<String> locations;
    private IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
    private WorkingSetGroup workingSetGroup;
    private boolean showLocation = true;
    private final List<IWorkingSet> workingSets;
    private String rootDirectory;
    private String loadingErrorMessage;

    protected MavenImportWizardPage(ProjectImportConfiguration importConfiguration, List<IWorkingSet> workingSets) {
        super("MavenProjectImportWizardPage", importConfiguration);
        this.workingSets = workingSets;
        this.setTitle(Messages.MavenImportWizardPage_title);
        this.setDescription(Messages.MavenImportWizardPage_desc);
        this.setPageComplete(false);
    }

    public void setShowLocation(boolean showLocation) {
        this.showLocation = showLocation;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)composite);
        if (this.showLocation || this.locations == null || this.locations.isEmpty()) {
            Label selectRootDirectoryLabel = new Label(composite, 0);
            selectRootDirectoryLabel.setLayoutData((Object)new GridData());
            selectRootDirectoryLabel.setText(Messages.wizardImportPageRoot);
            this.rootDirectoryCombo = new Combo(composite, 0);
            this.rootDirectoryCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.rootDirectoryCombo.setFocus();
            this.addFieldWithHistory("rootDirectory", this.rootDirectoryCombo);
            if (this.locations != null && this.locations.size() == 1) {
                this.rootDirectoryCombo.setText(this.locations.get(0));
                this.rootDirectory = this.locations.get(0);
            }
            Button browseButton = new Button(composite, 0);
            browseButton.setText(Messages.wizardImportPageBrowse);
            browseButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DirectoryDialog dialog = new DirectoryDialog(MavenImportWizardPage.this.getShell(), 0);
                    dialog.setText(Messages.wizardImportPageSelectRootFolder);
                    String path = MavenImportWizardPage.this.rootDirectoryCombo.getText();
                    if (path.length() == 0) {
                        path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toPortableString();
                    }
                    dialog.setFilterPath(path);
                    String result = dialog.open();
                    if (result != null) {
                        MavenImportWizardPage.this.rootDirectoryCombo.setText(result);
                        if (MavenImportWizardPage.this.rootDirectoryChanged()) {
                            MavenImportWizardPage.this.scanProjects();
                        }
                    }
                }
            });
            this.rootDirectoryCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                }
            });
            this.rootDirectoryCombo.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (MavenImportWizardPage.this.rootDirectoryChanged()) {
                        MavenImportWizardPage.this.scanProjects();
                    }
                }
            });
            this.rootDirectoryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    if (MavenImportWizardPage.this.rootDirectoryChanged()) {
                        MavenImportWizardPage.this.scanProjects();
                    }
                }

                public void widgetSelected(SelectionEvent e) {
                    if (MavenImportWizardPage.this.rootDirectoryChanged()) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                MavenImportWizardPage.this.scanProjects();
                            }
                        });
                    }
                }
            });
        }
        Label projectsLabel = new Label(composite, 0);
        projectsLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 3, 1));
        projectsLabel.setText(Messages.wizardImportPageProjects);
        this.projectTreeViewer = new CheckboxTreeViewer(composite, 2048);
        this.projectTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                MavenImportWizardPage.this.projectTreeViewer.setSubtreeChecked(event.getElement(), event.getChecked());
                MavenImportWizardPage.this.updateCheckedState();
                MavenImportWizardPage.this.getMappingConfiguration().setSelectedProjects(MavenImportWizardPage.this.getProjects());
                MavenImportWizardPage.this.setPageComplete();
            }
        });
        this.projectTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.getFirstElement() != null) {
                    String errorMsg = MavenImportWizardPage.this.validateProjectInfo((MavenProjectInfo)selection.getFirstElement());
                    if (errorMsg != null) {
                        MavenImportWizardPage.this.setMessage(errorMsg, 2);
                    } else {
                        MavenImportWizardPage.this.setMessage(MavenImportWizardPage.this.loadingErrorMessage, 2);
                    }
                } else {
                    MavenImportWizardPage.this.setMessage(MavenImportWizardPage.this.loadingErrorMessage, 2);
                }
            }
        });
        this.projectTreeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getElements(Object element) {
                if (element instanceof List) {
                    List projects = (List)element;
                    return projects.toArray(new MavenProjectInfo[projects.size()]);
                }
                return EMPTY;
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    List projects = (List)parentElement;
                    return projects.toArray(new MavenProjectInfo[projects.size()]);
                }
                if (parentElement instanceof MavenProjectInfo) {
                    MavenProjectInfo mavenProjectInfo = (MavenProjectInfo)parentElement;
                    Collection projects = mavenProjectInfo.getProjects();
                    return projects.toArray(new MavenProjectInfo[projects.size()]);
                }
                return EMPTY;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object parentElement) {
                if (parentElement instanceof List) {
                    List projects = (List)parentElement;
                    return !projects.isEmpty();
                }
                if (parentElement instanceof MavenProjectInfo) {
                    MavenProjectInfo mavenProjectInfo = (MavenProjectInfo)parentElement;
                    return !mavenProjectInfo.getProjects().isEmpty();
                }
                return false;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.projectTreeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ProjectLabelProvider()));
        Tree projectTree = this.projectTreeViewer.getTree();
        GridData projectTreeData = new GridData(4, 4, true, true, 2, 3);
        projectTreeData.heightHint = 250;
        projectTreeData.widthHint = 500;
        projectTree.setLayoutData((Object)projectTreeData);
        Button selectAllButton = new Button(composite, 0);
        selectAllButton.setLayoutData((Object)new GridData(4, 128, false, false));
        selectAllButton.setText(Messages.wizardImportPageSelectAll);
        selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenImportWizardPage.this.projectTreeViewer.expandAll();
                MavenImportWizardPage.this.setAllChecked(true);
                MavenImportWizardPage.this.validate();
            }
        });
        Button deselectAllButton = new Button(composite, 0);
        deselectAllButton.setLayoutData((Object)new GridData(4, 128, false, false));
        deselectAllButton.setText(Messages.wizardImportPageDeselectAll);
        deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenImportWizardPage.this.setAllChecked(false);
                MavenImportWizardPage.this.setPageComplete(false);
            }
        });
        Button refreshButton = new Button(composite, 0);
        refreshButton.setLayoutData((Object)new GridData(4, 128, false, true));
        refreshButton.setText(Messages.wizardImportPageRefresh);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MavenImportWizardPage.this.scanProjects();
            }
        });
        this.workingSetGroup = new WorkingSetGroup(composite, this.workingSets, this.getShell());
        this.createAdvancedSettings(composite, new GridData(4, 128, false, false, 3, 1));
        this.resolverConfigurationComponent.template.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MavenImportWizardPage.this.validate();
                    }
                });
            }
        });
        if (this.locations != null && !this.locations.isEmpty()) {
            this.scanProjects();
        }
    }

    protected boolean rootDirectoryChanged() {
        String _rootDirectory = this.rootDirectory;
        this.rootDirectory = this.rootDirectoryCombo.getText().trim();
        return _rootDirectory == null || !_rootDirectory.equals(this.rootDirectory);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.workingSetGroup.dispose();
    }

    protected void scanProjects() {
        final AbstractProjectScanner<MavenProjectInfo> projectScanner = this.getProjectScanner();
        try {
            this.getWizard().getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    projectScanner.run(monitor);
                    ((MavenImportWizard)MavenImportWizardPage.this.getWizard()).scanProjects(this.getProjects(projectScanner.getProjects()), monitor);
                }

                List<MavenProjectInfo> getProjects(Collection<MavenProjectInfo> input) {
                    ArrayList<MavenProjectInfo> toRet = new ArrayList<MavenProjectInfo>();
                    for (MavenProjectInfo info : input) {
                        toRet.add(info);
                        toRet.addAll(this.getProjects(info.getProjects()));
                    }
                    return toRet;
                }
            });
            this.projectTreeViewer.setInput((Object)projectScanner.getProjects());
            this.projectTreeViewer.expandAll();
            this.setAllChecked(true);
            this.setPageComplete();
            this.setErrorMessage(null);
            this.setMessage(null);
            this.loadingErrorMessage = null;
            LifecycleMappingConfiguration config = ((MavenImportWizard)this.getWizard()).getMappingConfiguration();
            ArrayList errors = new ArrayList(projectScanner.getErrors());
            if (config != null) {
                errors.addAll(config.getErrors().values());
            }
            if (!errors.isEmpty()) {
                StringBuffer sb = new StringBuffer(NLS.bind((String)Messages.wizardImportPageScanningErrors, (Object)errors.size()));
                int n = 1;
                for (Throwable ex : errors) {
                    String msg;
                    if (ex instanceof CoreException) {
                        msg = ((CoreException)ex).getStatus().getMessage();
                        sb.append("\n  ").append(n).append(" ").append(msg.trim());
                    } else {
                        msg = ex.getMessage() == null ? ex.toString() : ex.getMessage();
                        sb.append("\n  ").append(n).append(" ").append(msg.trim());
                    }
                    ++n;
                }
                this.loadingErrorMessage = sb.toString();
                this.setMessage(sb.toString(), 2);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException ex) {
            String msg;
            Throwable e;
            Throwable throwable = e = ex.getCause() == null ? ex : ex.getCause();
            if (e instanceof CoreException) {
                msg = e.getMessage();
                log.error(msg, e);
            } else {
                msg = "Scanning error " + projectScanner.getDescription() + "; " + e.toString();
                log.error(msg, e);
            }
            this.projectTreeViewer.setInput(null);
            this.setPageComplete(false);
            this.setErrorMessage(msg);
        }
    }

    void setAllChecked(boolean state) {
        List input = (List)this.projectTreeViewer.getInput();
        if (input != null) {
            for (MavenProjectInfo mavenProjectInfo : input) {
                this.projectTreeViewer.setSubtreeChecked((Object)mavenProjectInfo, state);
            }
            this.updateCheckedState();
        }
    }

    void updateCheckedState() {
        Object[] elements = this.projectTreeViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            MavenProjectInfo info;
            Object element = elements[i];
            if (element instanceof MavenProjectInfo && (this.isWorkspaceFolder(info = (MavenProjectInfo)element) || this.isAlreadyExists(info))) {
                this.projectTreeViewer.setChecked((Object)info, false);
            }
            ++i;
        }
    }

    boolean isWorkspaceFolder(MavenProjectInfo info) {
        File parentFile;
        File pomFile;
        return info != null && (pomFile = info.getPomFile()) != null && (parentFile = pomFile.getParentFile()).getAbsolutePath().equals(this.workspaceRoot.getLocation().toFile().getAbsolutePath());
    }

    boolean isAlreadyExists(MavenProjectInfo info) {
        if (info != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            String name = this.getImportConfiguration().getProjectName(info.getModel());
            if (name != null && name.length() > 0) {
                IProject project = workspace.getRoot().getProject(name);
                return project.exists();
            }
        }
        return false;
    }

    boolean isAlreadyImported(MavenProjectInfo info) {
        if (info != null) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] iProjectArray = workspace.getRoot().getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean ok;
                IProject project = iProjectArray[n2];
                URI mavenuri = info.getPomFile().getParentFile().toURI();
                if (mavenuri.toString().endsWith("/")) {
                    try {
                        mavenuri = new URI(mavenuri.toString().substring(0, mavenuri.toString().length() - 1));
                    }
                    catch (URISyntaxException ex) {
                        log.error(ex.getMessage(), (Throwable)ex);
                    }
                }
                boolean bl = ok = project.exists() && project.getLocationURI().equals(mavenuri);
                if (ok) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected AbstractProjectScanner<MavenProjectInfo> getProjectScanner() {
        File root = this.workspaceRoot.getLocation().toFile();
        MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
        if (this.showLocation) {
            String location = this.rootDirectoryCombo.getText().trim();
            if (location.length() > 0) {
                return new LocalProjectScanner(root, location, false, modelManager);
            }
        } else if (this.locations != null && !this.locations.isEmpty()) {
            return new LocalProjectScanner(root, this.locations, true, modelManager);
        }
        return new AbstractProjectScanner<MavenProjectInfo>(){

            public String getDescription() {
                return "";
            }

            public void run(IProgressMonitor monitor) throws InterruptedException {
            }
        };
    }

    public Collection<MavenProjectInfo> getProjects() {
        ArrayList<MavenProjectInfo> checkedProjects = new ArrayList<MavenProjectInfo>();
        Object[] objectArray = this.projectTreeViewer.getCheckedElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            checkedProjects.add((MavenProjectInfo)o);
            ++n2;
        }
        return checkedProjects;
    }

    protected String validateProjectInfo(MavenProjectInfo info) {
        if (info != null) {
            if (this.isWorkspaceFolder(info)) {
                String projectName = this.getImportConfiguration().getProjectName(info.getModel());
                return NLS.bind((String)Messages.wizardImportValidatorWorkspaceFolder, (Object)projectName);
            }
            if (this.isAlreadyImported(info)) {
                String projectName = this.getImportConfiguration().getProjectName(info.getModel());
                return NLS.bind((String)Messages.wizardImportValidatorProjectImported, (Object)projectName);
            }
            if (this.isAlreadyExists(info)) {
                String projectName = this.getImportConfiguration().getProjectName(info.getModel());
                return NLS.bind((String)Messages.wizardImportValidatorProjectExists, (Object)projectName);
            }
        }
        return null;
    }

    protected void validate() {
        Object[] elements = this.projectTreeViewer.getCheckedElements();
        int i = 0;
        while (i < elements.length) {
            String errorMsg;
            Object element = elements[i];
            if (element instanceof MavenProjectInfo && (errorMsg = this.validateProjectInfo((MavenProjectInfo)element)) != null) {
                this.setPageComplete(false);
                return;
            }
            ++i;
        }
        this.setMessage(null);
        this.setPageComplete();
        this.projectTreeViewer.refresh();
    }

    public IWizardPage getNextPage() {
        IWizardPage next = super.getNextPage();
        LifecycleMappingConfiguration config = this.getMappingConfiguration();
        if (config == null || config.isMappingComplete(true) && config.getAllProposals().isEmpty()) {
            next = null;
        }
        return next;
    }

    void setPageComplete() {
        Object[] checkedElements = this.projectTreeViewer.getCheckedElements();
        this.setPageComplete(checkedElements != null && checkedElements.length > 0);
    }

    LifecycleMappingConfiguration getMappingConfiguration() {
        return ((MavenImportWizard)this.getWizard()).getMappingConfiguration();
    }

    class ProjectLabelProvider
    extends LabelProvider
    implements IColorProvider,
    DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof MavenProjectInfo) {
                MavenProjectInfo info = (MavenProjectInfo)element;
                if (info.getProfiles().isEmpty()) {
                    return String.valueOf(info.getLabel()) + " - " + this.getId(info);
                }
                return String.valueOf(info.getLabel()) + " - " + this.getId(info) + "  " + info.getProfiles();
            }
            return super.getText(element);
        }

        private String getId(MavenProjectInfo info) {
            Model model = info.getModel();
            String groupId = model.getGroupId();
            String artifactId = model.getArtifactId();
            String version = model.getVersion();
            String packaging = model.getPackaging();
            Parent parent = model.getParent();
            if (groupId == null && parent != null) {
                groupId = parent.getGroupId();
            }
            if (groupId == null) {
                groupId = Messages.MavenImportWizardPage_inherited;
            }
            if (version == null && parent != null) {
                version = parent.getVersion();
            }
            if (version == null) {
                version = Messages.MavenImportWizardPage_inherited;
            }
            return String.valueOf(groupId) + ":" + artifactId + ":" + version + ":" + packaging;
        }

        public Color getForeground(Object element) {
            if (element instanceof MavenProjectInfo) {
                MavenProjectInfo info = (MavenProjectInfo)element;
                if (MavenImportWizardPage.this.isWorkspaceFolder(info)) {
                    return Display.getDefault().getSystemColor(3);
                }
                if (MavenImportWizardPage.this.isAlreadyExists(info)) {
                    return Display.getDefault().getSystemColor(15);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof MavenProjectInfo) {
                MavenProjectInfo info = (MavenProjectInfo)element;
                StyledString ss = new StyledString();
                ss.append(String.valueOf(info.getLabel()) + "  ");
                ss.append(this.getId(info), StyledString.DECORATIONS_STYLER);
                if (!info.getProfiles().isEmpty()) {
                    ss.append(" - " + info.getProfiles(), StyledString.QUALIFIER_STYLER);
                }
                return ss;
            }
            return null;
        }
    }
}

