/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.apache.maven.model.Model;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.MavenModelManager;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.wizards.MavenPomWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenPomWizard
extends Wizard
implements INewWizard {
    private static final Logger log = LoggerFactory.getLogger(MavenPomWizard.class);
    private MavenPomWizardPage artifactPage;
    private ISelection selection;

    public MavenPomWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.MavenPomWizard_title);
    }

    public void addPages() {
        this.artifactPage = new MavenPomWizardPage(this.selection);
        this.addPage((IWizardPage)this.artifactPage);
    }

    public boolean performFinish() {
        final String projectName = this.artifactPage.getProject();
        final Model model = this.artifactPage.getModel();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                monitor.beginTask(Messages.MavenPomWizard_task, 1);
                try {
                    try {
                        MavenPomWizard.this.doFinish(projectName, model, monitor);
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.MavenPomWizard_error_title, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    void doFinish(String projectName, Model model, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(projectName));
        if (!resource.exists() || (resource.getType() & 2 | 4) == 0) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, NLS.bind((String)Messages.MavenPomWizard_status_not_exists, (Object)projectName), null));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path("pom.xml"));
        if (file.exists()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, Messages.MavenPomWizard_error_exists, null));
        }
        File pom = file.getLocation().toFile();
        try {
            MavenModelManager modelManager = MavenPlugin.getMavenModelManager();
            modelManager.createMavenModel(file, model);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                    }
                    catch (PartInitException partInitException) {}
                }
            });
        }
        catch (Exception ex) {
            log.error("Unable to create POM " + pom + "; " + ex.getMessage(), (Throwable)ex);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

