/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.project.configurator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.ConfigurationContainer;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.IMaven;
import org.eclipse.m2e.core.embedder.IMavenConfiguration;
import org.eclipse.m2e.core.internal.Messages;
import org.eclipse.m2e.core.internal.lifecyclemapping.LifecycleMappingFactory;
import org.eclipse.m2e.core.internal.markers.IMavenMarkerManager;
import org.eclipse.m2e.core.lifecyclemapping.model.IPluginExecutionMetadata;
import org.eclipse.m2e.core.lifecyclemapping.model.PluginExecutionAction;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.AbstractBuildParticipant;
import org.eclipse.m2e.core.project.configurator.ILifecycleMappingConfiguration;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractProjectConfigurator
implements IExecutableExtension,
IMavenProjectChangedListener {
    private static final Logger log = LoggerFactory.getLogger(AbstractProjectConfigurator.class);
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_CLASS = "class";
    private String id;
    private String name;
    protected IMavenProjectRegistry projectManager;
    protected IMavenConfiguration mavenConfiguration;
    protected IMavenMarkerManager markerManager;
    protected IMaven maven = MavenPlugin.getMaven();

    public void setProjectManager(IMavenProjectRegistry projectManager) {
        this.projectManager = projectManager;
    }

    public void setMavenConfiguration(IMavenConfiguration mavenConfiguration) {
        this.mavenConfiguration = mavenConfiguration;
    }

    public void setMarkerManager(IMavenMarkerManager markerManager) {
        this.markerManager = markerManager;
    }

    public abstract void configure(ProjectConfigurationRequest var1, IProgressMonitor var2) throws CoreException;

    public void unconfigure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
    }

    public void mavenProjectChanged(MavenProjectChangedEvent event, IProgressMonitor monitor) throws CoreException {
    }

    @Override
    public final void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        int i = 0;
        while (i < events.length) {
            try {
                this.mavenProjectChanged(events[i], monitor);
            }
            catch (CoreException ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
            ++i;
        }
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.getClass().getName();
        }
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        this.id = config.getAttribute(ATTR_ID);
        this.name = config.getAttribute(ATTR_NAME);
    }

    public static void addNature(IProject project, String natureId, IProgressMonitor monitor) throws CoreException {
        if (!project.hasNature(natureId)) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 1, prevNatures.length);
            newNatures[0] = natureId;
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        }
    }

    protected <T> T getParameterValue(String parameter, Class<T> asType, MavenSession session, MojoExecution mojoExecution) throws CoreException {
        PluginExecution execution = new PluginExecution();
        execution.setConfiguration((Object)mojoExecution.getConfiguration());
        return this.maven.getMojoParameterValue(parameter, asType, session, mojoExecution.getPlugin(), (ConfigurationContainer)execution, mojoExecution.getGoal());
    }

    protected void assertHasNature(IProject project, String natureId) throws CoreException {
        if (project.getNature(natureId) == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.m2e.core", -1, String.valueOf(Messages.AbstractProjectConfigurator_error_missing_nature) + natureId, null));
        }
    }

    public String toString() {
        return String.valueOf(this.getId()) + ":" + this.name;
    }

    public AbstractBuildParticipant getBuildParticipant(IMavenProjectFacade projectFacade, MojoExecution execution, IPluginExecutionMetadata executionMetadata) {
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractProjectConfigurator other = (AbstractProjectConfigurator)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    protected List<MojoExecution> getMojoExecutions(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IMavenProjectFacade projectFacade = request.getMavenProjectFacade();
        Map<String, Set<MojoExecutionKey>> configuratorExecutions = AbstractProjectConfigurator.getConfiguratorExecutions(projectFacade);
        ArrayList<MojoExecution> executions = new ArrayList<MojoExecution>();
        Set<MojoExecutionKey> executionKeys = configuratorExecutions.get(this.id);
        if (executionKeys != null) {
            for (MojoExecutionKey key : executionKeys) {
                executions.add(projectFacade.getMojoExecution(key, monitor));
            }
        }
        return executions;
    }

    public static Map<String, Set<MojoExecutionKey>> getConfiguratorExecutions(IMavenProjectFacade projectFacade) {
        HashMap<String, Set<MojoExecutionKey>> configuratorExecutions = new HashMap<String, Set<MojoExecutionKey>>();
        Map<MojoExecutionKey, List<IPluginExecutionMetadata>> executionMapping = projectFacade.getMojoExecutionMapping();
        for (Map.Entry<MojoExecutionKey, List<IPluginExecutionMetadata>> entry : executionMapping.entrySet()) {
            List<IPluginExecutionMetadata> metadatas = entry.getValue();
            if (metadatas == null) continue;
            for (IPluginExecutionMetadata metadata : metadatas) {
                String configuratorId;
                if (metadata.getAction() != PluginExecutionAction.configurator || (configuratorId = LifecycleMappingFactory.getProjectConfiguratorId(metadata)) == null) continue;
                LinkedHashSet<MojoExecutionKey> executions = (LinkedHashSet<MojoExecutionKey>)configuratorExecutions.get(configuratorId);
                if (executions == null) {
                    executions = new LinkedHashSet<MojoExecutionKey>();
                    configuratorExecutions.put(configuratorId, executions);
                }
                executions.add(entry.getKey());
            }
        }
        return configuratorExecutions;
    }

    public boolean hasConfigurationChanged(IMavenProjectFacade newFacade, ILifecycleMappingConfiguration oldProjectConfiguration, MojoExecutionKey key, IProgressMonitor monitor) {
        try {
            Xpp3Dom configuration;
            Xpp3Dom oldConfiguration = oldProjectConfiguration.getMojoExecutionConfiguration(key);
            MojoExecution mojoExecution = newFacade.getMojoExecution(key, monitor);
            Xpp3Dom xpp3Dom = configuration = mojoExecution != null ? mojoExecution.getConfiguration() : null;
            return configuration != null ? !configuration.equals((Object)oldConfiguration) : oldConfiguration != null;
        }
        catch (CoreException coreException) {
            return true;
        }
    }
}

