/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.launch;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.m2e.core.embedder.IMavenLauncherConfiguration;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenLauncherConfigurationHandler
implements IMavenLauncherConfiguration {
    private String mainType;
    private String mainRealm;
    private LinkedHashMap<String, List<String>> realms = new LinkedHashMap();
    private List<String> forcedEntries = new ArrayList<String>();
    private List<String> curEntries = this.forcedEntries;

    public void addArchiveEntry(String entry) {
        this.curEntries.add(entry);
    }

    public void addProjectEntry(IMavenProjectFacade facade) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder output = root.getFolder(facade.getOutputLocation());
        if (output.isAccessible()) {
            this.addArchiveEntry(output.getLocation().toFile().getAbsolutePath());
        }
    }

    public void addRealm(String realm) {
        if (!this.realms.containsKey(realm)) {
            this.curEntries = new ArrayList<String>();
            this.realms.put(realm, this.curEntries);
        }
    }

    public void setMainType(String type, String realm) {
        this.mainType = type;
        this.mainRealm = realm;
    }

    public void save(OutputStream os) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(os, "UTF-8"));
        out.write(NLS.bind((String)"main is {0} from {1}\n", (Object)this.mainType, (Object)this.mainRealm));
        for (Map.Entry<String, List<String>> realm : this.realms.entrySet()) {
            if ("]launcher".equals(realm.getKey())) continue;
            out.write(NLS.bind((String)"[{0}]\n", (Object)realm.getKey()));
            if (this.mainRealm.equals(realm.getKey())) {
                for (String entry : this.forcedEntries) {
                    out.write(NLS.bind((String)"load {0}\n", (Object)entry));
                }
            }
            for (String entry : realm.getValue()) {
                out.write(NLS.bind((String)"load {0}\n", (Object)entry));
            }
        }
        out.flush();
    }

    public String getMainReal() {
        return this.mainRealm;
    }

    public List<String> getRealmEntries(String realm) {
        return this.realms.get(realm);
    }
}

