/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.udc;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.m2e.core.internal.MavenPluginActivator;
import org.eclipse.m2e.core.project.IMavenProjectChangedListener;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.MavenProjectChangedEvent;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.eclipse.m2e.internal.udc.MavenUsageDataCollectorActivator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenListener
implements IMavenProjectChangedListener {
    private static final Logger log = LoggerFactory.getLogger(MavenListener.class);
    private static final String SEPARATOR = ":";
    private static final String PLUGINS = "m2e.plugins";
    private static final String PACKAGING = "m2e.packaging";
    private static final String VERSION = MavenPluginActivator.getVersion();
    private static final String ID = "org.eclipse.m2e.core";

    public void mavenProjectChanged(MavenProjectChangedEvent[] events, IProgressMonitor monitor) {
        SubMonitor subMon = SubMonitor.convert((IProgressMonitor)monitor, (int)(2 * events.length));
        MavenUsageDataCollectorActivator activator = MavenUsageDataCollectorActivator.getDefault();
        try {
            MavenProjectChangedEvent[] mavenProjectChangedEventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                MavenProjectChangedEvent event = mavenProjectChangedEventArray[n2];
                if (monitor.isCanceled()) {
                    return;
                }
                if (event.getKind() == 1) {
                    IMavenProjectFacade facade = event.getMavenProject();
                    activator.recordEvent(facade.getPackaging(), PACKAGING, facade.getPackaging(), ID, VERSION);
                    subMon.worked(1);
                    if (facade.getMojoExecutionMapping() != null) {
                        for (MojoExecutionKey key : facade.getMojoExecutionMapping().keySet()) {
                            activator.recordEvent(String.valueOf(key.getGoal()) + SEPARATOR + key.getExecutionId() + SEPARATOR + key.getLifecyclePhase(), PLUGINS, String.valueOf(key.getGroupId()) + SEPARATOR + key.getArtifactId() + SEPARATOR + key.getVersion(), ID, VERSION);
                        }
                    }
                    subMon.worked(1);
                    if (subMon.isCanceled()) {
                        return;
                    }
                }
                try {
                    ++n2;
                    continue;
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
                break;
            }
        }
        finally {
            subMon.done();
        }
    }
}

