/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.beans.SimpleBeanInfo;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.results.ListResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.SnapshotInfo;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.MessageUtil;
import org.eclipse.mat.util.Units;

@CommandName(value="heap_dump_overview")
@Category(value="__hidden__")
public class HeapDumpInfoQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;

    public IResult execute(IProgressListener listener) throws Exception {
        SnapshotInfo info = this.snapshot.getSnapshotInfo();
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ArrayList<TextEntry> entries = new ArrayList<TextEntry>(12);
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_UsedHeapDump, this.getUsedHeapInMb(info.getUsedHeapSize())));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumObjects, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumObjectsFormat, (Object[])new Object[]{info.getNumberOfObjects()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumClasses, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumClassesFormat, (Object[])new Object[]{info.getNumberOfClasses()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumClassLoaders, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumClassLoadersFormat, (Object[])new Object[]{info.getNumberOfClassLoaders()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_NumGCRoots, MessageUtil.format((String)Messages.HeapDumpInfoQuery_NumGCRootsFormat, (Object[])new Object[]{info.getNumberOfGCRoots()})));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_HeapFormat, info.getProperty("$heapFormat").toString()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_JVMVersion, info.getJvmInfo()));
        if (info.getCreationDate() != null) {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Time, MessageUtil.format((String)Messages.HeapDumpInfoQuery_TimeFormat, (Object[])new Object[]{info.getCreationDate()})));
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Date, MessageUtil.format((String)Messages.HeapDumpInfoQuery_DateFormat, (Object[])new Object[]{info.getCreationDate()})));
        } else {
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Time, null));
            entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_Date, null));
        }
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_IdentifierSize, this.getSize(info.getIdentifierSize())));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_FilePath, info.getPath()));
        entries.add(new TextEntry(Messages.HeapDumpInfoQuery_Column_FileLength, MessageUtil.format((String)Messages.HeapDumpInfoQuery_FileLengthFormat, (Object[])new Object[]{new File(info.getPath()).length()})));
        return new ListResult(TextEntry.class, entries, new String[]{"propertyName", "propertyValue"});
    }

    private String getUsedHeapInMb(long usedHeapSize) {
        return Units.Storage.of((long)usedHeapSize).format(usedHeapSize);
    }

    private String getSize(int identifierSize) {
        switch (identifierSize) {
            case 0: {
                return null;
            }
            case 4: {
                return Messages.HeapDumpInfoQuery_32bit;
            }
            case 8: {
                return Messages.HeapDumpInfoQuery_64bit;
            }
        }
        return String.valueOf(identifierSize);
    }

    public static class TextEntry {
        private String propertyValue;
        private String propertyName;

        public TextEntry(String propertyName, String propertyValue) {
            this.propertyName = propertyName;
            this.propertyValue = propertyValue;
        }

        public String getPropertyValue() {
            return this.propertyValue;
        }

        public String getPropertyName() {
            return this.propertyName;
        }
    }

    public static class TextEntryBeanInfo
    extends SimpleBeanInfo {
        public PropertyDescriptor[] getPropertyDescriptors() {
            PropertyDescriptor[] ret;
            try {
                PropertyDescriptor propertyDescriptor1 = new PropertyDescriptor("propertyName", TextEntry.class, "getPropertyName", null){

                    public String getDisplayName() {
                        return Messages.HeapDumpInfoQuery_PropertyName;
                    }
                };
                PropertyDescriptor propertyDescriptor2 = new PropertyDescriptor("propertyValue", TextEntry.class, "getPropertyValue", null){

                    public String getDisplayName() {
                        return Messages.HeapDumpInfoQuery_ProperyValue;
                    }
                };
                ret = new PropertyDescriptor[]{propertyDescriptor1, propertyDescriptor2};
            }
            catch (IntrospectionException introspectionException) {
                ret = null;
            }
            return ret;
        }
    }
}

